/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.repository;

import com.google.common.base.Throwables;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import org.jberet.util.BatchUtil;

final class TableColumns {
    static final String _id = "_id";
    static final String SEQ = "seq";
    static final String JOB_INSTANCE_ID_SEQ = "JOB_INSTANCE_ID_SEQ";
    static final String JOB_EXECUTION_ID_SEQ = "JOB_EXECUTION_ID_SEQ";
    static final String STEP_EXECUTION_ID_SEQ = "STEP_EXECUTION_ID_SEQ";
    static final int EXECUTION_EXCEPTION_LENGTH_LIMIT = 2048;
    static final String JOB_INSTANCE = "JOB_INSTANCE";
    static final String JOBNAME = "JOBNAME";
    static final String APPLICATIONNAME = "APPLICATIONNAME";
    static final String JOB_EXECUTION = "JOB_EXECUTION";
    static final String JOBINSTANCEID = "JOBINSTANCEID";
    static final String CREATETIME = "CREATETIME";
    static final String LASTUPDATEDTIME = "LASTUPDATEDTIME";
    static final String JOBPARAMETERS = "JOBPARAMETERS";
    static final String RESTARTPOSITION = "RESTARTPOSITION";
    static final String STEP_EXECUTION = "STEP_EXECUTION";
    static final String STEPEXECUTIONID = "STEPEXECUTIONID";
    static final String JOBEXECUTIONID = "JOBEXECUTIONID";
    static final String STEPNAME = "STEPNAME";
    static final String STARTTIME = "STARTTIME";
    static final String ENDTIME = "ENDTIME";
    static final String BATCHSTATUS = "BATCHSTATUS";
    static final String EXITSTATUS = "EXITSTATUS";
    static final String EXECUTIONEXCEPTION = "EXECUTIONEXCEPTION";
    static final String PERSISTENTUSERDATA = "PERSISTENTUSERDATA";
    static final String READCOUNT = "READCOUNT";
    static final String WRITECOUNT = "WRITECOUNT";
    static final String COMMITCOUNT = "COMMITCOUNT";
    static final String ROLLBACKCOUNT = "ROLLBACKCOUNT";
    static final String READSKIPCOUNT = "READSKIPCOUNT";
    static final String PROCESSSKIPCOUNT = "PROCESSSKIPCOUNT";
    static final String FILTERCOUNT = "FILTERCOUNT";
    static final String WRITESKIPCOUNT = "WRITESKIPCOUNT";
    static final String READERCHECKPOINTINFO = "READERCHECKPOINTINFO";
    static final String WRITERCHECKPOINTINFO = "WRITERCHECKPOINTINFO";
    static final String PARTITION_EXECUTION = "PARTITION_EXECUTION";
    static final String PARTITIONEXECUTIONID = "PARTITIONEXECUTIONID";

    private TableColumns() {
    }

    static String formatException(Exception exception) {
        Charset charset;
        if (exception == null) {
            return null;
        }
        Object asString = Throwables.getStackTraceAsString((Throwable)exception);
        byte[] asBytes = ((String)asString).getBytes(charset = Charset.defaultCharset());
        if (asBytes.length <= 2048) {
            return asString;
        }
        asString = String.valueOf(exception) + BatchUtil.NL + String.valueOf(Throwables.getRootCause((Throwable)exception));
        asBytes = ((String)asString).getBytes(charset);
        if (asBytes.length <= 2048) {
            return asString;
        }
        ByteBuffer bb = ByteBuffer.wrap(asBytes, 0, 2048);
        CharBuffer cb = CharBuffer.allocate(2048);
        CharsetDecoder decoder = charset.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.IGNORE);
        decoder.decode(bb, cb, true);
        decoder.flush(cb);
        return new String(cb.array(), 0, cb.position());
    }
}

