/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.predicateindex;

import java.util.Arrays;
import org.infinispan.objectfilter.impl.FilterSubscriptionImpl;
import org.infinispan.objectfilter.impl.aggregation.FieldAccumulator;
import org.infinispan.objectfilter.impl.predicateindex.MatcherEvalContext;
import org.infinispan.objectfilter.impl.predicateindex.be.BENode;
import org.infinispan.objectfilter.impl.predicateindex.be.BETree;

public final class FilterEvalContext {
    private static final int[] FALSE_TREE = new int[]{-1};
    public final BETree beTree;
    public final int[] treeCounters;
    public final MatcherEvalContext<?, ?, ?> matcherContext;
    private final Object[] projection;
    private final Comparable[] sortProjection;
    public FieldAccumulator[] acc;

    public FilterEvalContext(MatcherEvalContext<?, ?, ?> matcherContext, FilterSubscriptionImpl filterSubscription) {
        this.matcherContext = matcherContext;
        this.beTree = filterSubscription.getBETree();
        if (this.checkEventType(matcherContext.getEventType(), filterSubscription.getEventTypes())) {
            int[] childCounters = this.beTree.getChildCounters();
            this.treeCounters = Arrays.copyOf(childCounters, childCounters.length);
        } else {
            this.treeCounters = FALSE_TREE;
            for (BENode node : this.beTree.getNodes()) {
                node.suspendSubscription(this);
            }
        }
        this.projection = filterSubscription.getProjection() != null ? new Object[filterSubscription.getProjection().length] : null;
        this.sortProjection = filterSubscription.getSortFields() != null ? new Comparable[filterSubscription.getSortFields().length] : null;
    }

    private boolean checkEventType(Object eventType, Object[] eventTypes) {
        if (eventTypes == null) {
            return true;
        }
        if (eventType == null) {
            return false;
        }
        for (Object t : eventTypes) {
            if (!eventType.equals(t)) continue;
            return true;
        }
        return false;
    }

    public boolean isMatching() {
        return this.treeCounters[0] == 0;
    }

    public Object[] getProjection() {
        return this.projection;
    }

    public Comparable[] getSortProjection() {
        return this.sortProjection;
    }

    void processProjection(int position, Object value) {
        FieldAccumulator a;
        Object[] projection = this.projection;
        if (projection == null) {
            projection = this.sortProjection;
        } else if (position >= projection.length) {
            position -= projection.length;
            projection = this.sortProjection;
        }
        if (this.acc != null && (a = this.acc[position]) != null) {
            a.update(projection, value);
            return;
        }
        if (projection[position] == null) {
            projection[position] = value;
        }
    }
}

