/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.manager;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.infinispan.AdvancedCache;
import org.infinispan.cache.impl.InvocationHelper;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.metadata.impl.InternalMetadataImpl;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.transaction.impl.FakeJTATransaction;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.impl.TransactionCoordinator;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.NAMED_CACHE)
public class PreloadManager {
    public static final long PRELOAD_FLAGS = FlagBitSets.CACHE_MODE_LOCAL | FlagBitSets.SKIP_OWNERSHIP_CHECK | FlagBitSets.IGNORE_RETURN_VALUES | FlagBitSets.SKIP_CACHE_STORE | FlagBitSets.SKIP_LOCKING | FlagBitSets.SKIP_XSITE_BACKUP | FlagBitSets.IRAC_STATE;
    public static final long PRELOAD_WITHOUT_INDEXING_FLAGS = EnumUtil.mergeBitSets((long)PRELOAD_FLAGS, (long)FlagBitSets.SKIP_INDEXING);
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    @Inject
    Configuration configuration;
    @Inject
    protected PersistenceManager persistenceManager;
    @Inject
    TimeService timeService;
    @Inject
    protected ComponentRef<AdvancedCache<?, ?>> cache;
    @Inject
    CommandsFactory commandsFactory;
    @Inject
    KeyPartitioner keyPartitioner;
    @Inject
    InvocationContextFactory invocationContextFactory;
    @Inject
    InvocationHelper invocationHelper;
    @Inject
    TransactionCoordinator transactionCoordinator;
    @Inject
    TransactionManager transactionManager;
    @Inject
    TransactionTable transactionTable;
    private volatile boolean fullyPreloaded;

    @Start
    public void start() {
        this.fullyPreloaded = false;
        CompletionStages.join(this.doPreload());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletionStage<Void> doPreload() {
        Flowable<MarshallableEntry<Object, Object>> publisher = this.persistenceManager.preloadPublisher();
        long start = this.timeService.time();
        long maxEntries = this.getMaxEntries();
        long flags = this.getFlagsForStateInsertion();
        AdvancedCache<?, ?> tmpCache = this.cache.wired().withStorageMediaType();
        DataConversion keyDataConversion = tmpCache.getKeyDataConversion();
        DataConversion valueDataConversion = tmpCache.getValueDataConversion();
        Transaction outerTransaction = this.suspendIfNeeded();
        try {
            CompletionStage<Void> completionStage = Flowable.fromPublisher(publisher).take(maxEntries).concatMapSingle(me -> this.preloadEntry(flags, (MarshallableEntry<Object, Object>)me, keyDataConversion, valueDataConversion)).count().toCompletionStage().thenAccept(insertAmount -> {
                this.fullyPreloaded = insertAmount < maxEntries;
                log.debugf("Preloaded %d keys in %s", insertAmount, Util.prettyPrintTime((long)this.timeService.timeDuration(start, TimeUnit.MILLISECONDS)));
            });
            return completionStage;
        }
        finally {
            this.resumeIfNeeded(outerTransaction);
        }
    }

    private Single<?> preloadEntry(long flags, MarshallableEntry<Object, Object> me, DataConversion keyDataConversion, DataConversion valueDataConversion) {
        CompletionStage<Object> stage;
        InternalMetadataImpl metadata = new InternalMetadataImpl(me.getMetadata(), me.created(), me.lastUsed());
        Object key = keyDataConversion.toStorage(me.getKey());
        Object value = valueDataConversion.toStorage(me.getValue());
        PutKeyValueCommand cmd = this.commandsFactory.buildPutKeyValueCommand(key, value, this.keyPartitioner.getSegment(key), metadata, flags);
        cmd.setInternalMetadata(me.getInternalMetadata());
        if (this.configuration.transaction().transactionMode().isTransactional()) {
            try {
                FakeJTATransaction transaction = new FakeJTATransaction();
                InvocationContext ctx = this.invocationContextFactory.createInvocationContext((Transaction)transaction, false);
                LocalTransaction localTransaction = (LocalTransaction)((LocalTxInvocationContext)ctx).getCacheTransaction();
                stage = CompletionStages.handleAndCompose(this.invocationHelper.invokeAsync(ctx, cmd), (__, t) -> this.completeTransaction(key, localTransaction, (Throwable)t)).whenComplete((__, t) -> this.transactionTable.removeLocalTransaction(localTransaction));
            }
            catch (Exception e) {
                throw log.problemPreloadingKey(key, e);
            }
        } else {
            stage = this.invocationHelper.invokeAsync(cmd, 1);
        }
        return Completable.fromCompletionStage(stage).toSingleDefault(me);
    }

    private CompletionStage<?> completeTransaction(Object key, LocalTransaction localTransaction, Throwable t) {
        if (t != null) {
            return this.transactionCoordinator.rollback(localTransaction).whenComplete((__1, t1) -> {
                throw log.problemPreloadingKey(key, t);
            });
        }
        return this.transactionCoordinator.commit(localTransaction, true);
    }

    private void resumeIfNeeded(Transaction transaction) {
        if (this.configuration.transaction().transactionMode().isTransactional() && this.transactionManager != null && transaction != null) {
            try {
                this.transactionManager.resume(transaction);
            }
            catch (Exception e) {
                throw new PersistenceException(e);
            }
        }
    }

    private Transaction suspendIfNeeded() {
        if (this.configuration.transaction().transactionMode().isTransactional() && this.transactionManager != null) {
            try {
                return this.transactionManager.suspend();
            }
            catch (Exception e) {
                throw new PersistenceException(e);
            }
        }
        return null;
    }

    private long getMaxEntries() {
        long maxCount;
        if (this.configuration.memory().isEvictionEnabled() && (maxCount = this.configuration.memory().maxCount()) > 0L) {
            return maxCount;
        }
        return Long.MAX_VALUE;
    }

    private long getFlagsForStateInsertion() {
        boolean hasSharedStore = this.persistenceManager.hasStore(StoreConfiguration::shared);
        if (!hasSharedStore || !this.configuration.indexing().isVolatile()) {
            return PRELOAD_WITHOUT_INDEXING_FLAGS;
        }
        return PRELOAD_FLAGS;
    }

    public boolean isFullyPreloaded() {
        return this.fullyPreloaded;
    }
}

