/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.x500.cert;

import org.wildfly.common.Assert;
import org.wildfly.security.asn1.ASN1Encodable;
import org.wildfly.security.asn1.ASN1Encoder;
import org.wildfly.security.x500.GeneralName;

public final class AccessDescription
implements ASN1Encodable {
    private final String accessMethodId;
    private final GeneralName accessLocation;

    public AccessDescription(String accessMethodId, GeneralName accessLocation) {
        Assert.checkNotNullParam("accessMethodId", accessMethodId);
        Assert.checkNotNullParam("accessLocation", accessLocation);
        this.accessMethodId = accessMethodId;
        this.accessLocation = accessLocation;
    }

    @Override
    public void encodeTo(ASN1Encoder encoder) {
        encoder.startSequence();
        encoder.encodeObjectIdentifier(this.accessMethodId);
        this.accessLocation.encodeTo(encoder);
        encoder.endSequence();
    }
}

