/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.common.spi;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.common.spi.SearchIndexNodeContext;
import org.hibernate.search.engine.search.common.spi.SearchIndexNodeTypeContext;
import org.hibernate.search.engine.search.common.spi.SearchIndexSchemaElementContextHelper;
import org.hibernate.search.engine.search.common.spi.SearchIndexScope;
import org.hibernate.search.engine.search.common.spi.SearchQueryElementFactory;
import org.hibernate.search.engine.search.common.spi.SearchQueryElementTypeKey;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public abstract class AbstractMultiIndexSearchIndexNodeContext<S extends SearchIndexNodeContext<SC>, SC extends SearchIndexScope<?>, NT extends SearchIndexNodeTypeContext<SC, S>>
implements SearchIndexNodeContext<SC>,
SearchIndexNodeTypeContext<SC, S> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    protected final SC scope;
    protected final String absolutePath;
    protected final List<? extends S> nodeForEachIndex;

    AbstractMultiIndexSearchIndexNodeContext(SC scope, String absolutePath, List<? extends S> nodeForEachIndex) {
        this.scope = scope;
        this.absolutePath = absolutePath;
        this.nodeForEachIndex = nodeForEachIndex;
    }

    protected abstract S self();

    protected abstract NT selfAsNodeType();

    protected abstract NT typeOf(S var1);

    @Override
    public final String absolutePath() {
        return this.absolutePath;
    }

    @Override
    public final String[] absolutePathComponents() {
        return ((SearchIndexNodeContext)this.nodeForEachIndex.get(0)).absolutePathComponents();
    }

    @Override
    public final List<String> nestedPathHierarchy() {
        return this.fromNodeIfCompatible(SearchIndexNodeContext::nestedPathHierarchy, Object::equals, "nestedPathHierarchy");
    }

    @Override
    public String nestedDocumentPath() {
        return this.fromNodeIfCompatible(SearchIndexNodeContext::nestedDocumentPath, Object::equals, "nestedDocumentPath");
    }

    @Override
    public String closestMultiValuedParentAbsolutePath() {
        return this.fromNodeIfCompatible(SearchIndexNodeContext::closestMultiValuedParentAbsolutePath, Objects::equals, "closestMultiValuedParentAbsolutePath");
    }

    @Override
    public boolean multiValued() {
        for (SearchIndexNodeContext field : this.nodeForEachIndex) {
            if (!field.multiValued()) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean multiValuedInRoot() {
        for (SearchIndexNodeContext field : this.nodeForEachIndex) {
            if (!field.multiValuedInRoot()) continue;
            return true;
        }
        return false;
    }

    public final EventContext eventContext() {
        return this.indexesEventContext().append(this.relativeEventContext());
    }

    protected final EventContext indexesEventContext() {
        return this.scope.eventContext();
    }

    @Override
    public final EventContext relativeEventContext() {
        return this.absolutePath == null ? EventContexts.indexSchemaRoot() : EventContexts.fromIndexFieldAbsolutePath(this.absolutePath);
    }

    @Override
    public final <T> T queryElement(SearchQueryElementTypeKey<T> key, SC scope) {
        SearchQueryElementFactory<T, SC, S> factory = this.queryElementFactory(key);
        return this.helper().queryElement(key, factory, scope, this.self());
    }

    @Override
    public SearchException cannotUseQueryElement(SearchQueryElementTypeKey<?> key, String hint, Exception causeOrNull) {
        return this.helper().cannotUseQueryElement(key, this.self(), hint, causeOrNull);
    }

    abstract SearchIndexSchemaElementContextHelper helper();

    @Override
    public final <T> SearchQueryElementFactory<? extends T, ? super SC, ? super S> queryElementFactory(SearchQueryElementTypeKey<T> key) {
        SearchQueryElementFactory factory = null;
        for (SearchIndexNodeContext indexElement : this.nodeForEachIndex) {
            SearchQueryElementFactory factoryForIndexElement = this.typeOf(indexElement).queryElementFactory(key);
            if (factory == null) {
                factory = factoryForIndexElement;
                continue;
            }
            this.checkFactoryCompatibility(key, factory, factoryForIndexElement);
        }
        return factory;
    }

    protected final <T> T fromNodeIfCompatible(Function<S, T> getter, BiPredicate<T, T> compatibilityChecker, String attributeName) {
        T attribute = null;
        for (SearchIndexNodeContext indexElement : this.nodeForEachIndex) {
            T attributeForIndexElement = getter.apply(indexElement);
            if (attribute == null) {
                attribute = attributeForIndexElement;
                continue;
            }
            this.checkAttributeCompatibility(compatibilityChecker, attributeName, attribute, attributeForIndexElement);
        }
        return attribute;
    }

    protected final <T> T fromTypeIfCompatible(Function<NT, T> getter, BiPredicate<T, T> compatibilityChecker, String attributeName) {
        T attribute = null;
        for (SearchIndexNodeContext indexElement : this.nodeForEachIndex) {
            NT fieldType = this.typeOf(indexElement);
            T attributeForIndexElement = getter.apply(fieldType);
            if (attribute == null) {
                attribute = attributeForIndexElement;
                continue;
            }
            this.checkAttributeCompatibility(compatibilityChecker, attributeName, attribute, attributeForIndexElement);
        }
        return attribute;
    }

    private <T> void checkFactoryCompatibility(SearchQueryElementTypeKey<T> key, SearchQueryElementFactory<? extends T, ? super SC, ? super S> factory1, SearchQueryElementFactory<? extends T, ? super SC, ? super S> factory2) {
        if (factory1 == null && factory2 == null) {
            return;
        }
        try {
            if (factory1 == null || factory2 == null) {
                throw log.partialSupportForQueryElement(key, this.helper().partialSupportHint());
            }
            factory1.checkCompatibleWith(factory2);
        }
        catch (SearchException e) {
            SearchException inconsistentSupportException = log.inconsistentSupportForQueryElement(key, e.getMessage(), e);
            throw log.inconsistentConfigurationInContextForSearch(this.relativeEventContext(), inconsistentSupportException.getMessage(), this.indexesEventContext(), inconsistentSupportException);
        }
    }

    final <T> void checkAttributeCompatibility(BiPredicate<T, T> compatibilityChecker, String attributeName, T attribute1, T attribute2) {
        try {
            if (!compatibilityChecker.test(attribute1, attribute2)) {
                throw log.differentAttribute(attributeName, attribute1, attribute2);
            }
        }
        catch (SearchException e) {
            throw log.inconsistentConfigurationInContextForSearch(this.relativeEventContext(), e.getMessage(), this.indexesEventContext(), e);
        }
    }
}

