/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.deployments;

import java.io.Closeable;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.as.logging.logging.LoggingLogger;
import org.jboss.as.logging.logmanager.WildFlyLogContextSelector;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.SubDeploymentMarker;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.logmanager.LogContext;
import org.jboss.modules.Module;
import org.wildfly.security.manager.WildFlySecurityManager;

abstract class AbstractLoggingDeploymentProcessor
implements DeploymentUnitProcessor {
    private static final AttachmentKey<LogContext> LOG_CONTEXT_KEY = AttachmentKey.create(LogContext.class);
    private static final AttachmentKey<LogContext> DEFAULT_LOG_CONTEXT_KEY = AttachmentKey.create(LogContext.class);
    final WildFlyLogContextSelector logContextSelector;

    AbstractLoggingDeploymentProcessor(WildFlyLogContextSelector logContextSelector) {
        this.logContextSelector = logContextSelector;
    }

    public final void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!AbstractLoggingDeploymentProcessor.hasRegisteredLogContext(deploymentUnit) && deploymentUnit.hasAttachment(Attachments.DEPLOYMENT_ROOT)) {
            ResourceRoot root = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
            if (SubDeploymentMarker.isSubDeployment((ResourceRoot)root)) {
                return;
            }
            this.processDeployment(phaseContext, deploymentUnit, root);
            if (!AbstractLoggingDeploymentProcessor.hasRegisteredLogContext(deploymentUnit) && !deploymentUnit.hasAttachment(DEFAULT_LOG_CONTEXT_KEY)) {
                this.registerLogContext(deploymentUnit, DEFAULT_LOG_CONTEXT_KEY, (Module)deploymentUnit.getAttachment(Attachments.MODULE), LogContext.getLogContext());
            }
        }
    }

    public final void undeploy(DeploymentUnit context) {
        ResourceRoot root = (ResourceRoot)context.getAttachment(Attachments.DEPLOYMENT_ROOT);
        if (SubDeploymentMarker.isSubDeployment((ResourceRoot)root)) {
            return;
        }
        Module module = (Module)context.getAttachment(Attachments.MODULE);
        this.unregisterLogContext(context, DEFAULT_LOG_CONTEXT_KEY, module);
        this.unregisterLogContext(context, LOG_CONTEXT_KEY, module);
        List<DeploymentUnit> subDeployments = AbstractLoggingDeploymentProcessor.getSubDeployments(context);
        for (DeploymentUnit subDeployment : subDeployments) {
            Module subDeploymentModule = (Module)subDeployment.getAttachment(Attachments.MODULE);
            this.unregisterLogContext(subDeployment, LOG_CONTEXT_KEY, subDeploymentModule);
        }
    }

    protected abstract void processDeployment(DeploymentPhaseContext var1, DeploymentUnit var2, ResourceRoot var3) throws DeploymentUnitProcessingException;

    void registerLogContext(DeploymentUnit deploymentUnit, Module module, LogContext logContext) {
        this.unregisterLogContext(deploymentUnit, DEFAULT_LOG_CONTEXT_KEY, module);
        this.registerLogContext(deploymentUnit, LOG_CONTEXT_KEY, module, logContext);
    }

    private void registerLogContext(DeploymentUnit deploymentUnit, AttachmentKey<LogContext> attachmentKey, final Module module, final LogContext logContext) {
        LoggingLogger.ROOT_LOGGER.tracef("Registering LogContext %s for deployment %s", logContext, deploymentUnit.getName());
        if (WildFlySecurityManager.isChecking()) {
            WildFlySecurityManager.doUnchecked((PrivilegedAction)new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    AbstractLoggingDeploymentProcessor.this.logContextSelector.registerLogContext((ClassLoader)module.getClassLoader(), logContext);
                    return null;
                }
            });
        } else {
            this.logContextSelector.registerLogContext((ClassLoader)module.getClassLoader(), logContext);
        }
        deploymentUnit.putAttachment(attachmentKey, (Object)logContext);
    }

    private void unregisterLogContext(DeploymentUnit deploymentUnit, AttachmentKey<LogContext> attachmentKey, final Module module) {
        final LogContext logContext = (LogContext)deploymentUnit.removeAttachment(attachmentKey);
        if (logContext != null) {
            boolean success = WildFlySecurityManager.isChecking() ? ((Boolean)WildFlySecurityManager.doUnchecked((PrivilegedAction)new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return AbstractLoggingDeploymentProcessor.this.logContextSelector.unregisterLogContext((ClassLoader)module.getClassLoader(), logContext);
                }
            })).booleanValue() : this.logContextSelector.unregisterLogContext((ClassLoader)module.getClassLoader(), logContext);
            if (success) {
                LoggingLogger.ROOT_LOGGER.tracef("Removed LogContext '%s' from '%s'", logContext, module);
            } else {
                LoggingLogger.ROOT_LOGGER.logContextNotRemoved(logContext, deploymentUnit.getName());
            }
        }
    }

    static List<DeploymentUnit> getSubDeployments(DeploymentUnit deploymentUnit) {
        if (deploymentUnit.hasAttachment(Attachments.SUB_DEPLOYMENTS)) {
            return new ArrayList<DeploymentUnit>(deploymentUnit.getAttachmentList(Attachments.SUB_DEPLOYMENTS));
        }
        return Collections.emptyList();
    }

    static void safeClose(Closeable closable) {
        if (closable != null) {
            try {
                closable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static boolean hasRegisteredLogContext(DeploymentUnit deploymentUnit) {
        return deploymentUnit.hasAttachment(LOG_CONTEXT_KEY);
    }
}

