/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.embedded;

import java.nio.file.Path;
import org.wildfly.core.embedded.SystemPropertyContext;

final class HostControllerSystemPropertyContext
extends SystemPropertyContext {
    private static final String DOMAIN_BASE_DIR = "jboss.domain.base.dir";
    private static final String DOMAIN_CONFIG_DIR = "jboss.domain.config.dir";
    private static final String DOMAIN_CONTENT_DIR = "jboss.domain.content.dir";
    private static final String DOMAIN_DATA_DIR = "jboss.domain.data.dir";
    private static final String DOMAIN_DEPLOYMENT_DIR = "jboss.domain.deployment.dir";
    private static final String DOMAIN_LOG_DIR = "jboss.domain.log.dir";
    private static final String DOMAIN_TEMP_DIR = "jboss.domain.temp.dir";
    private static final String JBOSS_DOMAIN_PRIMARY_ADDRESS = "jboss.domain.primary.address";
    private static final String DOMAIN_SERVERS_DIR = "jboss.domain.servers.dir";

    HostControllerSystemPropertyContext(Path jbossHomeDir) {
        super(jbossHomeDir);
    }

    @Override
    void configureProperties() {
        Path baseDir = this.resolveBaseDir(DOMAIN_BASE_DIR, "domain");
        this.addPropertyIfAbsent(DOMAIN_BASE_DIR, baseDir.toString());
        this.addPropertyIfAbsent(DOMAIN_CONFIG_DIR, HostControllerSystemPropertyContext.resolvePath(baseDir, "configuration"));
        Path dataDir = this.resolveDir(DOMAIN_DATA_DIR, baseDir.resolve("data"));
        this.addPropertyIfAbsent(DOMAIN_DATA_DIR, dataDir);
        this.addPropertyIfAbsent(DOMAIN_CONTENT_DIR, HostControllerSystemPropertyContext.resolvePath(dataDir, "content"));
        this.addPropertyIfAbsent(DOMAIN_DEPLOYMENT_DIR, HostControllerSystemPropertyContext.resolvePath(dataDir, "content"));
        this.addPropertyIfAbsent(DOMAIN_LOG_DIR, HostControllerSystemPropertyContext.resolvePath(baseDir, "log"));
        this.addPropertyIfAbsent(DOMAIN_TEMP_DIR, HostControllerSystemPropertyContext.resolvePath(baseDir, "tmp"));
        this.checkProperty(JBOSS_DOMAIN_PRIMARY_ADDRESS);
        this.checkProperty(DOMAIN_SERVERS_DIR);
    }
}

