/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.EnumSet;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.jboss.as.clustering.controller.CapabilityProvider;
import org.jboss.as.clustering.controller.CapabilityReference;
import org.jboss.as.clustering.controller.ChildResourceDefinition;
import org.jboss.as.clustering.controller.ManagementResourceRegistration;
import org.jboss.as.clustering.controller.MetricExecutor;
import org.jboss.as.clustering.controller.MetricHandler;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.RuntimeResourceRegistration;
import org.jboss.as.clustering.controller.SimpleResourceRegistrar;
import org.jboss.as.clustering.controller.UnaryRequirementCapability;
import org.jboss.as.clustering.controller.validation.ModuleIdentifierValidatorBuilder;
import org.jboss.as.clustering.jgroups.subsystem.ChannelMetric;
import org.jboss.as.clustering.jgroups.subsystem.ChannelMetricExecutor;
import org.jboss.as.clustering.jgroups.subsystem.ChannelRuntimeResourceRegistration;
import org.jboss.as.clustering.jgroups.subsystem.ChannelServiceHandler;
import org.jboss.as.clustering.jgroups.subsystem.ForkResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsExtension;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemResourceDefinition;
import org.jboss.as.controller.AbstractAttributeDefinitionBuilder;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jgroups.JChannel;
import org.wildfly.clustering.jgroups.spi.JGroupsRequirement;
import org.wildfly.clustering.server.service.ClusteringRequirement;
import org.wildfly.clustering.service.UnaryRequirement;
import org.wildfly.subsystem.service.capture.FunctionExecutorRegistry;
import org.wildfly.subsystem.service.capture.ServiceValueExecutorRegistry;
import org.wildfly.subsystem.service.capture.ServiceValueRegistry;

public class ChannelResourceDefinition
extends ChildResourceDefinition<ManagementResourceRegistration> {
    public static final PathElement WILDCARD_PATH = ChannelResourceDefinition.pathElement("*");

    public static PathElement pathElement(String name) {
        return PathElement.pathElement((String)"channel", (String)name);
    }

    ChannelResourceDefinition() {
        super(WILDCARD_PATH, (ResourceDescriptionResolver)JGroupsExtension.SUBSYSTEM_RESOLVER.createChildResolver(WILDCARD_PATH));
    }

    public ManagementResourceRegistration register(ManagementResourceRegistration parent) {
        ManagementResourceRegistration registration = parent.registerSubModel((ResourceDefinition)this);
        ServiceValueExecutorRegistry executors = ServiceValueExecutorRegistry.newInstance();
        ResourceDescriptor descriptor = new ResourceDescriptor(this.getResourceDescriptionResolver()).addAttributes(Attribute.class).addCapabilities(Capability.class).addCapabilities((Iterable)EnumSet.allOf(ClusteringRequirement.class).stream().map(UnaryRequirementCapability::new).collect(Collectors.toList())).addRuntimeResourceRegistration((RuntimeResourceRegistration)new ChannelRuntimeResourceRegistration((FunctionExecutorRegistry<JChannel>)executors)).setAddOperationTransformation(DefaultStackOperationStepHandler::new);
        ChannelServiceHandler handler = new ChannelServiceHandler((ServiceValueRegistry<JChannel>)executors);
        new SimpleResourceRegistrar(descriptor, (ResourceServiceHandler)handler).register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        if (registration.isRuntimeOnlyRegistrationValid()) {
            new MetricHandler((MetricExecutor)new ChannelMetricExecutor((FunctionExecutorRegistry<JChannel>)executors), ChannelMetric.class).register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        }
        new ForkResourceDefinition((ServiceValueExecutorRegistry<JChannel>)executors).register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        return registration;
    }

    public static enum Attribute implements org.jboss.as.clustering.controller.Attribute,
    UnaryOperator<SimpleAttributeDefinitionBuilder>
    {
        STACK("stack", ModelType.STRING){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setRequired(true)).setAllowExpression(false)).setCapabilityReference((CapabilityReferenceRecorder)new CapabilityReference((org.jboss.as.clustering.controller.Capability)Capability.JCHANNEL_FACTORY, (UnaryRequirement)JGroupsRequirement.CHANNEL_FACTORY));
            }
        }
        ,
        MODULE("module", ModelType.STRING){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setDefaultValue(new ModelNode("org.wildfly.clustering.server"))).setValidator(new ModuleIdentifierValidatorBuilder().configure((AbstractAttributeDefinitionBuilder)builder).build());
            }
        }
        ,
        CLUSTER("cluster", ModelType.STRING),
        STATISTICS_ENABLED("statistics-enabled", ModelType.BOOLEAN){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)builder.setDefaultValue(ModelNode.FALSE);
            }
        };

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type) {
            this.definition = this.apply((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }

        @Override
        public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
            return builder;
        }
    }

    static enum Capability implements CapabilityProvider
    {
        JCHANNEL((UnaryRequirement)JGroupsRequirement.CHANNEL),
        FORK_CHANNEL_FACTORY((UnaryRequirement)JGroupsRequirement.CHANNEL_FACTORY),
        JCHANNEL_FACTORY((UnaryRequirement)JGroupsRequirement.CHANNEL_SOURCE),
        JCHANNEL_MODULE((UnaryRequirement)JGroupsRequirement.CHANNEL_MODULE),
        JCHANNEL_CLUSTER((UnaryRequirement)JGroupsRequirement.CHANNEL_CLUSTER);

        private org.jboss.as.clustering.controller.Capability capability;

        private Capability(UnaryRequirement requirement) {
            this.capability = new UnaryRequirementCapability(requirement);
        }

        public org.jboss.as.clustering.controller.Capability getCapability() {
            return this.capability;
        }
    }

    private static class DefaultStackOperationStepHandler
    implements OperationStepHandler {
        private final OperationStepHandler handler;

        DefaultStackOperationStepHandler(OperationStepHandler handler) {
            this.handler = handler;
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            if (!operation.hasDefined(Attribute.STACK.getName())) {
                PathAddress subsystemAddress = context.getCurrentAddress().getParent();
                Resource root = context.readResourceFromRoot(subsystemAddress.getParent(), false);
                if (!root.hasChild(subsystemAddress.getLastElement())) {
                    context.addStep(operation, (OperationStepHandler)this, context.getCurrentStage());
                    return;
                }
                Resource subsystem = context.readResourceFromRoot(subsystemAddress, false);
                ModelNode subsystemModel = subsystem.getModel();
                if (subsystemModel.hasDefined(JGroupsSubsystemResourceDefinition.Attribute.DEFAULT_CHANNEL.getName())) {
                    String defaultChannel = subsystemModel.get(JGroupsSubsystemResourceDefinition.Attribute.DEFAULT_CHANNEL.getName()).asString();
                    if (!context.getCurrentAddressValue().equals(defaultChannel)) {
                        PathElement defaultChannelPath = ChannelResourceDefinition.pathElement(defaultChannel);
                        if (!subsystem.hasChild(defaultChannelPath)) {
                            context.addStep(operation, (OperationStepHandler)this, context.getCurrentStage());
                            return;
                        }
                        Resource channel = context.readResourceFromRoot(subsystemAddress.append(new PathElement[]{defaultChannelPath}), false);
                        ModelNode channelModel = channel.getModel();
                        String defaultStack = channelModel.get(Attribute.STACK.getName()).asString();
                        operation.get(Attribute.STACK.getName()).set(defaultStack);
                    }
                }
            }
            this.handler.execute(context, operation);
        }
    }
}

