/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.operations;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationClientException;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.ProcessEnvironmentSystemPropertyUpdater;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.server.controller.resources.SystemPropertyResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.wildfly.security.manager.WildFlySecurityManager;

public class SystemPropertyAddHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "add";
    private static final OperationContext.AttachmentKey<DeferredProcessor> ATTACHMENT_KEY = OperationContext.AttachmentKey.create(DeferredProcessor.class);
    private final ProcessEnvironmentSystemPropertyUpdater systemPropertyUpdater;
    private final AttributeDefinition[] attributes;

    public static ModelNode getOperation(ModelNode address, String value) {
        return SystemPropertyAddHandler.getOperation(address, value, null);
    }

    public static ModelNode getOperation(ModelNode address, String value, Boolean boottime) {
        ModelNode op = Util.getEmptyOperation((String)OPERATION_NAME, (ModelNode)address);
        if (value == null) {
            op.get(SystemPropertyResourceDefinition.VALUE.getName()).set(new ModelNode());
        } else {
            op.get(SystemPropertyResourceDefinition.VALUE.getName()).set(value);
        }
        if (boottime != null) {
            op.get(SystemPropertyResourceDefinition.BOOT_TIME.getName()).set(boottime.booleanValue());
        }
        return op;
    }

    public SystemPropertyAddHandler(ProcessEnvironmentSystemPropertyUpdater systemPropertyUpdater, AttributeDefinition[] attributes) {
        this.systemPropertyUpdater = systemPropertyUpdater;
        this.attributes = attributes;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode model = context.createResource(PathAddress.EMPTY_ADDRESS).getModel();
        for (AttributeDefinition attr : this.attributes) {
            attr.validateAndSet(operation, model);
        }
        final String name = context.getCurrentAddressValue();
        ModelNode valueNode = model.get(SystemPropertyResourceDefinition.VALUE.getName());
        String value = valueNode.asStringOrNull();
        final boolean applyToRuntime = this.systemPropertyUpdater != null && this.systemPropertyUpdater.isRuntimeSystemPropertyUpdateAllowed(name, value, context.isBooting());
        final boolean reload = !applyToRuntime && context.getProcessType().isServer();
        final AtomicReference<String> currentValue = new AtomicReference<String>();
        if (applyToRuntime) {
            currentValue.set(WildFlySecurityManager.getPropertyPrivileged((String)name, null));
            String setValue = null;
            boolean setIt = false;
            try {
                setValue = value != null ? SystemPropertyResourceDefinition.VALUE.resolveModelAttribute(context, model).asStringOrNull() : null;
                setIt = true;
            }
            catch (Exception resolutionFailure) {
                this.handleDeferredResolution(context, model, name, resolutionFailure);
            }
            if (setIt) {
                SystemPropertyAddHandler.setProperty(name, setValue, this.systemPropertyUpdater);
            }
        } else if (reload) {
            context.reloadRequired();
        }
        context.completeStep(new OperationContext.RollbackHandler(){

            public void handleRollback(OperationContext context, ModelNode operation) {
                if (reload) {
                    context.revertReloadRequired();
                }
                if (applyToRuntime) {
                    SystemPropertyAddHandler.setProperty(name, (String)currentValue.get(), SystemPropertyAddHandler.this.systemPropertyUpdater);
                }
            }
        });
    }

    private static void setProperty(String name, String value, ProcessEnvironmentSystemPropertyUpdater systemPropertyUpdater) {
        if (value != null) {
            WildFlySecurityManager.setPropertyPrivileged((String)name, (String)value);
        } else {
            WildFlySecurityManager.clearPropertyPrivileged((String)name);
        }
        if (systemPropertyUpdater != null) {
            systemPropertyUpdater.systemPropertyUpdated(name, value);
        }
    }

    private void handleDeferredResolution(OperationContext context, ModelNode model, String propertyName, Exception resolutionFailure) {
        assert (resolutionFailure == null || resolutionFailure instanceof RuntimeException || resolutionFailure instanceof OperationFailedException) : "invalid resolutionFailure type " + resolutionFailure.getClass();
        DeferredProcessor deferredResolver = (DeferredProcessor)context.getAttachment(ATTACHMENT_KEY);
        if (deferredResolver == null) {
            deferredResolver = new DeferredProcessor(this.systemPropertyUpdater);
            context.attach(ATTACHMENT_KEY, (Object)deferredResolver);
        }
        deferredResolver.addDeferredProcessee(propertyName, model, resolutionFailure);
        DeferredProcessor finalDeferredResolver = deferredResolver;
        context.addStep((context1, operation) -> {
            if (!finalDeferredResolver.processDeferredPropertyAtRuntime(propertyName, (ExpressionResolver)context1)) {
                context.addStep((context2, operation2) -> {
                    DeferredProcesee procesee = finalDeferredResolver.getUnresolved(propertyName);
                    if (procesee != null) {
                        if (procesee.ofe != null) {
                            context2.setRollbackOnly();
                            throw procesee.ofe;
                        }
                        if (procesee.re != null) {
                            context2.setRollbackOnly();
                            throw procesee.re;
                        }
                    }
                }, OperationContext.Stage.VERIFY);
            }
        }, OperationContext.Stage.RUNTIME);
    }

    static final class DeferredProcesee {
        private final ModelNode model;
        private OperationFailedException ofe;
        private RuntimeException re;

        private DeferredProcesee(ModelNode model, Exception resolutionFailure) {
            this.model = model;
            if (resolutionFailure != null) {
                this.setDeferredProcessingException(resolutionFailure);
            }
        }

        private void setDeferredProcessingException(Exception e) {
            assert (e instanceof RuntimeException || e instanceof OperationFailedException);
            if (e instanceof OperationFailedException) {
                this.ofe = (OperationFailedException)e;
                this.re = null;
            } else {
                this.re = (RuntimeException)e;
                if (e instanceof OperationClientException) {
                    this.ofe = null;
                }
            }
        }

        OperationFailedException getOperationFailedException() {
            return this.ofe;
        }

        RuntimeException getRuntimeException() {
            return this.re;
        }
    }

    static final class DeferredProcessor {
        private final Map<String, DeferredProcesee> unresolved = new HashMap<String, DeferredProcesee>();
        private final ProcessEnvironmentSystemPropertyUpdater systemPropertyUpdater;

        DeferredProcessor(ProcessEnvironmentSystemPropertyUpdater systemPropertyUpdater) {
            this.systemPropertyUpdater = systemPropertyUpdater;
        }

        synchronized void addDeferredProcessee(String propertyName, ModelNode model, Exception resolutionFailure) {
            this.unresolved.put(propertyName, new DeferredProcesee(model, resolutionFailure));
        }

        synchronized boolean processDeferredPropertyAtRuntime(String property, ExpressionResolver resolver) {
            DeferredProcesee procesee = this.unresolved.get(property);
            if (procesee != null) {
                try {
                    String setValue = SystemPropertyResourceDefinition.VALUE.resolveModelAttribute(resolver, procesee.model).asString();
                    SystemPropertyAddHandler.setProperty(property, setValue, this.systemPropertyUpdater);
                    this.unresolved.remove(property);
                }
                catch (RuntimeException | OperationFailedException resolutionFailure) {
                    procesee.setDeferredProcessingException((Exception)resolutionFailure);
                    return false;
                }
            }
            return true;
        }

        synchronized void processDeferredProperties(ExpressionResolver resolver) {
            Iterator<Map.Entry<String, DeferredProcesee>> it = this.unresolved.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, DeferredProcesee> entry = it.next();
                try {
                    DeferredProcesee procesee = entry.getValue();
                    String setValue = SystemPropertyResourceDefinition.VALUE.resolveModelAttribute(resolver, procesee.model).asString();
                    SystemPropertyAddHandler.setProperty(entry.getKey(), setValue, this.systemPropertyUpdater);
                    it.remove();
                }
                catch (RuntimeException | OperationFailedException resolutionFailure) {
                    entry.getValue().setDeferredProcessingException((Exception)resolutionFailure);
                }
            }
        }

        synchronized DeferredProcesee getUnresolved(String propertyName) {
            return this.unresolved.get(propertyName);
        }
    }
}

