/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl.function;

import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterState;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.impl.entries.CounterValue;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.functional.impl.CounterConfigurationMetaParam;

final class FunctionHelper {
    private FunctionHelper() {
    }

    static Object compareAndSwap(EntryView.ReadWriteEntryView<?, CounterValue> entry, CounterValue value, CounterConfigurationMetaParam metadata, long expected, long update) {
        long retVal = value.getValue();
        if (expected == retVal) {
            if (metadata.get().type() == CounterType.BOUNDED_STRONG) {
                if (update < metadata.get().lowerBound()) {
                    return CounterState.LOWER_BOUND_REACHED;
                }
                if (update > metadata.get().upperBound()) {
                    return CounterState.UPPER_BOUND_REACHED;
                }
            }
            FunctionHelper.setInEntry(entry, CounterValue.newCounterValue(update, CounterState.VALID), metadata);
        }
        return retVal;
    }

    static CounterValue add(EntryView.ReadWriteEntryView<?, CounterValue> entry, CounterValue value, CounterConfigurationMetaParam metadata, long delta) {
        if (delta == 0L) {
            return value;
        }
        if (metadata.get().type() == CounterType.BOUNDED_STRONG) {
            if (delta > 0L) {
                return FunctionHelper.addAndCheckUpperBound(entry, value, metadata, delta);
            }
            return FunctionHelper.addAndCheckLowerBound(entry, value, metadata, delta);
        }
        return FunctionHelper.addUnbounded(entry, value, metadata, delta);
    }

    private static CounterValue addAndCheckUpperBound(EntryView.ReadWriteEntryView<?, CounterValue> entry, CounterValue value, CounterConfigurationMetaParam metadata, long delta) {
        CounterValue newValue;
        if (value.getState() == CounterState.UPPER_BOUND_REACHED) {
            return value;
        }
        long upperBound = metadata.get().upperBound();
        try {
            long addedValue = Math.addExact(value.getValue(), delta);
            newValue = addedValue > upperBound ? CounterValue.newCounterValue(upperBound, CounterState.UPPER_BOUND_REACHED) : CounterValue.newCounterValue(addedValue, CounterState.VALID);
        }
        catch (ArithmeticException e) {
            newValue = CounterValue.newCounterValue(Long.MAX_VALUE, CounterState.UPPER_BOUND_REACHED);
        }
        FunctionHelper.setInEntry(entry, newValue, metadata);
        return newValue;
    }

    private static CounterValue addAndCheckLowerBound(EntryView.ReadWriteEntryView<?, CounterValue> entry, CounterValue value, CounterConfigurationMetaParam metadata, long delta) {
        CounterValue newValue;
        if (value.getState() == CounterState.LOWER_BOUND_REACHED) {
            return value;
        }
        long lowerBound = metadata.get().lowerBound();
        try {
            long addedValue = Math.addExact(value.getValue(), delta);
            newValue = addedValue < lowerBound ? CounterValue.newCounterValue(lowerBound, CounterState.LOWER_BOUND_REACHED) : CounterValue.newCounterValue(addedValue, CounterState.VALID);
        }
        catch (ArithmeticException e) {
            newValue = CounterValue.newCounterValue(Long.MIN_VALUE, CounterState.LOWER_BOUND_REACHED);
        }
        FunctionHelper.setInEntry(entry, newValue, metadata);
        return newValue;
    }

    private static CounterValue addUnbounded(EntryView.ReadWriteEntryView<?, CounterValue> entry, CounterValue value, CounterConfigurationMetaParam metadata, long delta) {
        CounterValue newValue;
        if (FunctionHelper.noChange(value.getValue(), delta)) {
            return value;
        }
        try {
            newValue = CounterValue.newCounterValue(Math.addExact(value.getValue(), delta));
        }
        catch (ArithmeticException e) {
            newValue = CounterValue.newCounterValue(delta > 0L ? Long.MAX_VALUE : Long.MIN_VALUE);
        }
        FunctionHelper.setInEntry(entry, newValue, metadata);
        return newValue;
    }

    private static boolean noChange(long currentValue, long delta) {
        return currentValue == Long.MAX_VALUE && delta > 0L || currentValue == Long.MIN_VALUE && delta < 0L;
    }

    private static void setInEntry(EntryView.ReadWriteEntryView<?, CounterValue> entry, CounterValue value, CounterConfigurationMetaParam metadata) {
        CounterConfiguration configuration = metadata.get();
        if (configuration.type() != CounterType.WEAK && configuration.lifespan() > 0L) {
            entry.set((Object)value, new MetaParam.Writable[]{metadata, new MetaParam.MetaLifespan(configuration.lifespan()), new MetaParam.MetaUpdateCreationTime(false)});
        } else {
            entry.set((Object)value, new MetaParam.Writable[]{metadata});
        }
    }
}

