/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.IntConsumer;
import net.jcip.annotations.GuardedBy;
import org.infinispan.commons.stat.CounterTracker;
import org.infinispan.commons.stat.DistributionSummaryTracker;
import org.infinispan.commons.stat.MetricInfo;
import org.infinispan.commons.stat.TimerTracker;
import org.infinispan.commons.time.TimeService;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.metrics.impl.MetricUtils;
import org.infinispan.metrics.impl.MetricsRegistry;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.notifications.cachemanagerlistener.annotation.Merged;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.JGroupsMetricsManager;
import org.infinispan.remoting.transport.jgroups.JGroupsMetricsMetadata;
import org.infinispan.remoting.transport.jgroups.NoOpRequestTracker;
import org.infinispan.remoting.transport.jgroups.RequestTracker;
import org.jgroups.JChannel;
import org.jgroups.stack.Protocol;

@Listener
@Scope(value=Scopes.GLOBAL)
public class JGroupsMetricsManagerImpl
implements JGroupsMetricsManager {
    @Inject
    CacheManagerNotifier notifier;
    @Inject
    MetricsRegistry registry;
    @Inject
    TimeService timeService;
    private final Map<Address, DestinationMetrics> perDestinationMetrics;
    private final List<ClusterMetrics> otherChannels;
    private final boolean histogramEnabled;
    private volatile MainChannelRegistry mainChannelRegistry;
    private volatile boolean stopped = true;

    public JGroupsMetricsManagerImpl(boolean histogramEnabled) {
        this.histogramEnabled = histogramEnabled;
        this.perDestinationMetrics = new ConcurrentHashMap<Address, DestinationMetrics>(16);
        this.otherChannels = new CopyOnWriteArrayList<ClusterMetrics>();
    }

    @Start
    public void start() {
        this.stopped = false;
        this.notifier.addListener(this);
    }

    @Stop
    public void stop() {
        this.stopped = true;
        this.notifier.removeListener(this);
        this.perDestinationMetrics.values().forEach(metrics -> metrics.unregister(this.registry));
        this.perDestinationMetrics.clear();
        this.otherChannels.forEach(metrics -> metrics.unregister(this.registry));
        this.mainChannelRegistry = null;
    }

    @ViewChanged
    @Merged
    public void onViewChanged(ViewChangedEvent event) {
        if (this.stopped) {
            return;
        }
        HashSet<Address> leftMembers = new HashSet<Address>(this.perDestinationMetrics.keySet());
        event.getNewMembers().forEach(leftMembers::remove);
        for (Address node : leftMembers) {
            this.perDestinationMetrics.computeIfPresent(node, (unused, metrics) -> {
                metrics.unregister(this.registry);
                return null;
            });
        }
    }

    @Override
    public RequestTracker trackRequest(Address destination) {
        if (this.stopped) {
            return new NoOpRequestTracker(destination);
        }
        DestinationMetrics metrics = this.get(destination);
        if (metrics == null) {
            return new NoOpRequestTracker(destination);
        }
        return new RequestTrackerImpl(destination, metrics, this.timeService);
    }

    @Override
    public void recordMessageSent(Address destination, int bytesSent, boolean async) {
        if (this.stopped) {
            return;
        }
        DestinationMetrics metrics = this.get(destination);
        if (metrics == null) {
            return;
        }
        metrics.incrementBytesSent(bytesSent);
        if (async) {
            metrics.incrementAsyncRequests();
        }
    }

    @Override
    public synchronized void onChannelConnected(JChannel channel, boolean isMainChannel) {
        if (this.stopped) {
            return;
        }
        String nodeName = Objects.requireNonNull(JGroupsMetricsManagerImpl.nodeName(channel));
        String clusterName = Objects.requireNonNull(channel.clusterName());
        if (isMainChannel) {
            assert (this.mainChannelRegistry == null);
            this.mainChannelRegistry = new MainChannelRegistry(nodeName, clusterName);
        }
        if (this.otherChannels.stream().map(m -> m.channel).noneMatch(ch -> ch.equals(channel))) {
            this.otherChannels.add(new ClusterMetrics(channel));
        }
        if (this.mainChannelRegistry != null) {
            this.otherChannels.forEach(clusterMetrics -> clusterMetrics.register(this.mainChannelRegistry));
        }
    }

    @Override
    public synchronized void onChannelDisconnected(JChannel channel) {
        Optional<ClusterMetrics> optMetrics;
        if (this.stopped) {
            return;
        }
        if (this.mainChannelRegistry != null && this.mainChannelRegistry.clusterName.equals(channel.clusterName()) && this.mainChannelRegistry.nodeName.equals(channel.address().toString())) {
            this.mainChannelRegistry = null;
        }
        if ((optMetrics = this.otherChannels.stream().filter(m -> m.channel.equals(channel)).findFirst()).isEmpty()) {
            return;
        }
        ClusterMetrics metrics = optMetrics.get();
        metrics.unregister(this.registry);
        this.otherChannels.remove(metrics);
    }

    private DestinationMetrics get(Address dst) {
        assert (dst != null);
        return this.perDestinationMetrics.computeIfAbsent(dst, this::createDestinationMetrics);
    }

    private DestinationMetrics createDestinationMetrics(Address destination) {
        assert (destination != null);
        MainChannelRegistry statsRegistry = this.mainChannelRegistry;
        if (statsRegistry == null) {
            return null;
        }
        Collection<MetricInfo> attributes = this.createAttributes(destination.toString());
        DestinationMetricsBuilder builder = new DestinationMetricsBuilder();
        Set<Object> metricsIds = statsRegistry.registerStats(builder, attributes);
        return builder.build(metricsIds, this.histogramEnabled);
    }

    private static String nodeName(JChannel channel) {
        org.jgroups.Address addr = channel.address();
        return addr == null ? channel.name() : addr.toString();
    }

    private Collection<MetricInfo> createAttributes(String dst) {
        Map<String, String> tags = Map.of("target_node", dst);
        ArrayList<MetricInfo> attrs = new ArrayList<MetricInfo>(4);
        attrs.add((MetricInfo)MetricUtils.createCounter("AsyncRequests", "Number of asynchronous requests to " + dst, DestinationMetricsBuilder::setAsyncRequests, tags));
        attrs.add((MetricInfo)MetricUtils.createCounter("TimedOutRequests", "Number of timed out requests to " + dst, DestinationMetricsBuilder::setTimedOutRequests, tags));
        if (this.histogramEnabled) {
            attrs.add((MetricInfo)MetricUtils.createTimer("SyncRequests", "Number of synchronous requests to " + dst, DestinationMetricsBuilder::setSyncRequests, tags));
            attrs.add((MetricInfo)MetricUtils.createDistributionSummary("BytesSent", "Bytes sent to " + dst, DestinationMetricsBuilder::setBytesSentSummary, tags));
        } else {
            attrs.add((MetricInfo)MetricUtils.createFunctionTimer("SyncRequests", "Number of synchronous requests to " + dst, DestinationMetricsBuilder::setSyncRequests, TimeUnit.NANOSECONDS, tags));
            attrs.add((MetricInfo)MetricUtils.createCounter("BytesSent", "Bytes sent to " + dst, DestinationMetricsBuilder::setBytesSentCounter, tags));
        }
        return attrs;
    }

    private class MainChannelRegistry {
        final String nodeName;
        final String clusterName;

        MainChannelRegistry(String nodeName, String clusterName) {
            this.nodeName = nodeName;
            this.clusterName = clusterName;
        }

        Set<Object> registerStats(Object instance, Collection<MetricInfo> attributes) {
            return this.registerComponent(instance, "stats", this.clusterName, attributes);
        }

        Set<Object> registerComponent(Object instance, String component, String clusterName, Collection<MetricInfo> attributes) {
            String prefix = JGroupsMetricsManagerImpl.this.registry.namesAsTags() ? "jgroups_" + component.toLowerCase() + "_" : "jgroups_" + clusterName + "_" + component.toLowerCase() + "_";
            return JGroupsMetricsManagerImpl.this.registry.registerMetrics(instance, attributes, prefix, Map.of("node", this.nodeName, "cluster", clusterName));
        }
    }

    private static class DestinationMetrics {
        final TimerTracker syncRequests;
        final CounterTracker asyncRequests;
        final CounterTracker timedOutRequests;
        final IntConsumer bytesSent;
        final Set<Object> metricsIds;

        DestinationMetrics(TimerTracker syncRequests, CounterTracker asyncRequests, CounterTracker timedOutRequests, IntConsumer bytesSent, Set<Object> metricsIds) {
            this.syncRequests = syncRequests;
            this.asyncRequests = asyncRequests;
            this.timedOutRequests = timedOutRequests;
            this.bytesSent = bytesSent;
            this.metricsIds = metricsIds;
        }

        void recordSyncMessage(long durationNanos) {
            this.syncRequests.update(Duration.ofNanos(durationNanos));
        }

        void incrementBytesSent(int size) {
            this.bytesSent.accept(size);
        }

        void incrementAsyncRequests() {
            this.asyncRequests.increment();
        }

        void incrementTimedOutRequests() {
            this.timedOutRequests.increment();
        }

        void unregister(MetricsRegistry registry) {
            registry.unregisterMetrics(this.metricsIds);
        }
    }

    private static class RequestTrackerImpl
    implements RequestTracker {
        private final Address destination;
        final DestinationMetrics metrics;
        final TimeService timeService;
        volatile long sentTimeNanos;
        @GuardedBy(value="this")
        boolean completed;

        RequestTrackerImpl(Address destination, DestinationMetrics metrics, TimeService timeService) {
            this.destination = destination;
            this.metrics = metrics;
            this.timeService = timeService;
            this.sentTimeNanos = timeService.time();
        }

        @Override
        public final Address destination() {
            return this.destination;
        }

        @Override
        public synchronized void resetSendTime() {
            if (this.completed) {
                return;
            }
            this.sentTimeNanos = this.timeService.time();
        }

        @Override
        public synchronized void onComplete() {
            if (this.completed) {
                return;
            }
            this.metrics.recordSyncMessage(this.timeService.timeDuration(this.sentTimeNanos, TimeUnit.NANOSECONDS));
            this.completed = true;
        }

        @Override
        public synchronized void onTimeout() {
            if (this.completed) {
                return;
            }
            this.metrics.incrementTimedOutRequests();
            this.completed = true;
        }
    }

    private static class ClusterMetrics {
        final JChannel channel;
        final Set<Object> metricsIds;
        @GuardedBy(value="this")
        private boolean registered;

        ClusterMetrics(JChannel channel) {
            this.channel = channel;
            this.metricsIds = new HashSet<Object>(32);
        }

        synchronized void register(MainChannelRegistry mainChannel) {
            if (this.registered) {
                return;
            }
            for (Protocol protocol : this.channel.getProtocolStack().getProtocols()) {
                Collection<MetricInfo> attributes = JGroupsMetricsMetadata.PROTOCOL_METADATA.get(protocol.getClass());
                if (attributes == null || attributes.isEmpty()) continue;
                this.metricsIds.addAll(mainChannel.registerComponent(protocol, protocol.getName(), this.channel.clusterName(), attributes));
            }
            this.registered = true;
        }

        synchronized void unregister(MetricsRegistry registry) {
            registry.unregisterMetrics(this.metricsIds);
            this.metricsIds.clear();
            this.registered = false;
        }
    }

    private static class DestinationMetricsBuilder {
        TimerTracker syncRequests;
        CounterTracker asyncRequests;
        CounterTracker timedOutRequests;
        DistributionSummaryTracker bytesSentSummary;
        CounterTracker bytesSentCounter;

        private DestinationMetricsBuilder() {
        }

        void setSyncRequests(TimerTracker syncRequests) {
            this.syncRequests = syncRequests;
        }

        void setAsyncRequests(CounterTracker asyncRequests) {
            this.asyncRequests = asyncRequests;
        }

        void setTimedOutRequests(CounterTracker timedOutRequests) {
            this.timedOutRequests = timedOutRequests;
        }

        void setBytesSentSummary(DistributionSummaryTracker bytesSentSummary) {
            this.bytesSentSummary = bytesSentSummary;
        }

        void setBytesSentCounter(CounterTracker bytesSentCounter) {
            this.bytesSentCounter = bytesSentCounter;
        }

        DestinationMetrics build(Set<Object> metricsIds, boolean histogramEnabled) {
            IntConsumer bytesSentConsumer;
            assert (this.syncRequests != null);
            assert (this.asyncRequests != null);
            assert (this.timedOutRequests != null);
            if (histogramEnabled) {
                assert (this.bytesSentSummary != null);
                bytesSentConsumer = arg_0 -> ((DistributionSummaryTracker)this.bytesSentSummary).record(arg_0);
            } else {
                assert (this.bytesSentCounter != null);
                bytesSentConsumer = arg_0 -> ((CounterTracker)this.bytesSentCounter).increment(arg_0);
            }
            return new DestinationMetrics(this.syncRequests, this.asyncRequests, this.timedOutRequests, bytesSentConsumer, metricsIds);
        }
    }
}

