/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent.resource.definition;

import org.jboss.as.ee.concurrent.resource.definition.ManagedThreadFactoryDefinitionInjectionSource;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.as.ee.resource.definition.ResourceDefinitionDescriptorProcessor;
import org.jboss.as.ee.resource.definition.ResourceDefinitionInjectionSource;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.metadata.javaee.spec.Environment;
import org.jboss.metadata.javaee.spec.ManagedThreadFactoriesMetaData;
import org.jboss.metadata.javaee.spec.ManagedThreadFactoryMetaData;
import org.jboss.metadata.javaee.spec.RemoteEnvironment;

public class ManagedThreadFactoryDefinitionDescriptorProcessor
extends ResourceDefinitionDescriptorProcessor {
    @Override
    protected void processEnvironment(RemoteEnvironment environment, ResourceDefinitionDescriptorProcessor.ResourceDefinitionInjectionSources injectionSources) throws DeploymentUnitProcessingException {
        ManagedThreadFactoriesMetaData metaDatas;
        if (environment instanceof Environment && (metaDatas = ((Environment)environment).getManagedThreadFactories()) != null) {
            for (ManagedThreadFactoryMetaData metaData : metaDatas) {
                injectionSources.addResourceDefinitionInjectionSource(this.getResourceDefinitionInjectionSource(metaData));
            }
        }
    }

    private ResourceDefinitionInjectionSource getResourceDefinitionInjectionSource(ManagedThreadFactoryMetaData metaData) {
        String name = metaData.getName();
        if (name == null || name.isEmpty()) {
            throw EeLogger.ROOT_LOGGER.elementAttributeMissing("<managed-thread-factory>", "name");
        }
        ManagedThreadFactoryDefinitionInjectionSource resourceDefinitionInjectionSource = new ManagedThreadFactoryDefinitionInjectionSource(name);
        resourceDefinitionInjectionSource.setContextServiceRef(metaData.getContextServiceRef());
        Integer priority = metaData.getPriority();
        if (priority != null) {
            resourceDefinitionInjectionSource.setPriority(priority);
        }
        return resourceDefinitionInjectionSource;
    }
}

