/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.procedure.internal;

import jakarta.persistence.ParameterMode;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Objects;
import org.hibernate.engine.jdbc.env.spi.ExtractedDatabaseMetaData;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.procedure.ParameterTypeException;
import org.hibernate.procedure.spi.NamedCallableQueryMemento;
import org.hibernate.procedure.spi.ParameterStrategy;
import org.hibernate.procedure.spi.ProcedureCallImplementor;
import org.hibernate.procedure.spi.ProcedureParameterImplementor;
import org.hibernate.query.BindableType;
import org.hibernate.query.OutputableType;
import org.hibernate.query.internal.BindingTypeHelper;
import org.hibernate.query.spi.AbstractQueryParameter;
import org.hibernate.query.spi.QueryParameterBinding;
import org.hibernate.sql.exec.internal.JdbcCallParameterExtractorImpl;
import org.hibernate.sql.exec.internal.JdbcCallParameterRegistrationImpl;
import org.hibernate.sql.exec.internal.JdbcCallRefCursorExtractorImpl;
import org.hibernate.sql.exec.internal.JdbcParameterImpl;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcCallParameterRegistration;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.type.BasicType;
import org.hibernate.type.ProcedureParameterNamedBinder;
import org.hibernate.type.descriptor.WrapperOptions;

public class ProcedureParameterImpl<T>
extends AbstractQueryParameter<T>
implements ProcedureParameterImplementor<T> {
    private final String name;
    private final Integer position;
    private final ParameterMode mode;
    private final Class<T> javaType;

    public ProcedureParameterImpl(String name, ParameterMode mode, Class<T> javaType, BindableType<T> hibernateType) {
        super(false, hibernateType);
        this.name = name;
        this.position = null;
        this.mode = mode;
        this.javaType = javaType;
    }

    public ProcedureParameterImpl(Integer position, ParameterMode mode, Class<T> javaType, BindableType<T> hibernateType) {
        super(false, hibernateType);
        this.name = null;
        this.position = position;
        this.mode = mode;
        this.javaType = javaType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Integer getPosition() {
        return this.position;
    }

    @Override
    public ParameterMode getMode() {
        return this.mode;
    }

    @Override
    public Class<T> getParameterType() {
        return this.javaType;
    }

    @Override
    public NamedCallableQueryMemento.ParameterMemento toMemento() {
        return session -> {
            if (this.getName() != null) {
                return new ProcedureParameterImpl<T>(this.getName(), this.getMode(), this.javaType, this.getHibernateType());
            }
            return new ProcedureParameterImpl<T>(this.getPosition(), this.getMode(), this.javaType, this.getHibernateType());
        };
    }

    @Override
    public JdbcCallParameterRegistration toJdbcParameterRegistration(int startIndex, ProcedureCallImplementor<?> procedureCall) {
        JdbcCallParameterExtractorImpl parameterExtractor;
        JdbcParameterBinder parameterBinder;
        JdbcCallRefCursorExtractorImpl refCursorExtractor;
        boolean isNamed;
        QueryParameterBinding binding = procedureCall.getParameterBindings().getBinding(this);
        boolean bl = isNamed = procedureCall.getParameterStrategy() == ParameterStrategy.NAMED && this.name != null;
        BindableType<Object> bindableType = this.getHibernateType() != null ? this.getHibernateType() : (binding != null ? binding.getBindType() : null);
        OutputableType typeToUse = (OutputableType)BindingTypeHelper.INSTANCE.resolveTemporalPrecision(binding == null ? null : binding.getExplicitTemporalPrecision(), bindableType, procedureCall.getSession().getFactory());
        String jdbcParamName = isNamed && this.canDoNameParameterBinding(typeToUse, procedureCall) ? this.name : null;
        switch (this.mode) {
            case REF_CURSOR: {
                refCursorExtractor = new JdbcCallRefCursorExtractorImpl(jdbcParamName, startIndex);
                parameterBinder = null;
                parameterExtractor = null;
                break;
            }
            case IN: {
                this.validateBindableType(typeToUse, startIndex);
                parameterBinder = this.getParameterBinder(typeToUse, jdbcParamName);
                parameterExtractor = null;
                refCursorExtractor = null;
                break;
            }
            case INOUT: {
                this.validateBindableType(typeToUse, startIndex);
                parameterBinder = this.getParameterBinder(typeToUse, jdbcParamName);
                parameterExtractor = new JdbcCallParameterExtractorImpl(procedureCall.getProcedureName(), jdbcParamName, startIndex, typeToUse);
                refCursorExtractor = null;
                break;
            }
            default: {
                this.validateBindableType(typeToUse, startIndex);
                parameterBinder = null;
                parameterExtractor = new JdbcCallParameterExtractorImpl(procedureCall.getProcedureName(), jdbcParamName, startIndex, typeToUse);
                refCursorExtractor = null;
            }
        }
        return new JdbcCallParameterRegistrationImpl(jdbcParamName, startIndex, this.mode, typeToUse, parameterBinder, parameterExtractor, refCursorExtractor);
    }

    private void validateBindableType(BindableType<T> bindableType, int startIndex) {
        if (bindableType == null) {
            throw new ParameterTypeException(String.format(Locale.ROOT, "Could not determine ProcedureCall parameter bind type - %s (%s)", this.name != null ? this.name : this.position, startIndex));
        }
    }

    private JdbcParameterBinder getParameterBinder(BindableType<T> typeToUse, final String name) {
        if (typeToUse == null) {
            throw new ParameterTypeException(String.format(Locale.ROOT, "Cannot determine the bindable type for procedure parameter %s (%s)", this.name != null ? this.name : this.position, name));
        }
        if (typeToUse instanceof BasicType) {
            if (name == null) {
                return new JdbcParameterImpl((BasicType)typeToUse);
            }
            return new JdbcParameterImpl((BasicType)typeToUse){

                @Override
                protected void bindParameterValue(JdbcMapping jdbcMapping, PreparedStatement statement, Object bindValue, int startPosition, ExecutionContext executionContext) throws SQLException {
                    jdbcMapping.getJdbcValueBinder().bind((CallableStatement)statement, bindValue, name, (WrapperOptions)executionContext.getSession());
                }

                public String toString() {
                    return "JdbcParameter(" + name + ")";
                }
            };
        }
        throw new UnsupportedOperationException();
    }

    private boolean canDoNameParameterBinding(BindableType<?> hibernateType, ProcedureCallImplementor<?> procedureCall) {
        ExtractedDatabaseMetaData databaseMetaData = procedureCall.getSession().getFactory().getJdbcServices().getJdbcEnvironment().getExtractedDatabaseMetaData();
        return procedureCall.getFunctionReturn() == null && databaseMetaData.supportsNamedParameters() && hibernateType instanceof ProcedureParameterNamedBinder && ((ProcedureParameterNamedBinder)((Object)hibernateType)).canDoSetting();
    }

    public int hashCode() {
        return Objects.hash(this.name, this.position, this.mode);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcedureParameterImpl that = (ProcedureParameterImpl)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.position, that.position) && this.mode == that.mode;
    }

    public String toString() {
        if (this.position == null) {
            return this.name;
        }
        return this.position.toString();
    }
}

