/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.parsing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aesh.command.operator.OperatorType;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.parsing.CharacterHandler;
import org.jboss.as.cli.parsing.DefaultParsingState;
import org.jboss.as.cli.parsing.GlobalCharacterHandlers;
import org.jboss.as.cli.parsing.ParsingContext;

public class OperatorState {
    private static final List<OpState> OPERATORS = new ArrayList<OpState>();
    public static final String ID = "OPERATOR_OP";

    private OperatorState() {
    }

    public static void registerEnterStates(DefaultParsingState state) {
        for (OpState op : OPERATORS) {
            state.enterState(op.getFirstChar(), op);
        }
    }

    public static void registerLeaveHandlers(DefaultParsingState state) {
        for (OpState op : OPERATORS) {
            state.putHandler(op.getFirstChar(), GlobalCharacterHandlers.LEAVE_STATE_HANDLER);
        }
    }

    static {
        HashMap<Character, ArrayList<String>> map = new HashMap<Character, ArrayList<String>>();
        for (OperatorType ot : OperatorType.values()) {
            if (!ot.value().startsWith(">") && !ot.value().startsWith("|") || ot.value().isEmpty()) continue;
            char c = ot.value().charAt(0);
            ArrayList<String> operators = (ArrayList<String>)map.get(Character.valueOf(c));
            if (operators == null) {
                operators = new ArrayList<String>();
                map.put(Character.valueOf(c), operators);
            }
            operators.add(ot.value());
        }
        for (Map.Entry entry : map.entrySet()) {
            OPERATORS.add(new OpState(((Character)entry.getKey()).charValue() == '>' ? "OUT_REDIRECT" : ID, ((Character)entry.getKey()).charValue()));
        }
    }

    public static class OpState
    extends DefaultParsingState {
        private final char firstChar;

        public OpState(String ID, char c) {
            super(ID);
            this.firstChar = c;
            this.setDefaultHandler(new CharacterHandler(){

                @Override
                public void handle(ParsingContext ctx) throws CommandFormatException {
                    ctx.resolveExpression(true, true);
                    GlobalCharacterHandlers.CONTENT_CHARACTER_HANDLER.handle(ctx);
                }
            });
            this.setEnterHandler(new CharacterHandler(){

                @Override
                public void handle(ParsingContext ctx) throws CommandFormatException {
                }
            });
        }

        public char getFirstChar() {
            return this.firstChar;
        }
    }
}

