/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.io.IOException;
import java.net.URI;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.as.controller.BlockingTimeout;
import org.jboss.as.controller.CurrentOperationIdHolder;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.remote.BlockingQueueOperationListener;
import org.jboss.as.controller.remote.TransactionalProtocolClient;
import org.jboss.as.controller.transform.TransformationTarget;
import org.jboss.as.controller.transform.TransformationTargetImpl;
import org.jboss.as.controller.transform.TransformerRegistry;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.ManagedServer;
import org.jboss.as.host.controller.ManagedServerBootCmdFactory;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.as.process.ProcessControllerClient;
import org.jboss.as.process.ProcessInfo;
import org.jboss.as.process.ProcessMessageHandler;
import org.jboss.as.protocol.mgmt.ManagementChannelHandler;
import org.jboss.as.server.security.DomainServerCredential;
import org.jboss.as.server.security.DomainServerEvidence;
import org.jboss.dmr.ModelNode;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.threads.AsyncFuture;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.provider.util.ProviderUtil;

public class ServerInventoryImpl
implements ServerInventory {
    private final ConcurrentMap<String, ManagedServer> servers = new ConcurrentHashMap<String, ManagedServer>();
    private final HostControllerEnvironment environment;
    private final ProcessControllerClient processControllerClient;
    private final URI managementURI;
    private final DomainController domainController;
    private final ExtensionRegistry extensionRegistry;
    private volatile boolean shutdown;
    private volatile boolean connectionFinished;
    private volatile CountDownLatch processInventoryLatch;
    private volatile Map<String, ProcessInfo> processInfos;
    private final Object shutdownCondition = new Object();

    ServerInventoryImpl(DomainController domainController, HostControllerEnvironment environment, URI managementURI, ProcessControllerClient processControllerClient, ExtensionRegistry extensionRegistry) {
        this.domainController = domainController;
        this.environment = environment;
        this.managementURI = managementURI;
        this.processControllerClient = processControllerClient;
        this.extensionRegistry = extensionRegistry;
    }

    @Override
    public String getServerProcessName(String serverName) {
        return ManagedServer.getServerProcessName(serverName);
    }

    @Override
    public String getProcessServerName(String processName) {
        return ManagedServer.getServerName(processName);
    }

    @Override
    public synchronized Map<String, ProcessInfo> determineRunningProcesses() {
        this.processInventoryLatch = new CountDownLatch(1);
        try {
            this.processControllerClient.requestProcessInventory();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            if (!this.processInventoryLatch.await(30L, TimeUnit.SECONDS)) {
                throw HostControllerLogger.ROOT_LOGGER.couldNotGetServerInventory(30L, TimeUnit.SECONDS.toString().toLowerCase(Locale.US));
            }
        }
        catch (InterruptedException e) {
            throw HostControllerLogger.ROOT_LOGGER.couldNotGetServerInventory(30L, TimeUnit.SECONDS.toString().toLowerCase(Locale.US));
        }
        return this.processInfos;
    }

    @Override
    public Map<String, ProcessInfo> determineRunningProcesses(boolean serversOnly) {
        Map<String, ProcessInfo> processInfos = this.determineRunningProcesses();
        if (!serversOnly) {
            return processInfos;
        }
        HashMap<String, ProcessInfo> processes = new HashMap<String, ProcessInfo>();
        for (Map.Entry<String, ProcessInfo> procEntry : processInfos.entrySet()) {
            if (!ManagedServer.isServerProcess(procEntry.getKey())) continue;
            processes.put(procEntry.getKey(), procEntry.getValue());
        }
        return processes;
    }

    @Override
    public ServerStatus determineServerStatus(String serverName) {
        ManagedServer server = (ManagedServer)this.servers.get(serverName);
        if (server == null) {
            return ServerStatus.STOPPED;
        }
        return server.getState();
    }

    @Override
    public ServerStatus startServer(String serverName, ModelNode domainModel) {
        return this.startServer(serverName, domainModel, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServerStatus startServer(String serverName, ModelNode domainModel, boolean blocking, boolean suspend) {
        ManagedServer newServer;
        if (this.shutdown || this.connectionFinished) {
            throw HostControllerLogger.ROOT_LOGGER.hostAlreadyShutdown();
        }
        ManagedServer server = (ManagedServer)this.servers.get(serverName);
        if (server != null && server.getState() == ServerStatus.FAILED) {
            HostControllerLogger.ROOT_LOGGER.failedToStartServer(null, serverName);
            this.stopServer(serverName, 1000, true);
            server = null;
        }
        if (server == null && (server = this.servers.putIfAbsent(serverName, newServer = this.createManagedServer(serverName))) == null) {
            server = newServer;
        }
        server.start(this.createBootFactory(serverName, domainModel, suspend));
        Object object = this.shutdownCondition;
        synchronized (object) {
            this.shutdownCondition.notifyAll();
        }
        if (blocking) {
            server.awaitState(ManagedServer.InternalState.SERVER_STARTED);
        } else {
            server.awaitState(ManagedServer.InternalState.SERVER_STARTING);
        }
        return server.getState();
    }

    private String createServerAuthToken(String serverName) {
        byte[] tokenBytes = new byte[32];
        new SecureRandom().nextBytes(tokenBytes);
        String serverAuthToken = "SAT" + Base64.getEncoder().encodeToString(tokenBytes);
        return serverAuthToken;
    }

    @Override
    public ServerStatus restartServer(String serverName, int gracefulTimeout, ModelNode domainModel) {
        return this.restartServer(serverName, gracefulTimeout, domainModel, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServerStatus restartServer(String serverName, int gracefulTimeout, ModelNode domainModel, boolean blocking, boolean suspend) {
        this.stopServer(serverName, gracefulTimeout);
        Object object = this.shutdownCondition;
        synchronized (object) {
            while (true) {
                if (this.shutdown || this.connectionFinished) {
                    throw HostControllerLogger.ROOT_LOGGER.hostAlreadyShutdown();
                }
                if (!this.servers.containsKey(serverName)) break;
                try {
                    this.shutdownCondition.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
        this.startServer(serverName, domainModel, blocking, suspend);
        return this.determineServerStatus(serverName);
    }

    @Override
    public ServerStatus stopServer(String serverName, int gracefulTimeout) {
        return this.stopServer(serverName, gracefulTimeout, false);
    }

    @Override
    public ServerStatus stopServer(String serverName, int gracefulTimeout, boolean blocking) {
        ManagedServer server = (ManagedServer)this.servers.get(serverName);
        if (server == null) {
            return ServerStatus.STOPPED;
        }
        Integer currentOperationID = CurrentOperationIdHolder.getCurrentOperationID();
        server.stop(currentOperationID == null ? null : Integer.valueOf(gracefulTimeout));
        if (blocking) {
            server.awaitState(ManagedServer.InternalState.STOPPED);
        }
        return server.getState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconnectServer(String serverName, ModelNode domainModel, boolean running, boolean stopping) {
        if (this.shutdown || this.connectionFinished) {
            throw HostControllerLogger.ROOT_LOGGER.hostAlreadyShutdown();
        }
        ManagedServer existing = (ManagedServer)this.servers.get(serverName);
        if (existing != null) {
            HostControllerLogger.ROOT_LOGGER.existingServerWithState(serverName, existing.getState());
            return;
        }
        ManagedServer server = this.createManagedServer(serverName);
        existing = this.servers.putIfAbsent(serverName, server);
        if (existing != null) {
            HostControllerLogger.ROOT_LOGGER.existingServerWithState(serverName, existing.getState());
            return;
        }
        if (running) {
            if (!stopping) {
                server.reconnectServerProcess(this.createBootFactory(serverName, domainModel, false));
            } else {
                server.setServerProcessStopping();
            }
        } else {
            server.removeServerProcess();
        }
        Object object = this.shutdownCondition;
        synchronized (object) {
            this.shutdownCondition.notifyAll();
        }
    }

    @Override
    public ServerStatus reloadServer(String serverName, boolean blocking, boolean suspend) {
        if (this.shutdown || this.connectionFinished) {
            throw HostControllerLogger.ROOT_LOGGER.hostAlreadyShutdown();
        }
        ManagedServer server = (ManagedServer)this.servers.get(serverName);
        if (server == null) {
            return ServerStatus.STOPPED;
        }
        if (server.reload(CurrentOperationIdHolder.getCurrentOperationID(), suspend)) {
            if (blocking) {
                server.awaitState(ManagedServer.InternalState.SERVER_STARTED);
            } else {
                server.awaitState(ManagedServer.InternalState.SERVER_STARTING);
            }
        }
        return this.determineServerStatus(serverName);
    }

    @Override
    public void destroyServer(String serverName) {
        ManagedServer server = (ManagedServer)this.servers.get(serverName);
        if (server == null) {
            return;
        }
        server.destroy();
    }

    @Override
    public void killServer(String serverName) {
        ManagedServer server = (ManagedServer)this.servers.get(serverName);
        if (server == null) {
            return;
        }
        server.kill();
    }

    @Override
    public void stopServers(int gracefulTimeout) {
        this.stopServers(gracefulTimeout, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopServers(int gracefulTimeout, boolean blockUntilStopped) {
        for (ManagedServer server : this.servers.values()) {
            Integer currentOperationID = CurrentOperationIdHolder.getCurrentOperationID();
            server.stop(currentOperationID == null ? null : Integer.valueOf(gracefulTimeout));
        }
        if (blockUntilStopped) {
            Object object = this.shutdownCondition;
            synchronized (object) {
                while (!this.connectionFinished) {
                    int count = 0;
                    block10: for (ManagedServer server : this.servers.values()) {
                        ServerStatus state = server.getState();
                        switch (state) {
                            case DISABLED: 
                            case FAILED: 
                            case STOPPED: {
                                continue block10;
                            }
                        }
                        ++count;
                    }
                    if (count == 0) break;
                    try {
                        this.shutdownCondition.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
            }
        }
    }

    @Override
    public void awaitServersState(Collection<String> serverNames, boolean started) {
        for (String serverName : serverNames) {
            ManagedServer server = (ManagedServer)this.servers.get(serverName);
            if (server == null) continue;
            server.awaitState(started ? ManagedServer.InternalState.SERVER_STARTED : ManagedServer.InternalState.STOPPED);
        }
    }

    @Override
    public List<ModelNode> suspendServers(Set<String> serverNames, BlockingTimeout blockingTimeout) {
        return this.suspendServers(serverNames, 0, blockingTimeout);
    }

    @Override
    public List<ModelNode> resumeServers(Set<String> serverNames, BlockingTimeout blockingTimeout) {
        AsyncFuture<OperationResponse> future;
        ArrayList<ModelNode> errorResults = new ArrayList<ModelNode>();
        HashMap<String, OperationData> operationDataMap = new HashMap<String, OperationData>();
        for (String string : serverNames) {
            ManagedServer server = (ManagedServer)this.servers.get(string);
            if (server == null) continue;
            try {
                int blockingTimeoutValue = blockingTimeout.getProxyBlockingTimeout(server.getAddress(), (ProxyController)server.getProxyController());
                BlockingQueueOperationListener listener = new BlockingQueueOperationListener();
                future = server.resume((BlockingQueueOperationListener<TransactionalProtocolClient.Operation>)listener);
                operationDataMap.put(string, new OperationData(blockingTimeoutValue, future, (BlockingQueueOperationListener<TransactionalProtocolClient.Operation>)listener));
            }
            catch (IOException e) {
                HostControllerLogger.ROOT_LOGGER.resumeExecutionFailed(e, string);
                errorResults.add(new ModelNode(HostControllerLogger.ROOT_LOGGER.resumeExecutionFailedMsg(string)));
            }
        }
        for (Map.Entry entry : operationDataMap.entrySet()) {
            OperationData operationData = (OperationData)entry.getValue();
            String serverName = (String)entry.getKey();
            int timeout = operationData.blockingTimeout;
            future = operationData.future;
            BlockingQueueOperationListener<TransactionalProtocolClient.Operation> listener = operationData.listener;
            try {
                TransactionalProtocolClient.PreparedOperation prepared = listener.retrievePreparedOperation((long)timeout, TimeUnit.MILLISECONDS);
                if (prepared == null) {
                    HostControllerLogger.ROOT_LOGGER.timedOutAwaitingResumeResponse(timeout, serverName);
                    errorResults.add(new ModelNode(HostControllerLogger.ROOT_LOGGER.timedOutAwaitingResumeResponseMsg(timeout, serverName)));
                    future.asyncCancel(true);
                    continue;
                }
                if (prepared.isFailed()) {
                    errorResults.add(this.appendServerNameToFailureResponse(serverName, prepared.getPreparedResult()));
                    continue;
                }
                prepared.commit();
                prepared.getFinalResult().get((long)timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                HostControllerLogger.ROOT_LOGGER.interruptedAwaitingResumeResponse(e, serverName);
                errorResults.add(new ModelNode(HostControllerLogger.ROOT_LOGGER.interruptedAwaitingResumeResponseMsg(serverName)));
                future.asyncCancel(true);
                Thread.currentThread().interrupt();
            }
            catch (TimeoutException e) {
                HostControllerLogger.ROOT_LOGGER.timedOutAwaitingResumeResponse(timeout, serverName);
                errorResults.add(new ModelNode(HostControllerLogger.ROOT_LOGGER.timedOutAwaitingResumeResponseMsg(timeout, serverName)));
                future.asyncCancel(true);
            }
            catch (ExecutionException e) {
                HostControllerLogger.ROOT_LOGGER.resumeListenerFailed(e, serverName);
                errorResults.add(new ModelNode(HostControllerLogger.ROOT_LOGGER.resumeListenerFailedMsg(serverName)));
                future.asyncCancel(true);
            }
        }
        return errorResults;
    }

    @Override
    public List<ModelNode> suspendServers(Set<String> serverNames, int timeoutInSeconds, BlockingTimeout blockingTimeout) {
        AsyncFuture<OperationResponse> future;
        ArrayList<ModelNode> errorResults = new ArrayList<ModelNode>();
        HashMap<String, OperationData> operationDataMap = new HashMap<String, OperationData>();
        for (String string : serverNames) {
            ManagedServer server = (ManagedServer)this.servers.get(string);
            if (server == null) continue;
            try {
                int blockingTimeoutValue = blockingTimeout.getProxyBlockingTimeout(server.getAddress(), (ProxyController)server.getProxyController());
                BlockingQueueOperationListener listener = new BlockingQueueOperationListener();
                future = server.suspend(timeoutInSeconds, (BlockingQueueOperationListener<TransactionalProtocolClient.Operation>)listener);
                operationDataMap.put(string, new OperationData(blockingTimeoutValue, future, (BlockingQueueOperationListener<TransactionalProtocolClient.Operation>)listener));
            }
            catch (IOException e) {
                HostControllerLogger.ROOT_LOGGER.suspendExecutionFailed(e, string);
                errorResults.add(new ModelNode(HostControllerLogger.ROOT_LOGGER.suspendExecutionFailedMsg(string)));
            }
        }
        for (Map.Entry entry : operationDataMap.entrySet()) {
            OperationData operationData = (OperationData)entry.getValue();
            String serverName = (String)entry.getKey();
            int timeout = operationData.blockingTimeout;
            future = operationData.future;
            BlockingQueueOperationListener<TransactionalProtocolClient.Operation> listener = operationData.listener;
            try {
                TransactionalProtocolClient.PreparedOperation prepared = listener.retrievePreparedOperation((long)timeout, TimeUnit.MILLISECONDS);
                if (prepared == null) {
                    HostControllerLogger.ROOT_LOGGER.timedOutAwaitingSuspendResponse(timeout, serverName);
                    errorResults.add(new ModelNode(HostControllerLogger.ROOT_LOGGER.timedOutAwaitingSuspendResponseMsg(timeout, serverName)));
                    future.asyncCancel(true);
                    continue;
                }
                if (prepared.isFailed()) {
                    errorResults.add(this.appendServerNameToFailureResponse(serverName, prepared.getPreparedResult()));
                    continue;
                }
                prepared.commit();
                prepared.getFinalResult().get((long)timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                HostControllerLogger.ROOT_LOGGER.interruptedAwaitingSuspendResponse(e, serverName);
                errorResults.add(new ModelNode(HostControllerLogger.ROOT_LOGGER.interruptedAwaitingSuspendResponseMsg(serverName)));
                future.asyncCancel(true);
                Thread.currentThread().interrupt();
            }
            catch (TimeoutException e) {
                HostControllerLogger.ROOT_LOGGER.timedOutAwaitingSuspendResponse(timeout, serverName);
                errorResults.add(new ModelNode(HostControllerLogger.ROOT_LOGGER.timedOutAwaitingSuspendResponseMsg(timeout, serverName)));
                future.asyncCancel(true);
            }
            catch (ExecutionException e) {
                HostControllerLogger.ROOT_LOGGER.suspendListenerFailed(e, serverName);
                errorResults.add(new ModelNode(HostControllerLogger.ROOT_LOGGER.suspendListenerFailedMsg(serverName)));
                future.asyncCancel(true);
            }
        }
        return errorResults;
    }

    void shutdown(boolean shutdownServers, int gracefulTimeout, boolean blockUntilStopped) {
        boolean shutdown = this.shutdown;
        this.shutdown = true;
        if (!shutdown) {
            if (this.connectionFinished) {
                return;
            }
            if (shutdownServers) {
                this.stopServers(gracefulTimeout, blockUntilStopped);
            }
        }
    }

    @Override
    public ProxyController serverCommunicationRegistered(String serverProcessName, ManagementChannelHandler channelAssociation) {
        if (this.shutdown || this.connectionFinished) {
            throw HostControllerLogger.ROOT_LOGGER.hostAlreadyShutdown();
        }
        String serverName = ManagedServer.getServerName(serverProcessName);
        final ManagedServer server = (ManagedServer)this.servers.get(serverName);
        if (server == null) {
            HostControllerLogger.ROOT_LOGGER.noServerAvailable(serverName);
            return null;
        }
        try {
            final TransactionalProtocolClient client = server.channelRegistered(channelAssociation);
            Channel channel = channelAssociation.getChannel();
            channel.addCloseHandler((CloseHandler)new CloseHandler<Channel>(){

                public void handleClose(Channel closed, IOException exception) {
                    boolean shuttingDown;
                    boolean bl = shuttingDown = ServerInventoryImpl.this.shutdown || ServerInventoryImpl.this.connectionFinished;
                    if (server.callbackUnregistered(client, shuttingDown)) {
                        ServerInventoryImpl.this.domainController.unregisterRunningServer(server.getServerName());
                    }
                }
            });
            return server.getProxyController();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean serverReconnected(String serverProcessName, ManagementChannelHandler channelHandler) {
        String serverName = ManagedServer.getServerName(serverProcessName);
        ManagedServer server = (ManagedServer)this.servers.get(serverName);
        this.serverCommunicationRegistered(serverProcessName, channelHandler);
        this.serverStarted(serverProcessName);
        this.domainController.registerRunningServer((ProxyController)server.getProxyController());
        return !server.isRequiresReload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serverProcessStopped(String serverProcessName) {
        String serverName = ManagedServer.getServerName(serverProcessName);
        ManagedServer server = (ManagedServer)this.servers.get(serverName);
        if (server == null) {
            HostControllerLogger.ROOT_LOGGER.noServerAvailable(serverName);
            return;
        }
        this.domainController.unregisterRunningServer(server.getServerName());
        server.processFinished();
        Object object = this.shutdownCondition;
        synchronized (object) {
            this.shutdownCondition.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionFinished() {
        this.connectionFinished = true;
        HostControllerLogger.ROOT_LOGGER.debug("process controller connection closed.");
        Object object = this.shutdownCondition;
        synchronized (object) {
            this.shutdownCondition.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serverStarted(String serverProcessName) {
        String serverName = ManagedServer.getServerName(serverProcessName);
        ManagedServer server = (ManagedServer)this.servers.get(serverName);
        if (server == null) {
            HostControllerLogger.ROOT_LOGGER.noServerAvailable(serverName);
            return;
        }
        server.serverStarted(null);
        Object object = this.shutdownCondition;
        synchronized (object) {
            this.shutdownCondition.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serverStartFailed(String serverProcessName) {
        String serverName = ManagedServer.getServerName(serverProcessName);
        ManagedServer server = (ManagedServer)this.servers.get(serverName);
        if (server == null) {
            HostControllerLogger.ROOT_LOGGER.noServerAvailable(serverName);
            return;
        }
        server.serverStartFailed();
        Object object = this.shutdownCondition;
        synchronized (object) {
            this.shutdownCondition.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serverProcessAdded(String serverProcessName) {
        String serverName = ManagedServer.getServerName(serverProcessName);
        ManagedServer server = (ManagedServer)this.servers.get(serverName);
        if (server == null) {
            HostControllerLogger.ROOT_LOGGER.noServerAvailable(serverName);
            return;
        }
        server.processAdded();
        Object object = this.shutdownCondition;
        synchronized (object) {
            this.shutdownCondition.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serverProcessStarted(String serverProcessName) {
        String serverName = ManagedServer.getServerName(serverProcessName);
        ManagedServer server = (ManagedServer)this.servers.get(serverName);
        if (server == null) {
            HostControllerLogger.ROOT_LOGGER.noServerAvailable(serverName);
            return;
        }
        server.processStarted();
        Object object = this.shutdownCondition;
        synchronized (object) {
            this.shutdownCondition.notifyAll();
        }
    }

    @Override
    public void serverUnstable(String serverProcessName) {
        String serverName = ManagedServer.getServerName(serverProcessName);
        ManagedServer server = (ManagedServer)this.servers.get(serverName);
        boolean change = true;
        if (server != null) {
            change = server.processUnstable();
        }
        if (change) {
            this.domainController.reportServerInstability(serverName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serverProcessRemoved(String serverProcessName) {
        String serverName = ManagedServer.getServerName(serverProcessName);
        ManagedServer server = (ManagedServer)this.servers.remove(serverName);
        if (server == null) {
            HostControllerLogger.ROOT_LOGGER.noServerAvailable(serverName);
            return;
        }
        server.processRemoved();
        Object object = this.shutdownCondition;
        synchronized (object) {
            this.shutdownCondition.notifyAll();
        }
    }

    @Override
    public void operationFailed(String serverProcessName, ProcessMessageHandler.OperationType type) {
        String serverName = ManagedServer.getServerName(serverProcessName);
        ManagedServer server = (ManagedServer)this.servers.get(serverName);
        if (server == null) {
            HostControllerLogger.ROOT_LOGGER.noServerAvailable(serverName);
            return;
        }
        switch (type) {
            case ADD: {
                server.transitionFailed(ManagedServer.InternalState.PROCESS_ADDING);
                break;
            }
            case START: {
                server.transitionFailed(ManagedServer.InternalState.PROCESS_STARTING);
                break;
            }
            case STOP: {
                server.transitionFailed(ManagedServer.InternalState.PROCESS_STOPPING);
                break;
            }
            case SEND_STDIN: 
            case RECONNECT: {
                server.transitionFailed(ManagedServer.InternalState.SERVER_STARTING);
                break;
            }
            case REMOVE: {
                server.transitionFailed(ManagedServer.InternalState.PROCESS_REMOVING);
            }
        }
    }

    @Override
    public void processInventory(Map<String, ProcessInfo> processInfos) {
        this.processInfos = processInfos;
        if (this.processInventoryLatch != null) {
            this.processInventoryLatch.countDown();
        }
    }

    private ManagedServer createManagedServer(String serverName) {
        String serverAuthToken = this.createServerAuthToken(serverName);
        DomainServerCredential domainServerCredential = new DomainServerCredential(serverAuthToken);
        String hostControllerName = this.domainController.getLocalHostInfo().getLocalHostName();
        Map subsystems = TransformerRegistry.resolveVersions((ExtensionRegistry)this.extensionRegistry);
        ModelVersion modelVersion = ModelVersion.create((int)25, (int)0, (int)0);
        TransformationTargetImpl target = TransformationTargetImpl.create((String)hostControllerName, (TransformerRegistry)this.extensionRegistry.getTransformerRegistry(), (ModelVersion)modelVersion, (Map)subsystems, (TransformationTarget.TransformationTargetType)TransformationTarget.TransformationTargetType.SERVER);
        return new ManagedServer(hostControllerName, serverName, domainServerCredential, this.processControllerClient, this.managementURI, (TransformationTarget)target);
    }

    public boolean validateServerEvidence(Evidence evidence) {
        String serverName;
        ManagedServer managedServer;
        DomainServerEvidence domainServerEvidence = (DomainServerEvidence)evidence.castAs(DomainServerEvidence.class);
        if (domainServerEvidence != null && (managedServer = (ManagedServer)this.servers.get(serverName = domainServerEvidence.getDefaultPrincipal().getName())) != null) {
            Credential serverCredential = managedServer.getCredential();
            return serverCredential.verify(ProviderUtil.INSTALLED_PROVIDERS, (Evidence)domainServerEvidence);
        }
        return false;
    }

    private ManagedServerBootCmdFactory createBootFactory(String serverName, ModelNode domainModel, boolean suspend) {
        String hostControllerName = this.domainController.getLocalHostInfo().getLocalHostName();
        ModelNode hostModel = domainModel.require("host").require(hostControllerName);
        return new ManagedServerBootCmdFactory(serverName, domainModel, hostModel, this.environment, this.domainController.getExpressionResolver(), suspend);
    }

    private ModelNode appendServerNameToFailureResponse(String serverName, ModelNode failureResponse) {
        String currentDescription = failureResponse.get("failure-description").asString();
        return new ModelNode(String.format("%s server: %s", currentDescription, serverName));
    }

    private class OperationData {
        int blockingTimeout;
        AsyncFuture<OperationResponse> future;
        BlockingQueueOperationListener<TransactionalProtocolClient.Operation> listener;

        public OperationData(int blockingTimeout, AsyncFuture<OperationResponse> future, BlockingQueueOperationListener<TransactionalProtocolClient.Operation> listener) {
            this.blockingTimeout = blockingTimeout;
            this.future = future;
            this.listener = listener;
        }
    }
}

