/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.concurrent.atomic.AtomicLong;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemRootResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class DefaultStatefulBeanSessionTimeoutWriteHandler
extends AbstractWriteAttributeHandler<Void> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"ejb3", "defaultStatefulSessionTimeout"});
    static final DefaultStatefulBeanSessionTimeoutWriteHandler INSTANCE = new DefaultStatefulBeanSessionTimeoutWriteHandler();
    static final AtomicLong INITIAL_TIMEOUT_VALUE = new AtomicLong(-1L);

    private DefaultStatefulBeanSessionTimeoutWriteHandler() {
        super(new AttributeDefinition[]{EJB3SubsystemRootResourceDefinition.DEFAULT_STATEFUL_BEAN_SESSION_TIMEOUT});
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> voidHandbackHolder) throws OperationFailedException {
        ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        this.updateOrCreateDefaultStatefulBeanSessionTimeoutService(context, model);
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        ModelNode restored = context.readResource(PathAddress.EMPTY_ADDRESS).getModel().clone();
        restored.get(attributeName).set(valueToRestore);
        this.updateOrCreateDefaultStatefulBeanSessionTimeoutService(context, restored);
    }

    void updateOrCreateDefaultStatefulBeanSessionTimeoutService(OperationContext context, ModelNode model) throws OperationFailedException {
        long defaultSessionTimeout = EJB3SubsystemRootResourceDefinition.DEFAULT_STATEFUL_BEAN_SESSION_TIMEOUT.resolveModelAttribute(context, model).asLong();
        ServiceController sc = context.getServiceRegistry(true).getRequiredService(SERVICE_NAME);
        AtomicLong existingValue = (AtomicLong)sc.getValue();
        existingValue.set(defaultSessionTimeout);
    }
}

