/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import java.util.Set;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.DocumentReferenceExtractionHelper;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionExtractionHelper;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SingleTypeNameExtractionHelper;

public final class SearchProjectionBackendContext {
    private final ProjectionExtractionHelper<String> complexMappedTypeNameProjectionExtractionHelper;
    private final ProjectionExtractionHelper<String> idProjectionExtractionHelper;

    public SearchProjectionBackendContext(ProjectionExtractionHelper<String> complexMappedTypeNameProjectionExtractionHelper, ProjectionExtractionHelper<String> idProjectionExtractionHelper) {
        this.complexMappedTypeNameProjectionExtractionHelper = complexMappedTypeNameProjectionExtractionHelper;
        this.idProjectionExtractionHelper = idProjectionExtractionHelper;
    }

    ProjectionExtractionHelper<String> createMappedTypeNameExtractionHelper(ElasticsearchSearchIndexScope<?> scope) {
        Set<String> mappedTypeNames = scope.mappedTypeNameToIndex().keySet();
        if (mappedTypeNames.size() == 1) {
            return new SingleTypeNameExtractionHelper(mappedTypeNames.iterator().next());
        }
        return this.complexMappedTypeNameProjectionExtractionHelper;
    }

    DocumentReferenceExtractionHelper createDocumentReferenceExtractionHelper(ProjectionExtractionHelper<String> mappedTypeNameExtractionHelper) {
        return new DocumentReferenceExtractionHelper(mappedTypeNameExtractionHelper, this.idProjectionExtractionHelper);
    }

    public ProjectionExtractionHelper<String> idProjectionExtractionHelper() {
        return this.idProjectionExtractionHelper;
    }
}

