/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.bean;

import java.io.StringReader;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.json.JsonObject;
import org.apache.activemq.artemis.json.JsonObjectBuilder;
import org.apache.activemq.artemis.utils.JsonLoader;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaBean<T> {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private CopyOnWriteArrayList<MetaData<T>> metaData = new CopyOnWriteArrayList();

    public MetaBean add(Class type, String name, BiConsumer<T, ? extends Object> setter, Function<T, ? extends Object> getter, Predicate<T> gate) {
        if (type != String.class && type != SimpleString.class && type != Integer.class && type != Long.class && type != Double.class && type != Float.class && type != Boolean.class && !Enum.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("invalid type " + type);
        }
        this.metaData.add(new MetaData<T>(type, name, setter, getter, gate));
        return this;
    }

    public <Z> MetaBean add(Class<Z> type, String name, BiConsumer<T, Z> setter, Function<T, Z> getter) {
        return this.add(type, name, setter, getter, null);
    }

    public JsonObject toJSON(T object, boolean ignoreNullAttributes) {
        JsonObjectBuilder builder = JsonLoader.createObjectBuilder();
        this.parseToJSON(object, builder, ignoreNullAttributes);
        return builder.build();
    }

    public void parseToJSON(T object, JsonObjectBuilder builder, boolean ignoreNullAttributes) {
        logger.debug("Parsing object {}", object);
        this.forEach((type, name, setter, getter, gate) -> {
            logger.debug("Parsing {} {} {} {} {}", new Object[]{type, name, setter, getter, gate});
            Object value = getter.apply(object);
            if (ignoreNullAttributes && value == null) {
                logger.debug("Ignoring null attribute {}", (Object)name);
                return;
            }
            if (gate == null || gate.test(object)) {
                if (logger.isTraceEnabled()) {
                    if (gate != null) {
                        logger.trace("Gate passed for {}", (Object)name);
                    }
                    if (value == null) {
                        logger.debug("Result for {} = IS NULL", (Object)name);
                    } else {
                        logger.debug("Result for {} = {}, type={}", new Object[]{name, value, value.getClass()});
                    }
                }
                if (value == null) {
                    logger.trace("Setting {} as null", (Object)name);
                    builder.addNull(name);
                } else if (type == String.class || type == SimpleString.class) {
                    logger.trace("Setting {} as String {}", (Object)name, value);
                    builder.add(name, String.valueOf(value));
                } else if (Number.class.isAssignableFrom(type) && value instanceof Number) {
                    if (value instanceof Double || value instanceof Float) {
                        logger.trace("Setting {} as double {}", (Object)name, value);
                        builder.add(name, ((Number)value).doubleValue());
                    } else {
                        logger.trace("Setting {} as long {}", (Object)name, value);
                        builder.add(name, ((Number)value).longValue());
                    }
                } else if (type == Boolean.class) {
                    builder.add(name, (Boolean)value);
                } else if (Enum.class.isAssignableFrom(type)) {
                    builder.add(name, String.valueOf(value));
                } else {
                    builder.add(name, String.valueOf(value));
                }
            } else {
                logger.debug("Gate ignored on {}", (Object)name);
            }
        });
    }

    public void setRandom(T randomObject) {
        this.forEach((type, name, setter, getter, gate) -> {
            if (Enum.class.isAssignableFrom(type)) {
                T[] enumValues = type.getEnumConstants();
                int randomInt = RandomUtil.randomInterval(0, enumValues.length - 1);
                setter.accept(randomObject, enumValues[randomInt]);
            } else if (type == String.class) {
                setter.accept(randomObject, RandomUtil.randomString());
            } else if (type == SimpleString.class) {
                setter.accept(randomObject, RandomUtil.randomSimpleString());
            } else if (type == Integer.class) {
                setter.accept(randomObject, RandomUtil.randomPositiveInt());
            } else if (type == Long.class) {
                setter.accept(randomObject, RandomUtil.randomPositiveLong());
            } else if (type == Double.class) {
                setter.accept(randomObject, RandomUtil.randomDouble());
            } else if (type == Float.class) {
                setter.accept(randomObject, Float.valueOf(RandomUtil.randomFloat()));
            } else if (type == Boolean.class) {
                setter.accept(randomObject, RandomUtil.randomBoolean());
            }
        });
    }

    public void copy(T source, T target) {
        this.forEach((type, name, setter, getter, gate) -> {
            Object sourceAttribute = getter.apply(source);
            setter.accept(target, sourceAttribute);
        });
    }

    public void forEach(MetadataListener listener) {
        this.metaData.forEach((Consumer<MetaData<T>>)((Consumer<MetaData>)m -> {
            try {
                listener.metaItem(m.type, m.name, m.setter, m.getter, m.gate);
            }
            catch (Throwable e) {
                logger.warn("Error parsing {}", m, (Object)e);
                throw new RuntimeException("Error while parsing " + m, e);
            }
        }));
    }

    public void fromJSON(T resultObject, String jsonString) {
        logger.debug("Parsing JSON {}", (Object)jsonString);
        JsonObject json = JsonLoader.readObject(new StringReader(jsonString));
        this.forEach((type, name, setter, getter, gate) -> {
            if (json.containsKey(name)) {
                if (json.isNull(name)) {
                    setter.accept(resultObject, null);
                } else if (type == String.class) {
                    setter.accept(resultObject, json.getString(name));
                } else if (type == SimpleString.class) {
                    setter.accept(resultObject, SimpleString.toSimpleString(json.getString(name)));
                } else if (type == Integer.class) {
                    setter.accept(resultObject, json.getInt(name));
                } else if (type == Long.class) {
                    setter.accept(resultObject, json.getJsonNumber(name).longValue());
                } else if (type == Double.class) {
                    setter.accept(resultObject, json.getJsonNumber(name).doubleValue());
                } else if (type == Float.class) {
                    setter.accept(resultObject, Float.valueOf(json.getJsonNumber(name).numberValue().floatValue()));
                } else if (type == Boolean.class) {
                    setter.accept(resultObject, json.getBoolean(name));
                } else if (Enum.class.isAssignableFrom(type)) {
                    String value = json.getString(name);
                    Object enumValue = Enum.valueOf(type, value);
                    setter.accept(resultObject, enumValue);
                }
            }
        });
    }

    public static interface MetadataListener<T> {
        public void metaItem(Class var1, String var2, BiConsumer<T, Object> var3, Function<T, Object> var4, Predicate<Object> var5);
    }

    static class MetaData<T> {
        Class type;
        String name;
        BiConsumer<T, ?> setter;
        Function<T, ?> getter;
        Predicate<?> gate;

        <Z> MetaData(Class<Z> type, String name, BiConsumer<T, Object> setter, Function<T, Object> getter, Predicate<T> gate) {
            this.type = type;
            this.name = name;
            this.setter = setter;
            this.getter = getter;
            this.gate = gate;
        }

        public String toString() {
            return "MetaData{type=" + this.type + ", name='" + this.name + "'}";
        }
    }
}

