/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.discovery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.wildfly.discovery.impl.AggregateDiscoveryProvider;
import org.wildfly.discovery.spi.DiscoveryProvider;
import org.wildfly.extension.discovery.DiscoveryProviderRegistrar;
import org.wildfly.extension.discovery.DiscoverySubsystemRegistrar;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.capability.CapabilityReferenceRecorder;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public class AggregateDiscoveryProviderRegistrar
extends DiscoveryProviderRegistrar {
    static final PathElement PATH = PathElement.pathElement((String)"aggregate-provider");
    private static final StringListAttributeDefinition PROVIDER_NAMES = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("providers").setCapabilityReference((org.jboss.as.controller.CapabilityReferenceRecorder)CapabilityReferenceRecorder.builder((RuntimeCapability)DISCOVERY_PROVIDER_CAPABILITY, (UnaryServiceDescriptor)DISCOVERY_PROVIDER_DESCRIPTOR).build())).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final Collection<AttributeDefinition> ATTRIBUTES = List.of(PROVIDER_NAMES);

    AggregateDiscoveryProviderRegistrar() {
        super(PATH, (ResourceDescriptor.Builder)ResourceDescriptor.builder((ResourceDescriptionResolver)DiscoverySubsystemRegistrar.RESOLVER.createChildResolver(PATH)).addAttributes(ATTRIBUTES));
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        List providers = PROVIDER_NAMES.unwrap((ExpressionResolver)context, model);
        final ArrayList<ServiceDependency> dependencies = new ArrayList<ServiceDependency>(providers.size());
        for (String provider : providers) {
            dependencies.add(ServiceDependency.on((UnaryServiceDescriptor)DISCOVERY_PROVIDER_DESCRIPTOR, (String)provider));
        }
        Supplier<DiscoveryProvider> factory = new Supplier<DiscoveryProvider>(){

            @Override
            public DiscoveryProvider get() {
                return new AggregateDiscoveryProvider((DiscoveryProvider[])dependencies.stream().map(Supplier::get).toArray(DiscoveryProvider[]::new));
            }
        };
        return (ResourceServiceInstaller)((CapabilityServiceInstaller.Builder)CapabilityServiceInstaller.builder((RuntimeCapability)DISCOVERY_PROVIDER_CAPABILITY, (Supplier)factory).requires(dependencies)).build();
    }
}

