/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.authz.jacc;

import jakarta.security.jacc.PolicyContextHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.wildfly.security.authz.jacc.HttpServletRequestContext;
import org.wildfly.security.authz.jacc.RequestPolicyContextHandler;
import org.wildfly.security.authz.jacc.SecurityIdentityHandler;
import org.wildfly.security.authz.jacc.SubjectPolicyContextHandler;

public class ElytronPolicyContextHandlerFactory {
    public static List<PolicyContextHandler> getPolicyContextHandlers() {
        HttpServletRequestContext httpServletRequestContext = ElytronPolicyContextHandlerFactory.getHttpServletRequestContext();
        ArrayList<PolicyContextHandler> policyContextHandlers = new ArrayList<PolicyContextHandler>(httpServletRequestContext != null ? 3 : 2);
        policyContextHandlers.add(new SecurityIdentityHandler());
        policyContextHandlers.add(new SubjectPolicyContextHandler());
        if (httpServletRequestContext != null) {
            policyContextHandlers.add(new RequestPolicyContextHandler(httpServletRequestContext));
        }
        return policyContextHandlers;
    }

    private static HttpServletRequestContext getHttpServletRequestContext() {
        ServiceLoader<HttpServletRequestContext> requestContextLoader = ServiceLoader.load(HttpServletRequestContext.class, ElytronPolicyContextHandlerFactory.class.getClassLoader());
        Iterator<HttpServletRequestContext> iterator = requestContextLoader.iterator();
        while (true) {
            try {
                if (!iterator.hasNext()) {
                    return null;
                }
                HttpServletRequestContext requestContext = iterator.next();
                return requestContext;
            }
            catch (ServiceConfigurationError serviceConfigurationError) {
                continue;
            }
            break;
        }
    }
}

