/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.named;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.query.named.NamedQueryMemento;

public abstract class AbstractNamedQueryMemento
implements NamedQueryMemento {
    private final String name;
    private final Boolean cacheable;
    private final String cacheRegion;
    private final CacheMode cacheMode;
    private final FlushMode flushMode;
    private final Boolean readOnly;
    private final Integer timeout;
    private final Integer fetchSize;
    private final String comment;
    private final Map<String, Object> hints;

    protected AbstractNamedQueryMemento(String name, Boolean cacheable, String cacheRegion, CacheMode cacheMode, FlushMode flushMode, Boolean readOnly, Integer timeout, Integer fetchSize, String comment, Map<String, Object> hints) {
        this.name = name;
        this.cacheable = cacheable;
        this.cacheRegion = cacheRegion;
        this.cacheMode = cacheMode;
        this.flushMode = flushMode;
        this.readOnly = readOnly;
        this.timeout = timeout;
        this.fetchSize = fetchSize;
        this.comment = comment;
        this.hints = hints;
    }

    @Override
    public String getRegistrationName() {
        return this.name;
    }

    @Override
    public Boolean getCacheable() {
        return this.cacheable;
    }

    @Override
    public String getCacheRegion() {
        return this.cacheRegion;
    }

    @Override
    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    @Override
    public FlushMode getFlushMode() {
        return this.flushMode;
    }

    @Override
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    @Override
    public Integer getTimeout() {
        return this.timeout;
    }

    @Override
    public Integer getFetchSize() {
        return this.fetchSize;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public Map<String, Object> getHints() {
        return this.hints;
    }

    public static abstract class AbstractBuilder<T extends AbstractBuilder> {
        protected final String name;
        protected Set<String> querySpaces;
        protected Boolean cacheable;
        protected String cacheRegion;
        protected CacheMode cacheMode;
        protected FlushMode flushMode;
        protected Boolean readOnly;
        protected Integer timeout;
        protected Integer fetchSize;
        protected String comment;
        protected Map<String, Object> hints;

        public AbstractBuilder(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        protected abstract T getThis();

        public T addQuerySpaces(Set<String> querySpaces) {
            if (querySpaces == null || querySpaces.isEmpty()) {
                return this.getThis();
            }
            if (this.querySpaces == null) {
                this.querySpaces = new HashSet<String>();
            }
            this.querySpaces.addAll(querySpaces);
            return this.getThis();
        }

        public T addQuerySpace(String space) {
            if (this.querySpaces == null) {
                this.querySpaces = new HashSet<String>();
            }
            this.querySpaces.add(space);
            return this.getThis();
        }

        public T setCacheable(Boolean cacheable) {
            this.cacheable = cacheable;
            return this.getThis();
        }

        public T setCacheRegion(String cacheRegion) {
            this.cacheRegion = cacheRegion;
            return this.getThis();
        }

        public T setCacheMode(CacheMode cacheMode) {
            this.cacheMode = cacheMode;
            return this.getThis();
        }

        public T setTimeout(Integer timeout) {
            this.timeout = timeout;
            return this.getThis();
        }

        public T setFlushMode(FlushMode flushMode) {
            this.flushMode = flushMode;
            return this.getThis();
        }

        public T setReadOnly(Boolean readOnly) {
            this.readOnly = readOnly;
            return this.getThis();
        }

        public T setReadOnly(boolean readOnly) {
            this.readOnly = readOnly;
            return this.getThis();
        }

        public T setFetchSize(Integer fetchSize) {
            this.fetchSize = fetchSize;
            return this.getThis();
        }

        public T setComment(String comment) {
            this.comment = comment;
            return this.getThis();
        }

        public Set<String> getQuerySpaces() {
            return this.querySpaces;
        }

        public Boolean getCacheable() {
            return this.cacheable;
        }

        public String getCacheRegion() {
            return this.cacheRegion;
        }

        public CacheMode getCacheMode() {
            return this.cacheMode;
        }

        public FlushMode getFlushMode() {
            return this.flushMode;
        }

        public Boolean getReadOnly() {
            return this.readOnly;
        }

        public Integer getTimeout() {
            return this.timeout;
        }

        public Integer getFetchSize() {
            return this.fetchSize;
        }

        public String getComment() {
            return this.comment;
        }

        public void addHint(String name, Object value) {
            if (this.hints == null) {
                this.hints = new HashMap<String, Object>();
            }
            this.hints.put(name, value);
        }
    }
}

