/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.handlers;

import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceController;
import org.wildfly.extension.requestcontroller.RequestController;
import org.wildfly.extension.undertow.handlers.HandlerDefinition;
import org.wildfly.extension.undertow.handlers.HandlerFactory;
import org.wildfly.extension.undertow.handlers.HandlerService;

final class HandlerAdd
extends AbstractAddStepHandler {
    private HandlerFactory factory;

    HandlerAdd(HandlerFactory factory, Collection<AttributeDefinition> attributes) {
        super(attributes);
        this.factory = factory;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String name = context.getCurrentAddressValue();
        boolean capabilityAvailable = context.hasOptionalCapability("org.wildfly.request-controller", HandlerDefinition.CAPABILITY.getDynamicName(context.getCurrentAddress()), null);
        CapabilityServiceBuilder sb = context.getCapabilityServiceTarget().addCapability(HandlerDefinition.CAPABILITY);
        Consumer hhConsumer = sb.provides(HandlerDefinition.CAPABILITY);
        Supplier rcSupplier = capabilityAvailable ? sb.requiresCapability("org.wildfly.request-controller", RequestController.class, new String[0]) : null;
        sb.setInstance((Service)new HandlerService(hhConsumer, rcSupplier, this.factory.createHandler(context, model), name));
        sb.setInitialMode(ServiceController.Mode.ON_DEMAND);
        sb.install();
    }
}

