/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component;

import java.lang.reflect.Constructor;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ejb3.util.EjbValidationsUtil;
import org.jboss.as.ejb3.util.MethodInfoHelper;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;

public class EJBValidationConfigurator
implements ComponentConfigurator {
    public static final EJBValidationConfigurator INSTANCE = new EJBValidationConfigurator();

    private EJBValidationConfigurator() {
    }

    public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
        ClassReflectionIndex classIndex = ((DeploymentReflectionIndex)context.getDeploymentUnit().getAttachment(Attachments.REFLECTION_INDEX)).getClassIndex(configuration.getComponentClass());
        Constructor ctor = classIndex.getConstructor(MethodInfoHelper.EMPTY_STRING_ARRAY);
        boolean noInterface = false;
        for (ViewDescription view : description.getViews()) {
            if (!view.getViewClassName().equals(description.getComponentClassName())) continue;
            noInterface = true;
            break;
        }
        EjbValidationsUtil.verifyEjbClassAndDefaultConstructor(ctor, configuration.getComponentClass().getEnclosingClass(), noInterface, description.getComponentName(), description.getComponentClassName(), configuration.getComponentClass().getModifiers());
        EjbValidationsUtil.verifyEjbPublicMethodAreNotFinalNorStatic(configuration.getComponentClass().getMethods(), description.getComponentClassName());
        for (Class<?> interfaceClass : configuration.getComponentClass().getInterfaces()) {
            EjbValidationsUtil.verifyEjbPublicMethodAreNotFinalNorStatic(interfaceClass.getMethods(), interfaceClass.getCanonicalName());
        }
    }
}

