/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron.oidc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.jboss.as.controller.Feature;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.web.common.VirtualHttpServerMechanismFactoryMarkerUtility;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.ListenerMetaData;
import org.jboss.metadata.web.spec.LoginConfigMetaData;
import org.jboss.vfs.VirtualFile;
import org.wildfly.extension.elytron.oidc.OidcConfigService;
import org.wildfly.extension.elytron.oidc.OidcDeploymentMarker;
import org.wildfly.extension.elytron.oidc.SecureDeploymentDefinition;
import org.wildfly.extension.elytron.oidc._private.ElytronOidcLogger;
import org.wildfly.security.http.oidc.OidcConfigurationServletListener;

class OidcActivationProcessor
implements DeploymentUnitProcessor {
    private static final String OIDC_AUTH_METHOD = "OIDC";

    OidcActivationProcessor() {
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        LoginConfigMetaData loginConfig;
        OidcConfigService configService;
        boolean subsystemConfigured;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (warMetaData == null) {
            return;
        }
        JBossWebMetaData webMetaData = warMetaData.getMergedJBossWebMetaData();
        if (webMetaData == null) {
            webMetaData = new JBossWebMetaData();
            warMetaData.setMergedJBossWebMetaData(webMetaData);
        }
        boolean bl = subsystemConfigured = (configService = OidcConfigService.getInstance()).isSecureDeployment(deploymentUnit) && configService.isDeploymentConfigured(deploymentUnit);
        if (subsystemConfigured) {
            this.addOidcAuthDataAndConfig(phaseContext, configService, webMetaData);
        }
        if ((loginConfig = webMetaData.getLoginConfig()) != null && OIDC_AUTH_METHOD.equals(loginConfig.getAuthMethod())) {
            VirtualFile oidcConfigurationFile;
            if (!subsystemConfigured && deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT) != null && (oidcConfigurationFile = ((ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot().getChild("WEB-INF/oidc.json")).exists()) {
                try (InputStream is = oidcConfigurationFile.openStream();){
                    String oidcConfigString = this.readFromInputStream(is);
                    for (SimpleAttributeDefinition attribute : SecureDeploymentDefinition.NON_DEFAULT_ATTRIBUTES) {
                        if (deploymentUnit.enables((Feature)attribute) || !oidcConfigString.contains(attribute.getName())) continue;
                        throw ElytronOidcLogger.ROOT_LOGGER.unsupportedAttribute(attribute.getName());
                    }
                    this.addJSONDataAsContextParam(oidcConfigString, webMetaData);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            ListenerMetaData listenerMetaData = new ListenerMetaData();
            listenerMetaData.setListenerClass(OidcConfigurationServletListener.class.getName());
            webMetaData.getListeners().add(listenerMetaData);
            ElytronOidcLogger.ROOT_LOGGER.tracef("Activating OIDC for deployment %s.", deploymentUnit.getName());
            OidcDeploymentMarker.mark(deploymentUnit);
            VirtualHttpServerMechanismFactoryMarkerUtility.virtualMechanismFactoryRequired((DeploymentUnit)deploymentUnit);
        }
    }

    private void addOidcAuthDataAndConfig(DeploymentPhaseContext phaseContext, OidcConfigService service, JBossWebMetaData webMetaData) {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        this.addJSONDataAsContextParam(service.getJSON(deploymentUnit), webMetaData);
        LoginConfigMetaData loginConfig = webMetaData.getLoginConfig();
        if (loginConfig == null) {
            loginConfig = new LoginConfigMetaData();
            webMetaData.setLoginConfig(loginConfig);
        }
        loginConfig.setAuthMethod(OIDC_AUTH_METHOD);
        ElytronOidcLogger.ROOT_LOGGER.deploymentSecured(deploymentUnit.getName());
    }

    private void addJSONDataAsContextParam(String json, JBossWebMetaData webMetaData) {
        ArrayList<ParamValueMetaData> contextParams = webMetaData.getContextParams();
        if (contextParams == null) {
            contextParams = new ArrayList<ParamValueMetaData>();
        }
        ParamValueMetaData param = new ParamValueMetaData();
        param.setParamName("org.wildfly.security.http.oidc.json.config");
        param.setParamValue(json);
        contextParams.add(param);
        webMetaData.setContextParams(contextParams);
    }

    private String readFromInputStream(InputStream inputStream) throws IOException {
        StringBuilder oidcConfigFileStringBuilder = new StringBuilder();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                oidcConfigFileStringBuilder.append(line).append("\n");
            }
        }
        return oidcConfigFileStringBuilder.toString();
    }
}

