/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.loading.impl;

import jakarta.persistence.EntityManager;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.hibernate.FlushMode;
import org.hibernate.SharedSessionContract;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.search.mapper.orm.common.impl.HibernateOrmUtils;
import org.hibernate.search.mapper.orm.loading.impl.HibernateOrmMassEntityLoader;
import org.hibernate.search.mapper.orm.loading.impl.HibernateOrmMassIdentifierLoader;
import org.hibernate.search.mapper.orm.loading.impl.HibernateOrmMassLoadingContext;
import org.hibernate.search.mapper.orm.loading.impl.HibernateOrmQueryLoaderImpl;
import org.hibernate.search.mapper.orm.loading.impl.HibernateOrmSelectionLoadingContext;
import org.hibernate.search.mapper.orm.loading.impl.TypeQueryFactory;
import org.hibernate.search.mapper.orm.loading.spi.ConditionalExpression;
import org.hibernate.search.mapper.orm.loading.spi.HibernateOrmEntityLoadingStrategy;
import org.hibernate.search.mapper.orm.loading.spi.HibernateOrmQueryLoader;
import org.hibernate.search.mapper.pojo.loading.spi.PojoLoadingTypeContext;
import org.hibernate.search.mapper.pojo.loading.spi.PojoMassEntityLoader;
import org.hibernate.search.mapper.pojo.loading.spi.PojoMassEntityLoadingContext;
import org.hibernate.search.mapper.pojo.loading.spi.PojoMassEntitySink;
import org.hibernate.search.mapper.pojo.loading.spi.PojoMassIdentifierLoader;
import org.hibernate.search.mapper.pojo.loading.spi.PojoMassIdentifierLoadingContext;
import org.hibernate.search.mapper.pojo.loading.spi.PojoMassIdentifierSink;
import org.hibernate.search.mapper.pojo.loading.spi.PojoMassLoadingContext;
import org.hibernate.search.mapper.pojo.loading.spi.PojoSelectionEntityLoader;
import org.hibernate.search.mapper.pojo.loading.spi.PojoSelectionLoadingContext;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexingSessionContext;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.SuppressingCloser;

public abstract class AbstractHibernateOrmLoadingStrategy<E, I>
implements HibernateOrmEntityLoadingStrategy<E, I> {
    protected final String rootEntityName;
    private final TypeQueryFactory<E, I> queryFactory;

    AbstractHibernateOrmLoadingStrategy(String rootEntityName, TypeQueryFactory<E, I> queryFactory) {
        this.rootEntityName = rootEntityName;
        this.queryFactory = queryFactory;
    }

    public final PojoSelectionEntityLoader<E> createEntityLoader(Set<? extends PojoLoadingTypeContext<? extends E>> expectedTypes, PojoSelectionLoadingContext context) {
        HibernateOrmSelectionLoadingContext ormContext = (HibernateOrmSelectionLoadingContext)context;
        return this.createEntityLoader(expectedTypes, ormContext);
    }

    public abstract PojoSelectionEntityLoader<E> createEntityLoader(Set<? extends PojoLoadingTypeContext<? extends E>> var1, HibernateOrmSelectionLoadingContext var2);

    public final boolean groupingAllowed(PojoLoadingTypeContext<? extends E> type, PojoMassLoadingContext context) {
        return ((HibernateOrmMassLoadingContext)context).conditionalExpression(type).isEmpty();
    }

    public final PojoMassIdentifierLoader createIdentifierLoader(Set<? extends PojoLoadingTypeContext<? extends E>> expectedTypes, PojoMassIdentifierLoadingContext<I> context) {
        HibernateOrmMassLoadingContext ormContext = (HibernateOrmMassLoadingContext)context.parent();
        SessionFactoryImplementor sessionFactory = ormContext.mapping().sessionFactory();
        HibernateOrmQueryLoader<E, I> queryLoader = this.createQueryLoader(sessionFactory, expectedTypes, this.conditionalExpressions(expectedTypes, ormContext));
        SharedSessionContractImplementor session = (SharedSessionContractImplementor)sessionFactory.withStatelessOptions().tenantIdentifier((Object)context.tenantIdentifier()).openStatelessSession();
        try {
            PojoMassIdentifierSink sink = context.createSink();
            return new HibernateOrmMassIdentifierLoader<E, I>(queryLoader, ormContext, sink, session);
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).push(SharedSessionContract::close, (Object)session);
            throw e;
        }
    }

    public final PojoMassEntityLoader<I> createEntityLoader(Set<? extends PojoLoadingTypeContext<? extends E>> expectedTypes, PojoMassEntityLoadingContext<E> context) {
        HibernateOrmMassLoadingContext ormContext = (HibernateOrmMassLoadingContext)context.parent();
        SessionFactoryImplementor sessionFactory = ormContext.mapping().sessionFactory();
        HibernateOrmQueryLoader<E, I> queryLoader = this.createQueryLoader(sessionFactory, expectedTypes, this.conditionalExpressions(expectedTypes, ormContext));
        SessionImplementor session = (SessionImplementor)sessionFactory.withOptions().tenantIdentifier((Object)context.tenantIdentifier()).openSession();
        try {
            session.setHibernateFlushMode(FlushMode.MANUAL);
            session.setCacheMode(ormContext.cacheMode());
            session.setDefaultReadOnly(true);
            PojoMassEntitySink sink = context.createSink((PojoMassIndexingSessionContext)ormContext.mapping().sessionContext((EntityManager)session));
            return new HibernateOrmMassEntityLoader(queryLoader, ormContext, sink, session);
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).push(EntityManager::close, (Object)session);
            throw e;
        }
    }

    private List<ConditionalExpression> conditionalExpressions(Set<? extends PojoLoadingTypeContext<? extends E>> expectedTypes, HibernateOrmMassLoadingContext context) {
        if (expectedTypes.size() != 1) {
            return List.of();
        }
        Optional<ConditionalExpression> condition = context.conditionalExpression(expectedTypes.iterator().next());
        return condition.isPresent() ? List.of(condition.get()) : List.of();
    }

    @Override
    public HibernateOrmQueryLoader<E, I> createQueryLoader(SessionFactoryImplementor sessionFactory, Set<? extends PojoLoadingTypeContext<? extends E>> typeContexts, List<ConditionalExpression> conditionalExpressions) {
        return this.createQueryLoader(sessionFactory, typeContexts, conditionalExpressions, null);
    }

    @Override
    public HibernateOrmQueryLoader<E, I> createQueryLoader(SessionFactoryImplementor sessionFactory, Set<? extends PojoLoadingTypeContext<? extends E>> typeContexts, List<ConditionalExpression> conditionalExpressions, String order) {
        Set<Class<Class>> includedTypesFilter;
        EntityMappingType rootEntityMappingType = HibernateOrmUtils.entityMappingType(sessionFactory, this.rootEntityName);
        if (HibernateOrmUtils.targetsAllConcreteSubTypes(sessionFactory, rootEntityMappingType, typeContexts)) {
            includedTypesFilter = Collections.emptySet();
        } else {
            includedTypesFilter = new HashSet(typeContexts.size());
            for (PojoLoadingTypeContext<E> pojoLoadingTypeContext : typeContexts) {
                includedTypesFilter.add(pojoLoadingTypeContext.typeIdentifier().javaClass());
            }
        }
        if (!conditionalExpressions.isEmpty() || order != null) {
            if (typeContexts.size() != 1) {
                throw new AssertionFailure("conditional/order expression is always defined on a single type");
            }
            EntityMappingType entityMappingType = HibernateOrmUtils.entityMappingType(sessionFactory, typeContexts.iterator().next().secondaryEntityName());
            return new HibernateOrmQueryLoaderImpl(this.queryFactory, entityMappingType, includedTypesFilter, conditionalExpressions, order);
        }
        return new HibernateOrmQueryLoaderImpl(this.queryFactory, includedTypesFilter);
    }
}

