/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.model.host;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.BootErrorCollector;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.Feature;
import org.jboss.as.controller.ModelOnlyWriteAttributeHandler;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.RunningModeControl;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.DelegatingConfigurableAuthorizer;
import org.jboss.as.controller.access.management.ManagementSecurityIdentitySupplier;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.audit.ManagedAuditLogger;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.extension.ExtensionRegistryType;
import org.jboss.as.controller.extension.ExtensionResourceDefinition;
import org.jboss.as.controller.extension.MutableRootResourceRegistrationProvider;
import org.jboss.as.controller.operations.common.NamespaceAddHandler;
import org.jboss.as.controller.operations.common.NamespaceRemoveHandler;
import org.jboss.as.controller.operations.common.ProcessEnvironment;
import org.jboss.as.controller.operations.common.ProcessStateAttributeHandler;
import org.jboss.as.controller.operations.common.ResolveExpressionHandler;
import org.jboss.as.controller.operations.common.SchemaLocationAddHandler;
import org.jboss.as.controller.operations.common.SchemaLocationRemoveHandler;
import org.jboss.as.controller.operations.common.SnapshotDeleteHandler;
import org.jboss.as.controller.operations.common.SnapshotListHandler;
import org.jboss.as.controller.operations.common.SnapshotTakeHandler;
import org.jboss.as.controller.operations.common.ValidateAddressOperationHandler;
import org.jboss.as.controller.operations.common.ValidateOperationHandler;
import org.jboss.as.controller.operations.common.XmlFileMarshallingHandler;
import org.jboss.as.controller.operations.common.XmlMarshallingHandler;
import org.jboss.as.controller.operations.global.GlobalInstallationReportHandler;
import org.jboss.as.controller.operations.global.ReadAttributeHandler;
import org.jboss.as.controller.operations.global.ReadConfigAsFeaturesOperationHandler;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.controller.services.path.PathResourceDefinition;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.domain.controller.operations.DomainServerLifecycleHandlers;
import org.jboss.as.domain.controller.operations.HostProcessReloadHandler;
import org.jboss.as.domain.management.CoreManagementResourceDefinition;
import org.jboss.as.domain.management.audit.EnvironmentNameReader;
import org.jboss.as.host.controller.DirectoryGrouping;
import org.jboss.as.host.controller.HostControllerConfigurationPersister;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.HostControllerService;
import org.jboss.as.host.controller.HostModelUtil;
import org.jboss.as.host.controller.HostRunningModeControl;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.host.controller.descriptions.HostEnvironmentResourceDefinition;
import org.jboss.as.host.controller.discovery.DiscoveryOptionResourceDefinition;
import org.jboss.as.host.controller.discovery.DiscoveryOptionsResourceDefinition;
import org.jboss.as.host.controller.discovery.StaticDiscoveryResourceDefinition;
import org.jboss.as.host.controller.ignored.IgnoredDomainResourceRegistry;
import org.jboss.as.host.controller.model.jvm.JvmResourceDefinition;
import org.jboss.as.host.controller.operations.DomainControllerWriteAttributeHandler;
import org.jboss.as.host.controller.operations.HostShutdownHandler;
import org.jboss.as.host.controller.operations.HostSpecifiedInterfaceAddHandler;
import org.jboss.as.host.controller.operations.HostSpecifiedInterfaceRemoveHandler;
import org.jboss.as.host.controller.operations.HostXmlFileMarshallingHandler;
import org.jboss.as.host.controller.operations.HostXmlMarshallingHandler;
import org.jboss.as.host.controller.operations.InstallationReportHandler;
import org.jboss.as.host.controller.operations.IsMasterHandler;
import org.jboss.as.host.controller.operations.LocalHostControllerInfoImpl;
import org.jboss.as.host.controller.operations.ResolveExpressionOnHostHandler;
import org.jboss.as.host.controller.operations.StartServersHandler;
import org.jboss.as.host.controller.resources.HttpManagementResourceDefinition;
import org.jboss.as.host.controller.resources.NativeManagementResourceDefinition;
import org.jboss.as.host.controller.resources.ServerConfigResourceDefinition;
import org.jboss.as.host.controller.resources.StoppedServerResource;
import org.jboss.as.platform.mbean.PlatformMBeanResourceRegistrar;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.HostFileRepository;
import org.jboss.as.server.controller.resources.CapabilityRegistryResourceDefinition;
import org.jboss.as.server.controller.resources.ModuleLoadingResourceDefinition;
import org.jboss.as.server.controller.resources.ServerRootResourceDefinition;
import org.jboss.as.server.controller.resources.ServiceContainerResourceDefinition;
import org.jboss.as.server.controller.resources.SystemPropertyResourceDefinition;
import org.jboss.as.server.operations.CleanObsoleteContentHandler;
import org.jboss.as.server.operations.InstanceUuidReadHandler;
import org.jboss.as.server.operations.RunningModeReadHandler;
import org.jboss.as.server.operations.SuspendStateReadHandler;
import org.jboss.as.server.operations.WriteConfigHandler;
import org.jboss.as.server.services.net.InterfaceAddHandler;
import org.jboss.as.server.services.net.InterfaceResourceDefinition;
import org.jboss.as.server.services.net.SocketBindingGroupResourceDefinition;
import org.jboss.as.server.services.net.SpecifiedInterfaceResolveHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class HostResourceDefinition
extends SimpleResourceDefinition {
    private static final RuntimeCapability<Void> HOST_RUNTIME_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.host.controller", (boolean)false).build();
    public static final SimpleAttributeDefinition NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("name", ModelType.STRING).setRequired(false)).setMinSize(1)).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.DOMAIN_NAMES)).build();
    static final SimpleAttributeDefinition PRODUCT_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("product-name", ModelType.STRING).setRequired(false)).setMinSize(1)).build();
    static final SimpleAttributeDefinition RELEASE_VERSION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("release-version", ModelType.STRING).setRequired(false)).setMinSize(1)).build();
    static final SimpleAttributeDefinition RELEASE_CODENAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("release-codename", ModelType.STRING).setRequired(false)).setMinSize(1)).build();
    static final SimpleAttributeDefinition PRODUCT_VERSION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("product-version", ModelType.STRING).setRequired(false)).setMinSize(1)).build();
    static final SimpleAttributeDefinition MANAGEMENT_MAJOR_VERSION = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("management-major-version", ModelType.INT).setMinSize(1)).build();
    static final SimpleAttributeDefinition MANAGEMENT_MINOR_VERSION = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("management-minor-version", ModelType.INT).setMinSize(1)).build();
    static final SimpleAttributeDefinition MANAGEMENT_MICRO_VERSION = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("management-micro-version", ModelType.INT).setMinSize(1)).build();
    static final SimpleAttributeDefinition SERVER_STATE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("server-state", ModelType.STRING).setRequired(false)).setMinSize(1)).setStorageRuntime()).setRuntimeServiceNotRequired()).build();
    public static final SimpleAttributeDefinition UUID = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"uuid", (ModelType)ModelType.STRING, (boolean)false).setValidator((ParameterValidator)new StringLengthValidator(1, true))).setStorageRuntime()).setRuntimeServiceNotRequired()).build();
    public static final SimpleAttributeDefinition ORGANIZATION_IDENTIFIER = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"organization", (ModelType)ModelType.STRING, (boolean)true).setValidator((ParameterValidator)new StringLengthValidator(1, true))).build();
    public static final SimpleAttributeDefinition DOMAIN_ORGANIZATION_IDENTIFIER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"domain-organization", (ModelType)ModelType.STRING, (boolean)true).setValidator((ParameterValidator)new StringLengthValidator(1, true))).setStorageRuntime()).setRuntimeServiceNotRequired()).build();
    public static final SimpleAttributeDefinition RUNTIME_CONFIGURATION_STATE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("runtime-configuration-state", ModelType.STRING).setMinSize(1)).setStorageRuntime()).setRuntimeServiceNotRequired()).build();
    public static final SimpleAttributeDefinition HOST_STATE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("host-state", ModelType.STRING).setMinSize(1)).setStorageRuntime()).setRuntimeServiceNotRequired()).build();
    public static final SimpleAttributeDefinition DIRECTORY_GROUPING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"directory-grouping", (ModelType)ModelType.STRING, (boolean)true).addFlag(AttributeAccess.Flag.RESTART_ALL_SERVICES)).setDefaultValue(DirectoryGrouping.defaultValue().toModelNode())).setValidator((ParameterValidator)EnumValidator.create(DirectoryGrouping.class))).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition MASTER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"primary", (ModelType)ModelType.BOOLEAN, (boolean)true).setDefaultValue(ModelNode.FALSE)).setStorageRuntime()).setRuntimeServiceNotRequired()).setResourceOnly()).build();
    public static final ObjectTypeAttributeDefinition DC_LOCAL = new ObjectTypeAttributeDefinition.Builder("local", new AttributeDefinition[0]).build();
    public static final ObjectTypeAttributeDefinition DC_REMOTE = new ObjectTypeAttributeDefinition.Builder("remote", new AttributeDefinition[]{DomainControllerWriteAttributeHandler.PROTOCOL, DomainControllerWriteAttributeHandler.HOST, DomainControllerWriteAttributeHandler.PORT, DomainControllerWriteAttributeHandler.AUTHENTICATION_CONTEXT, DomainControllerWriteAttributeHandler.USERNAME, DomainControllerWriteAttributeHandler.IGNORE_UNUSED_CONFIG, DomainControllerWriteAttributeHandler.ADMIN_ONLY_POLICY}).build();
    public static final ObjectTypeAttributeDefinition DOMAIN_CONTROLLER = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("domain-controller", new AttributeDefinition[]{DC_LOCAL, DC_REMOTE}).setRequired(true)).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.DOMAIN_CONTROLLER)).build();
    private final HostControllerConfigurationPersister configurationPersister;
    private final HostControllerEnvironment environment;
    private final HostRunningModeControl runningModeControl;
    private final HostFileRepository localFileRepository;
    private final LocalHostControllerInfoImpl hostControllerInfo;
    private final ServerInventory serverInventory;
    private final HostFileRepository remoteFileRepository;
    private final ContentRepository contentRepository;
    private final DomainController domainController;
    private final ExtensionRegistry hostExtensionRegistry;
    private final IgnoredDomainResourceRegistry ignoredRegistry;
    private final ControlledProcessState processState;
    private final PathManagerService pathManager;
    private final DelegatingConfigurableAuthorizer authorizer;
    private final ManagementSecurityIdentitySupplier securityIdentitySupplier;
    private final ManagedAuditLogger auditLogger;
    private final BootErrorCollector bootErrorCollector;

    public HostResourceDefinition(String hostName, HostControllerConfigurationPersister configurationPersister, HostControllerEnvironment environment, HostRunningModeControl runningModeControl, HostFileRepository localFileRepository, LocalHostControllerInfoImpl hostControllerInfo, ServerInventory serverInventory, HostFileRepository remoteFileRepository, ContentRepository contentRepository, DomainController domainController, ExtensionRegistry hostExtensionRegistry, IgnoredDomainResourceRegistry ignoredRegistry, ControlledProcessState processState, PathManagerService pathManager, DelegatingConfigurableAuthorizer authorizer, ManagementSecurityIdentitySupplier securityIdentitySupplier, ManagedAuditLogger auditLogger, BootErrorCollector bootErrorCollector) {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"host", (String)hostName), (ResourceDescriptionResolver)HostModelUtil.getResourceDescriptionResolver(new String[0])).setCapabilities(new RuntimeCapability[]{HOST_RUNTIME_CAPABILITY, PathResourceDefinition.PATH_CAPABILITY.fromBaseCapability("jboss.home.dir"), PathResourceDefinition.PATH_CAPABILITY.fromBaseCapability("jboss.domain.config.dir"), PathResourceDefinition.PATH_CAPABILITY.fromBaseCapability("jboss.domain.data.dir"), PathResourceDefinition.PATH_CAPABILITY.fromBaseCapability("jboss.domain.log.dir"), PathResourceDefinition.PATH_CAPABILITY.fromBaseCapability("jboss.domain.temp.dir"), PathResourceDefinition.PATH_CAPABILITY.fromBaseCapability("jboss.controller.temp.dir"), PathResourceDefinition.PATH_CAPABILITY.fromBaseCapability("jboss.server.base.dir"), PathResourceDefinition.PATH_CAPABILITY.fromBaseCapability("jboss.server.config.dir"), PathResourceDefinition.PATH_CAPABILITY.fromBaseCapability("jboss.server.data.dir"), PathResourceDefinition.PATH_CAPABILITY.fromBaseCapability("jboss.server.log.dir"), PathResourceDefinition.PATH_CAPABILITY.fromBaseCapability("jboss.server.temp.dir")}));
        this.configurationPersister = configurationPersister;
        this.environment = environment;
        this.runningModeControl = runningModeControl;
        this.localFileRepository = localFileRepository;
        this.hostControllerInfo = hostControllerInfo;
        this.serverInventory = serverInventory;
        this.remoteFileRepository = remoteFileRepository;
        this.contentRepository = contentRepository;
        this.domainController = domainController;
        this.hostExtensionRegistry = hostExtensionRegistry;
        this.ignoredRegistry = ignoredRegistry;
        this.processState = processState;
        this.pathManager = pathManager;
        this.authorizer = authorizer;
        this.securityIdentitySupplier = securityIdentitySupplier;
        this.auditLogger = auditLogger;
        this.bootErrorCollector = bootErrorCollector;
    }

    public void registerAttributes(ManagementResourceRegistration hostRegistration) {
        super.registerAttributes(hostRegistration);
        hostRegistration.registerReadWriteAttribute((AttributeDefinition)DIRECTORY_GROUPING, null, (OperationStepHandler)new ReloadRequiredWriteAttributeHandler(new AttributeDefinition[]{DIRECTORY_GROUPING}){

            protected boolean requiresRuntime(OperationContext context) {
                return context.getRunningMode() == RunningMode.NORMAL && !context.isBooting();
            }
        });
        hostRegistration.registerReadWriteAttribute((AttributeDefinition)ORGANIZATION_IDENTIFIER, null, (OperationStepHandler)new ModelOnlyWriteAttributeHandler(new AttributeDefinition[]{ORGANIZATION_IDENTIFIER}));
        hostRegistration.registerReadOnlyAttribute((AttributeDefinition)DOMAIN_ORGANIZATION_IDENTIFIER, (OperationStepHandler)new ReadAttributeHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ModelNode rootModel = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, false).getModel();
                context.getResult().set(rootModel.get("domain-organization"));
            }
        });
        hostRegistration.registerReadOnlyAttribute((AttributeDefinition)PRODUCT_NAME, null);
        hostRegistration.registerReadOnlyAttribute((AttributeDefinition)UUID, (OperationStepHandler)new InstanceUuidReadHandler((ProcessEnvironment)this.environment));
        hostRegistration.registerReadOnlyAttribute((AttributeDefinition)SERVER_STATE, null);
        hostRegistration.registerReadOnlyAttribute((AttributeDefinition)RELEASE_VERSION, null);
        hostRegistration.registerReadOnlyAttribute((AttributeDefinition)RELEASE_CODENAME, null);
        hostRegistration.registerReadOnlyAttribute((AttributeDefinition)PRODUCT_VERSION, null);
        hostRegistration.registerReadOnlyAttribute((AttributeDefinition)MANAGEMENT_MAJOR_VERSION, null);
        hostRegistration.registerReadOnlyAttribute((AttributeDefinition)MANAGEMENT_MINOR_VERSION, null);
        hostRegistration.registerReadOnlyAttribute((AttributeDefinition)MANAGEMENT_MICRO_VERSION, null);
        hostRegistration.registerReadOnlyAttribute((AttributeDefinition)MASTER, (OperationStepHandler)IsMasterHandler.INSTANCE);
        hostRegistration.registerReadOnlyAttribute(ServerRootResourceDefinition.NAMESPACES, null);
        hostRegistration.registerReadOnlyAttribute(ServerRootResourceDefinition.SCHEMA_LOCATIONS, null);
        hostRegistration.registerReadWriteAttribute((AttributeDefinition)NAME, this.environment.getProcessNameReadHandler(), this.environment.getHostNameWriteHandler(this.hostControllerInfo));
        hostRegistration.registerReadOnlyAttribute((AttributeDefinition)RUNTIME_CONFIGURATION_STATE, (OperationStepHandler)new ProcessStateAttributeHandler(this.processState));
        hostRegistration.registerReadOnlyAttribute((AttributeDefinition)HOST_STATE, (OperationStepHandler)new ProcessStateAttributeHandler(this.processState));
        hostRegistration.registerReadOnlyAttribute(ServerRootResourceDefinition.RUNNING_MODE, (OperationStepHandler)new RunningModeReadHandler((RunningModeControl)this.runningModeControl));
        hostRegistration.registerReadOnlyAttribute(ServerRootResourceDefinition.SUSPEND_STATE, (OperationStepHandler)SuspendStateReadHandler.INSTANCE);
    }

    public void registerOperations(ManagementResourceRegistration hostRegistration) {
        super.registerOperations(hostRegistration);
        hostRegistration.registerOperationHandler(NamespaceAddHandler.DEFINITION, (OperationStepHandler)NamespaceAddHandler.INSTANCE);
        hostRegistration.registerOperationHandler(NamespaceRemoveHandler.DEFINITION, (OperationStepHandler)NamespaceRemoveHandler.INSTANCE);
        hostRegistration.registerOperationHandler(SchemaLocationAddHandler.DEFINITION, (OperationStepHandler)SchemaLocationAddHandler.INSTANCE);
        hostRegistration.registerOperationHandler(SchemaLocationRemoveHandler.DEFINITION, (OperationStepHandler)SchemaLocationRemoveHandler.INSTANCE);
        hostRegistration.registerOperationHandler((OperationDefinition)GlobalInstallationReportHandler.DEFINITION, (OperationStepHandler)GlobalInstallationReportHandler.INSTANCE, false);
        hostRegistration.registerOperationHandler((OperationDefinition)InstallationReportHandler.DEFINITION, (OperationStepHandler)InstallationReportHandler.createOperation(this.environment), false);
        hostRegistration.registerOperationHandler((OperationDefinition)ReadConfigAsFeaturesOperationHandler.DEFINITION, (OperationStepHandler)new ReadConfigAsFeaturesOperationHandler(), true);
        hostRegistration.registerOperationHandler(ValidateAddressOperationHandler.DEFINITION, (OperationStepHandler)ValidateAddressOperationHandler.INSTANCE);
        hostRegistration.registerOperationHandler(ResolveExpressionHandler.DEFINITION, (OperationStepHandler)ResolveExpressionHandler.INSTANCE);
        hostRegistration.registerOperationHandler(ResolveExpressionOnHostHandler.DEFINITION, (OperationStepHandler)ResolveExpressionOnHostHandler.INSTANCE);
        hostRegistration.registerOperationHandler((OperationDefinition)SpecifiedInterfaceResolveHandler.DEFINITION, (OperationStepHandler)SpecifiedInterfaceResolveHandler.INSTANCE);
        hostRegistration.registerOperationHandler((OperationDefinition)CleanObsoleteContentHandler.DEFINITION, (OperationStepHandler)CleanObsoleteContentHandler.createOperation((ContentRepository)this.contentRepository));
        hostRegistration.registerOperationHandler((OperationDefinition)WriteConfigHandler.DEFINITION, (OperationStepHandler)WriteConfigHandler.INSTANCE);
        SimpleOperationDefinitionBuilder xmlMarshallingHandlerBuilder = XmlMarshallingHandler.createOperationDefinitionBuilder();
        if (hostRegistration.enables((Feature)HostXmlFileMarshallingHandler.DEFINITION)) {
            xmlMarshallingHandlerBuilder.setDeprecated(ModelVersion.create((int)24, (int)0, (int)0));
        }
        hostRegistration.registerOperationHandler((OperationDefinition)xmlMarshallingHandlerBuilder.build(), (OperationStepHandler)new HostXmlMarshallingHandler((ConfigurationPersister)this.configurationPersister.getHostPersister(), this.hostControllerInfo));
        hostRegistration.registerOperationHandler((OperationDefinition)XmlFileMarshallingHandler.DEFINITION, (OperationStepHandler)new HostXmlFileMarshallingHandler((ConfigurationPersister)this.configurationPersister.getHostPersister(), this.hostControllerInfo));
        StartServersHandler ssh = new StartServersHandler(this.environment, this.serverInventory, this.runningModeControl);
        hostRegistration.registerOperationHandler(StartServersHandler.DEFINITION, (OperationStepHandler)ssh);
        if (this.environment.getProcessType() != ProcessType.EMBEDDED_HOST_CONTROLLER) {
            HostShutdownHandler hsh = new HostShutdownHandler(this.domainController, this.serverInventory, this.environment);
            hostRegistration.registerOperationHandler(HostShutdownHandler.DEFINITION, (OperationStepHandler)hsh);
        }
        HostProcessReloadHandler reloadHandler = new HostProcessReloadHandler(HostControllerService.HC_SERVICE_NAME, this.runningModeControl, this.processState, this.environment, this.hostControllerInfo);
        hostRegistration.registerOperationHandler(HostProcessReloadHandler.getDefinition(this.hostControllerInfo), (OperationStepHandler)reloadHandler);
        DomainServerLifecycleHandlers.initializeServerInventory(this.serverInventory);
        DomainServerLifecycleHandlers.registerHostHandlers(hostRegistration);
        ValidateOperationHandler validateOperationHandler = this.hostControllerInfo.isMasterDomainController() ? ValidateOperationHandler.INSTANCE : ValidateOperationHandler.SLAVE_HC_INSTANCE;
        hostRegistration.registerOperationHandler(ValidateOperationHandler.DEFINITION_HIDDEN, (OperationStepHandler)validateOperationHandler);
        SnapshotDeleteHandler snapshotDelete = new SnapshotDeleteHandler((ConfigurationPersister)this.configurationPersister.getHostPersister());
        hostRegistration.registerOperationHandler(SnapshotDeleteHandler.DEFINITION, (OperationStepHandler)snapshotDelete);
        SnapshotListHandler snapshotList = new SnapshotListHandler((ConfigurationPersister)this.configurationPersister.getHostPersister());
        hostRegistration.registerOperationHandler(SnapshotListHandler.DEFINITION, (OperationStepHandler)snapshotList);
        SnapshotTakeHandler snapshotTake = new SnapshotTakeHandler((ConfigurationPersister)this.configurationPersister.getHostPersister());
        hostRegistration.registerOperationHandler(SnapshotTakeHandler.DEFINITION, (OperationStepHandler)snapshotTake);
        this.ignoredRegistry.registerResources(hostRegistration);
    }

    public void registerChildren(final ManagementResourceRegistration hostRegistration) {
        super.registerChildren(hostRegistration);
        hostRegistration.registerSubModel((ResourceDefinition)new ExtensionResourceDefinition(this.hostExtensionRegistry, true, ExtensionRegistryType.HOST, new MutableRootResourceRegistrationProvider(){

            public ManagementResourceRegistration getRootResourceRegistrationForUpdate(OperationContext context) {
                return hostRegistration;
            }
        }));
        hostRegistration.registerSubModel((ResourceDefinition)SystemPropertyResourceDefinition.createForDomainOrHost((SystemPropertyResourceDefinition.Location)SystemPropertyResourceDefinition.Location.HOST));
        NativeManagementResourceDefinition nativeManagement = new NativeManagementResourceDefinition(this.hostControllerInfo);
        HttpManagementResourceDefinition httpManagement = HttpManagementResourceDefinition.create(this.hostControllerInfo, this.environment);
        EnvironmentNameReader environmentNameReader = new EnvironmentNameReader(){

            public boolean isServer() {
                return false;
            }

            public String getServerName() {
                return null;
            }

            public String getHostName() {
                return HostResourceDefinition.this.environment.getHostControllerName();
            }

            public String getProductName() {
                if (HostResourceDefinition.this.environment.getProductConfig() != null && HostResourceDefinition.this.environment.getProductConfig().getProductName() != null) {
                    return HostResourceDefinition.this.environment.getProductConfig().getProductName();
                }
                return null;
            }
        };
        hostRegistration.registerSubModel((ResourceDefinition)CoreManagementResourceDefinition.forHost((DelegatingConfigurableAuthorizer)this.authorizer, (ManagementSecurityIdentitySupplier)this.securityIdentitySupplier, (ManagedAuditLogger)this.auditLogger, (PathManagerService)this.pathManager, (EnvironmentNameReader)environmentNameReader, (BootErrorCollector)this.bootErrorCollector, (ResourceDefinition[])new ResourceDefinition[]{nativeManagement, httpManagement}));
        hostRegistration.registerSubModel((ResourceDefinition)new ServiceContainerResourceDefinition());
        hostRegistration.registerSubModel((ResourceDefinition)HostEnvironmentResourceDefinition.of(this.environment));
        hostRegistration.registerSubModel((ResourceDefinition)ModuleLoadingResourceDefinition.INSTANCE);
        PlatformMBeanResourceRegistrar.registerPlatformMBeanResources((ManagementResourceRegistration)hostRegistration);
        hostRegistration.registerSubModel((ResourceDefinition)new CapabilityRegistryResourceDefinition(this.domainController.getCapabilityRegistry()));
        ManagementResourceRegistration discoveryOptions = hostRegistration.registerSubModel((ResourceDefinition)DiscoveryOptionsResourceDefinition.INSTANCE);
        discoveryOptions.registerSubModel((ResourceDefinition)new StaticDiscoveryResourceDefinition(this.hostControllerInfo));
        discoveryOptions.registerSubModel((ResourceDefinition)new DiscoveryOptionResourceDefinition(this.hostControllerInfo));
        hostRegistration.registerSubModel((ResourceDefinition)JvmResourceDefinition.GLOBAL);
        hostRegistration.registerSubModel((ResourceDefinition)PathResourceDefinition.createResolvableSpecified((PathManagerService)this.pathManager));
        ManagementResourceRegistration interfaces = hostRegistration.registerSubModel((ResourceDefinition)new InterfaceResourceDefinition((InterfaceAddHandler)new HostSpecifiedInterfaceAddHandler(), (OperationStepHandler)new HostSpecifiedInterfaceRemoveHandler(), true, true));
        interfaces.registerOperationHandler((OperationDefinition)SpecifiedInterfaceResolveHandler.DEFINITION, (OperationStepHandler)SpecifiedInterfaceResolveHandler.INSTANCE);
        hostRegistration.registerSubModel((ResourceDefinition)new ServerConfigResourceDefinition(this.hostControllerInfo, this.serverInventory, this.pathManager, this.processState, this.environment.getDomainDataDir()));
        hostRegistration.registerSubModel((ResourceDefinition)new StoppedServerResource(this.serverInventory));
        hostRegistration.registerSubModel((ResourceDefinition)SocketBindingGroupResourceDefinition.INSTANCE);
    }
}

