/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.security.Principal;
import java.util.regex.Pattern;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.StartException;
import org.wildfly.extension.elytron.AggregateComponentDefinition;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.RegexAttributeDefinitions;
import org.wildfly.extension.elytron.TrivialAddHandler;
import org.wildfly.extension.elytron.TrivialResourceDefinition;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.extension.elytron.capabilities.PrincipalTransformer;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.util.CaseNameRewriter;
import org.wildfly.security.auth.util.RegexNameRewriter;
import org.wildfly.security.auth.util.RegexNameValidatingRewriter;

class PrincipalTransformerDefinitions {
    static final SimpleAttributeDefinition CONSTANT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("constant", ModelType.STRING, false).setAllowExpression(true)).setMinSize(1)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition REPLACEMENT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("replacement", ModelType.STRING, false).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(0))).setRestartAllServices()).build();
    static final SimpleAttributeDefinition REPLACE_ALL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("replace-all", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(ModelNode.FALSE)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition MATCH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("match", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(ModelNode.TRUE)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition UPPER_CASE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("upper-case", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(ModelNode.TRUE)).build();
    static final AggregateComponentDefinition<PrincipalTransformer> AGGREGATE_PRINCIPAL_TRANSFORMER = AggregateComponentDefinition.create(PrincipalTransformer.class, "aggregate-principal-transformer", "principal-transformers", Capabilities.PRINCIPAL_TRANSFORMER_RUNTIME_CAPABILITY, pt -> PrincipalTransformer.aggregate(pt));
    static final AggregateComponentDefinition<PrincipalTransformer> CHAINED_PRINCIPAL_TRANSFORMER = AggregateComponentDefinition.create(PrincipalTransformer.class, "chained-principal-transformer", "principal-transformers", Capabilities.PRINCIPAL_TRANSFORMER_RUNTIME_CAPABILITY, pt -> PrincipalTransformer.chain(pt));

    PrincipalTransformerDefinitions() {
    }

    static AggregateComponentDefinition<PrincipalTransformer> getAggregatePrincipalTransformerDefinition() {
        return AGGREGATE_PRINCIPAL_TRANSFORMER;
    }

    static AggregateComponentDefinition<PrincipalTransformer> getChainedPrincipalTransformerDefinition() {
        return CHAINED_PRINCIPAL_TRANSFORMER;
    }

    static ResourceDefinition getConstantPrincipalTransformerDefinition() {
        AttributeDefinition[] attributes = new AttributeDefinition[]{CONSTANT};
        TrivialAddHandler<PrincipalTransformer> add = new TrivialAddHandler<PrincipalTransformer>(PrincipalTransformer.class, attributes, Capabilities.PRINCIPAL_TRANSFORMER_RUNTIME_CAPABILITY){

            @Override
            protected TrivialService.ValueSupplier<PrincipalTransformer> getValueSupplier(ServiceBuilder<PrincipalTransformer> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                NamePrincipal principal = new NamePrincipal(CONSTANT.resolveModelAttribute(context, model).asString());
                return () -> 1.lambda$getValueSupplier$1((Principal)principal);
            }

            private static /* synthetic */ PrincipalTransformer lambda$getValueSupplier$1(Principal principal) throws StartException {
                return p -> principal;
            }
        };
        return new TrivialResourceDefinition("constant-principal-transformer", add, attributes, Capabilities.PRINCIPAL_TRANSFORMER_RUNTIME_CAPABILITY);
    }

    static ResourceDefinition getRegexPrincipalTransformerDefinition() {
        AttributeDefinition[] attributes = new AttributeDefinition[]{RegexAttributeDefinitions.PATTERN, REPLACEMENT, REPLACE_ALL};
        TrivialAddHandler<PrincipalTransformer> add = new TrivialAddHandler<PrincipalTransformer>(PrincipalTransformer.class, attributes, Capabilities.PRINCIPAL_TRANSFORMER_RUNTIME_CAPABILITY){

            @Override
            protected TrivialService.ValueSupplier<PrincipalTransformer> getValueSupplier(ServiceBuilder<PrincipalTransformer> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                Pattern pattern = Pattern.compile(RegexAttributeDefinitions.PATTERN.resolveModelAttribute(context, model).asString());
                String replacement = REPLACEMENT.resolveModelAttribute(context, model).asString();
                boolean replaceAll = REPLACE_ALL.resolveModelAttribute(context, model).asBoolean();
                return () -> PrincipalTransformer.from(new RegexNameRewriter(pattern, replacement, replaceAll).asPrincipalRewriter());
            }
        };
        return new TrivialResourceDefinition("regex-principal-transformer", add, attributes, Capabilities.PRINCIPAL_TRANSFORMER_RUNTIME_CAPABILITY);
    }

    static ResourceDefinition getRegexValidatingPrincipalTransformerDefinition() {
        AttributeDefinition[] attributes = new AttributeDefinition[]{RegexAttributeDefinitions.PATTERN, MATCH};
        TrivialAddHandler<PrincipalTransformer> add = new TrivialAddHandler<PrincipalTransformer>(PrincipalTransformer.class, attributes, Capabilities.PRINCIPAL_TRANSFORMER_RUNTIME_CAPABILITY){

            @Override
            protected TrivialService.ValueSupplier<PrincipalTransformer> getValueSupplier(ServiceBuilder<PrincipalTransformer> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                Pattern pattern = Pattern.compile(RegexAttributeDefinitions.PATTERN.resolveModelAttribute(context, model).asString());
                boolean match = MATCH.resolveModelAttribute(context, model).asBoolean();
                return () -> PrincipalTransformer.from(new RegexNameValidatingRewriter(pattern, match).asPrincipalRewriter());
            }
        };
        return new TrivialResourceDefinition("regex-validating-principal-transformer", add, attributes, Capabilities.PRINCIPAL_TRANSFORMER_RUNTIME_CAPABILITY);
    }

    static ResourceDefinition getCasePrincipalTransformerDefinition() {
        AttributeDefinition[] attributes = new AttributeDefinition[]{UPPER_CASE};
        TrivialAddHandler<PrincipalTransformer> add = new TrivialAddHandler<PrincipalTransformer>(PrincipalTransformer.class, attributes, Capabilities.PRINCIPAL_TRANSFORMER_RUNTIME_CAPABILITY){

            @Override
            protected TrivialService.ValueSupplier<PrincipalTransformer> getValueSupplier(ServiceBuilder<PrincipalTransformer> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                boolean upperCase = UPPER_CASE.resolveModelAttribute(context, model).asBoolean();
                return () -> PrincipalTransformer.from(new CaseNameRewriter(upperCase).asPrincipalRewriter());
            }
        };
        return new TrivialResourceDefinition("case-principal-transformer", add, attributes, Capabilities.PRINCIPAL_TRANSFORMER_RUNTIME_CAPABILITY);
    }
}

