/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.sasl.scram;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import org.apache.activemq.artemis.protocol.amqp.sasl.scram.ScramServerFunctionality;
import org.apache.activemq.artemis.spi.core.security.scram.ScramException;
import org.apache.activemq.artemis.spi.core.security.scram.ScramUtils;
import org.apache.activemq.artemis.spi.core.security.scram.UserData;

public class ScramServerFunctionalityImpl
implements ScramServerFunctionality {
    private static final Pattern CLIENT_FIRST_MESSAGE = Pattern.compile("^(([pny])=?([^,]*),([^,]*),)(m?=?[^,]*,?n=([^,]*),r=([^,]*),?.*)$");
    private static final Pattern CLIENT_FINAL_MESSAGE = Pattern.compile("(c=([^,]*),r=([^,]*)),p=(.*)$");
    private final String mServerPartNonce;
    private boolean mIsSuccessful = false;
    private ScramServerFunctionality.State mState = ScramServerFunctionality.State.INITIAL;
    private String mClientFirstMessageBare;
    private String mNonce;
    private String mServerFirstMessage;
    private UserData mUserData;
    private final MessageDigest digest;
    private final Mac hmac;

    public ScramServerFunctionalityImpl(String digestName, String hmacName) throws NoSuchAlgorithmException {
        this(digestName, hmacName, UUID.randomUUID().toString());
    }

    public ScramServerFunctionalityImpl(String digestName, String hmacName, String serverPartNonce) throws NoSuchAlgorithmException {
        if (ScramUtils.isNullOrEmpty((String)digestName)) {
            throw new NullPointerException("digestName cannot be null or empty");
        }
        if (ScramUtils.isNullOrEmpty((String)hmacName)) {
            throw new NullPointerException("hmacName cannot be null or empty");
        }
        if (ScramUtils.isNullOrEmpty((String)serverPartNonce)) {
            throw new NullPointerException("serverPartNonce cannot be null or empty");
        }
        this.digest = MessageDigest.getInstance(digestName);
        this.hmac = Mac.getInstance(hmacName);
        this.mServerPartNonce = serverPartNonce;
    }

    @Override
    public String handleClientFirstMessage(String message) throws ScramException {
        Matcher m = CLIENT_FIRST_MESSAGE.matcher(message);
        if (!m.matches()) {
            this.mState = ScramServerFunctionality.State.ENDED;
            throw new ScramException("Invalid message received");
        }
        this.mClientFirstMessageBare = m.group(5);
        String username = m.group(6);
        String clientNonce = m.group(7);
        this.mNonce = clientNonce + this.mServerPartNonce;
        this.mState = ScramServerFunctionality.State.FIRST_CLIENT_MESSAGE_HANDLED;
        return username;
    }

    @Override
    public String prepareFirstMessage(UserData userData) {
        this.mUserData = userData;
        this.mState = ScramServerFunctionality.State.PREPARED_FIRST;
        this.mServerFirstMessage = String.format("r=%s,s=%s,i=%d", this.mNonce, userData.salt, userData.iterations);
        return this.mServerFirstMessage;
    }

    @Override
    public String prepareFinalMessage(String clientFinalMessage) throws ScramException {
        String finalMessage = this.prepareFinalMessageUnchecked(clientFinalMessage);
        if (!this.mIsSuccessful) {
            throw new ScramException("client credentials missmatch");
        }
        return finalMessage;
    }

    public String prepareFinalMessageUnchecked(String clientFinalMessage) throws ScramException {
        this.mState = ScramServerFunctionality.State.ENDED;
        Matcher m = CLIENT_FINAL_MESSAGE.matcher(clientFinalMessage);
        if (!m.matches()) {
            throw new ScramException("Invalid message received");
        }
        String clientFinalMessageWithoutProof = m.group(1);
        String clientNonce = m.group(3);
        String proof = m.group(4);
        if (!this.mNonce.equals(clientNonce)) {
            throw new ScramException("Nonce mismatch");
        }
        String authMessage = this.mClientFirstMessageBare + "," + this.mServerFirstMessage + "," + clientFinalMessageWithoutProof;
        byte[] storedKeyArr = Base64.getDecoder().decode(this.mUserData.storedKey);
        byte[] clientSignature = ScramUtils.computeHmac((byte[])storedKeyArr, (Mac)this.hmac, (String)authMessage);
        byte[] serverSignature = ScramUtils.computeHmac((byte[])Base64.getDecoder().decode(this.mUserData.serverKey), (Mac)this.hmac, (String)authMessage);
        byte[] clientKey = (byte[])clientSignature.clone();
        byte[] decodedProof = Base64.getDecoder().decode(proof);
        for (int i = 0; i < clientKey.length; ++i) {
            int n = i;
            clientKey[n] = (byte)(clientKey[n] ^ decodedProof[i]);
        }
        byte[] resultKey = this.digest.digest(clientKey);
        this.mIsSuccessful = Arrays.equals(storedKeyArr, resultKey);
        return "v=" + Base64.getEncoder().encodeToString(serverSignature);
    }

    @Override
    public boolean isSuccessful() {
        if (this.mState == ScramServerFunctionality.State.ENDED) {
            return this.mIsSuccessful;
        }
        throw new IllegalStateException("You cannot call this method before authentication is ended. Use isEnded() to check that");
    }

    @Override
    public boolean isEnded() {
        return this.mState == ScramServerFunctionality.State.ENDED;
    }

    @Override
    public ScramServerFunctionality.State getState() {
        return this.mState;
    }

    @Override
    public MessageDigest getDigest() {
        try {
            return (MessageDigest)this.digest.clone();
        }
        catch (CloneNotSupportedException cns) {
            try {
                return MessageDigest.getInstance(this.digest.getAlgorithm());
            }
            catch (NoSuchAlgorithmException nsa) {
                throw new AssertionError((Object)nsa);
            }
        }
    }

    @Override
    public Mac getHmac() {
        try {
            return (Mac)this.hmac.clone();
        }
        catch (CloneNotSupportedException cns) {
            try {
                return Mac.getInstance(this.hmac.getAlgorithm());
            }
            catch (NoSuchAlgorithmException nsa) {
                throw new AssertionError((Object)nsa);
            }
        }
    }
}

