/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import jakarta.servlet.ServletContext;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.clustering.web.container.SessionManagerFactoryConfiguration;
import org.wildfly.clustering.web.session.DistributableSessionManagementConfiguration;
import org.wildfly.clustering.web.session.SessionManagerFactory;
import org.wildfly.clustering.web.undertow.session.DistributableSessionManagerFactory;

public class DistributableSessionManagerFactoryServiceConfigurator<C extends DistributableSessionManagementConfiguration<DeploymentUnit>>
extends SimpleServiceNameProvider
implements CapabilityServiceConfigurator,
Function<SessionManagerFactory<ServletContext, Map<String, Object>, Batch>, io.undertow.servlet.api.SessionManagerFactory> {
    private final SessionManagerFactoryConfiguration configuration;
    private final SupplierDependency<SessionManagerFactory<ServletContext, Map<String, Object>, Batch>> dependency;

    public DistributableSessionManagerFactoryServiceConfigurator(ServiceName name, SessionManagerFactoryConfiguration configuration, SupplierDependency<SessionManagerFactory<ServletContext, Map<String, Object>, Batch>> dependency) {
        super(name);
        this.configuration = configuration;
        this.dependency = dependency;
    }

    @Override
    public io.undertow.servlet.api.SessionManagerFactory apply(SessionManagerFactory<ServletContext, Map<String, Object>, Batch> factory) {
        return new DistributableSessionManagerFactory(factory, this.configuration);
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName());
        Consumer factory = this.dependency.register(builder).provides(new ServiceName[]{this.getServiceName()});
        FunctionalService service = new FunctionalService(factory, (Function)this, this.dependency);
        return builder.setInstance((Service)service).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }
}

