/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.lang.invoke.MethodHandles;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.annotation.concurrent.GuardedBy;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.protocol.core.Channel;
import org.apache.activemq.artemis.core.protocol.core.ChannelHandler;
import org.apache.activemq.artemis.core.replication.ReplicationEndpoint;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.NodeLocator;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.cluster.ClusterControl;
import org.apache.activemq.artemis.core.server.cluster.ClusterController;
import org.apache.activemq.artemis.core.server.cluster.ha.ReplicationBackupPolicy;
import org.apache.activemq.artemis.core.server.impl.Activation;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.AnyNodeLocatorForReplication;
import org.apache.activemq.artemis.core.server.impl.NamedNodeIdLocatorForReplication;
import org.apache.activemq.artemis.core.server.impl.NamedNodeLocatorForReplication;
import org.apache.activemq.artemis.core.server.impl.ReplicationError;
import org.apache.activemq.artemis.core.server.impl.ReplicationObserver;
import org.apache.activemq.artemis.core.server.impl.ReplicationPrimaryActivation;
import org.apache.activemq.artemis.core.server.impl.quorum.ActivationSequenceStateMachine;
import org.apache.activemq.artemis.quorum.DistributedLock;
import org.apache.activemq.artemis.quorum.DistributedPrimitiveManager;
import org.apache.activemq.artemis.quorum.UnavailableStateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReplicationBackupActivation
extends Activation
implements DistributedPrimitiveManager.UnavailableManagerListener {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ReplicationBackupPolicy policy;
    private final ActiveMQServerImpl activeMQServer;
    private final String expectedNodeID;
    @GuardedBy(value="this")
    private boolean closed;
    private final DistributedPrimitiveManager distributedManager;
    private volatile ReplicationObserver replicationObserver;
    private volatile ReplicationEndpoint replicationEndpoint;
    private Consumer<ReplicationEndpoint> onReplicationEndpointCreation;
    private final AtomicBoolean stopping;

    public ReplicationBackupActivation(ActiveMQServerImpl activeMQServer, DistributedPrimitiveManager distributedManager, ReplicationBackupPolicy policy) {
        this.activeMQServer = activeMQServer;
        if (policy.isTryFailback()) {
            String coordinationId = policy.getPrimaryPolicy().getCoordinationId();
            if (coordinationId != null) {
                this.expectedNodeID = coordinationId;
            } else {
                SimpleString serverNodeID = activeMQServer.getNodeID();
                if (serverNodeID == null || serverNodeID.isEmpty()) {
                    throw new IllegalStateException("A failback activation must be biased around a specific NodeID");
                }
                this.expectedNodeID = serverNodeID.toString();
            }
        } else {
            this.expectedNodeID = null;
        }
        this.distributedManager = distributedManager;
        this.policy = policy;
        this.replicationObserver = null;
        this.replicationEndpoint = null;
        this.stopping = new AtomicBoolean(false);
    }

    public DistributedPrimitiveManager getDistributedManager() {
        return this.distributedManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUnavailableManagerEvent() {
        ReplicationBackupActivation replicationBackupActivation = this;
        synchronized (replicationBackupActivation) {
            if (this.closed) {
                return;
            }
        }
        logger.info("Unavailable quorum service detected: try restart server");
        this.asyncRestartServer(this.activeMQServer, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this;
        synchronized (object) {
            if (this.closed) {
                return;
            }
        }
        try {
            Object primaryLockWithInSyncReplica;
            String nodeId;
            object = this.activeMQServer;
            synchronized (object) {
                this.activeMQServer.setState(ActiveMQServer.SERVER_STATE.STARTED);
            }
            String coordinationId = this.policy.getPrimaryPolicy().getCoordinationId();
            if (coordinationId != null && !coordinationId.equals(nodeId = this.activeMQServer.getNodeManager().getNodeId().toString())) {
                ReplicationPrimaryActivation.applyCoordinationId(coordinationId, this.activeMQServer);
            }
            this.distributedManager.start();
            NodeManager nodeManager = this.activeMQServer.getNodeManager();
            if (nodeManager.getNodeActivationSequence() > 0L) {
                while (true) {
                    this.distributedManager.start();
                    try {
                        primaryLockWithInSyncReplica = ActivationSequenceStateMachine.tryActivate(this.activeMQServer.getNodeManager(), this.distributedManager, logger);
                    }
                    catch (UnavailableStateException canRecoverEx) {
                        this.distributedManager.stop();
                        continue;
                    }
                    catch (NodeManager.NodeManagerException fatalEx) {
                        logger.warn("Failed while auto-repairing activation sequence: stop server now", (Throwable)fatalEx);
                        this.asyncRestartServer(this.activeMQServer, false);
                        return;
                    }
                    break;
                }
                if (primaryLockWithInSyncReplica != null) {
                    if (!this.activeMQServer.initialisePart1(false)) {
                        return;
                    }
                    this.startAsPrimary((DistributedLock)primaryLockWithInSyncReplica);
                    return;
                }
            }
            this.distributedManager.addUnavailableManagerListener((DistributedPrimitiveManager.UnavailableManagerListener)this);
            this.activeMQServer.resetNodeManager();
            this.activeMQServer.moveServerData(this.policy.getMaxSavedReplicatedJournalsSize(), this.policy.isTryFailback());
            this.activeMQServer.getNodeManager().start();
            if (!this.activeMQServer.initialisePart1(false)) {
                return;
            }
            primaryLockWithInSyncReplica = this;
            synchronized (primaryLockWithInSyncReplica) {
                if (this.closed) {
                    return;
                }
            }
            ClusterController clusterController = this.activeMQServer.getClusterManager().getClusterController();
            logger.info("Apache ActiveMQ Artemis Backup Server version {} [{}] started, awaiting connection to a primary to start replication", (Object)this.activeMQServer.getVersion().getFullVersion(), (Object)this.activeMQServer.toString());
            clusterController.awaitConnectionToReplicationCluster();
            this.activeMQServer.getBackupManager().start();
            DistributedLock primaryLock = this.replicateAndFailover(clusterController);
            if (primaryLock == null) {
                return;
            }
            this.startAsPrimary(primaryLock);
        }
        catch (Exception e) {
            if ((e instanceof InterruptedException || e instanceof IllegalStateException) && !this.activeMQServer.isStarted()) {
                return;
            }
            ActiveMQServerLogger.LOGGER.initializationError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAsPrimary(DistributedLock primaryLock) throws Exception {
        this.activeMQServer.setHAPolicy(this.policy.getPrimaryPolicy());
        ActiveMQServerImpl activeMQServerImpl = this.activeMQServer;
        synchronized (activeMQServerImpl) {
            boolean stillPrimary;
            if (!this.activeMQServer.isStarted()) {
                primaryLock.close();
                return;
            }
            NodeManager nodeManager = this.activeMQServer.getNodeManager();
            try {
                nodeManager.stopBackup();
                ActivationSequenceStateMachine.ensureSequentialAccessToNodeData(this.activeMQServer.toString(), nodeManager, this.distributedManager, logger);
            }
            catch (Throwable fatal) {
                logger.warn(fatal.getMessage());
                this.asyncRestartServer(this.activeMQServer, false, false);
                throw new ActiveMQIllegalStateException("This server cannot ensure sequential access to broker data: activation is failed");
            }
            ActiveMQServerLogger.LOGGER.becomingActive(this.activeMQServer);
            this.activeMQServer.getStorageManager().start();
            this.activeMQServer.getBackupManager().activated();
            ReplicationPrimaryActivation primaryActivation = new ReplicationPrimaryActivation(this.activeMQServer, this.distributedManager, this.policy.getPrimaryPolicy());
            primaryLock.addListener((DistributedLock.UnavailableLockListener)primaryActivation);
            this.activeMQServer.setActivation(primaryActivation);
            this.activeMQServer.initialisePart2(false);
            try {
                stillPrimary = primaryLock.isHeldByCaller();
            }
            catch (UnavailableStateException e) {
                logger.warn(e.getMessage(), (Throwable)e);
                primaryActivation.onUnavailableLockEvent();
                throw new ActiveMQIllegalStateException("This server cannot check its role as a primary: activation is failed");
            }
            if (!stillPrimary) {
                primaryActivation.onUnavailableLockEvent();
                throw new ActiveMQIllegalStateException("This server is not primary anymore: activation is failed");
            }
            if (this.activeMQServer.getIdentity() != null) {
                ActiveMQServerLogger.LOGGER.serverIsActive(this.activeMQServer.getIdentity());
            } else {
                ActiveMQServerLogger.LOGGER.serverIsActive();
            }
            this.activeMQServer.completeActivation(true);
        }
    }

    private NodeLocator createNodeLocator(NodeLocator.BackupRegistrationListener registrationListener) {
        if (this.expectedNodeID != null) {
            assert (this.policy.isTryFailback());
            return new NamedNodeIdLocatorForReplication(this.expectedNodeID, registrationListener, this.policy.getRetryReplicationWait());
        }
        return this.policy.getGroupName() == null ? new AnyNodeLocatorForReplication(registrationListener, this.activeMQServer, this.policy.getRetryReplicationWait()) : new NamedNodeLocatorForReplication(this.policy.getGroupName(), registrationListener, this.policy.getRetryReplicationWait());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private DistributedLock replicateAndFailover(ClusterController clusterController) throws ActiveMQException, InterruptedException {
        RegistrationFailureForwarder registrationFailureForwarder = new RegistrationFailureForwarder();
        NodeLocator nodeLocator = this.createNodeLocator(registrationFailureForwarder);
        clusterController.addClusterTopologyListenerForReplication(nodeLocator);
        try {
            ReplicationObserver.ReplicationFailure failure;
            block29: while (true) {
                ReplicationBackupActivation replicationBackupActivation = this;
                // MONITORENTER : replicationBackupActivation
                if (this.closed) {
                    DistributedLock distributedLock = null;
                    // MONITOREXIT : replicationBackupActivation
                    return distributedLock;
                }
                // MONITOREXIT : replicationBackupActivation
                if (this.expectedNodeID != null) {
                    logger.info("awaiting connecting to node with NodeID = {}", (Object)this.expectedNodeID);
                }
                if ((failure = this.replicatePrimary(clusterController, nodeLocator, registrationFailureForwarder)) == null) {
                    Thread.sleep(clusterController.getRetryIntervalForReplicatedCluster());
                    continue;
                }
                if (!this.activeMQServer.isStarted()) {
                    DistributedLock distributedLock = null;
                    return distributedLock;
                }
                logger.debug("ReplicationFailure = {}", (Object)failure);
                switch (failure) {
                    case VoluntaryFailOver: 
                    case NonVoluntaryFailover: {
                        if (!this.stopping.compareAndSet(false, true)) {
                            DistributedLock distributedLock = null;
                            return distributedLock;
                        }
                        this.distributedManager.removeUnavailableManagerListener((DistributedPrimitiveManager.UnavailableManagerListener)this);
                        NodeManager nodeManager = this.activeMQServer.getNodeManager();
                        DistributedLock primaryLockWithInSyncReplica = null;
                        if (nodeManager.getNodeActivationSequence() > 0L) {
                            try {
                                primaryLockWithInSyncReplica = ActivationSequenceStateMachine.tryActivate(nodeManager, this.distributedManager, logger);
                            }
                            catch (Throwable error) {
                                logger.warn("Errored while attempting failover", error);
                                primaryLockWithInSyncReplica = null;
                            }
                        } else {
                            logger.error("Expected positive local activation sequence for NodeID = {} during fail-over, but was {}: restarting as backup", (Object)nodeManager.getNodeId(), (Object)nodeManager.getNodeActivationSequence());
                        }
                        assert (this.stopping.get());
                        if (primaryLockWithInSyncReplica != null) {
                            DistributedLock error = primaryLockWithInSyncReplica;
                            return error;
                        }
                        ActiveMQServerLogger.LOGGER.restartingAsBackupBasedOnQuorumVoteResults();
                        this.asyncRestartServer(this.activeMQServer, true, false);
                        DistributedLock error = null;
                        return error;
                    }
                    case RegistrationError: {
                        logger.error("Stopping broker because of critical registration error");
                        this.asyncRestartServer(this.activeMQServer, false);
                        DistributedLock error = null;
                        return error;
                    }
                    case AlreadyReplicating: {
                        logger.info("Primary broker was already replicating: retry sync with another primary");
                        continue block29;
                    }
                    case ClosedObserver: {
                        DistributedLock error = null;
                        return error;
                    }
                    case BackupNotInSync: {
                        long activationSequence = this.activeMQServer.getNodeManager().getNodeActivationSequence();
                        boolean restart = true;
                        if (activationSequence != 0L) {
                            SimpleString syncNodeId = this.activeMQServer.getNodeManager().getNodeId();
                            try {
                                this.activeMQServer.getNodeManager().setNodeActivationSequence(-1L);
                            }
                            catch (Throwable fatal) {
                                logger.error("Errored while resetting local activation sequence {} for NodeID = {}: stopping broker", new Object[]{activationSequence, syncNodeId, fatal});
                                restart = false;
                            }
                        }
                        if (restart) {
                            logger.info("Replication failure while initial sync not yet completed: restart as backup");
                        }
                        this.asyncRestartServer(this.activeMQServer, restart);
                        DistributedLock distributedLock = null;
                        return distributedLock;
                    }
                    case WrongNodeId: {
                        logger.error("Stopping broker because of wrong node ID communication from primary: maybe a misbehaving primary?");
                        this.asyncRestartServer(this.activeMQServer, false);
                        DistributedLock distributedLock = null;
                        return distributedLock;
                    }
                    case WrongActivationSequence: {
                        logger.error("Stopping broker because of wrong activation sequence communication from primary: maybe a misbehaving primary?");
                        this.asyncRestartServer(this.activeMQServer, false);
                        DistributedLock distributedLock = null;
                        return distributedLock;
                    }
                }
                break;
            }
            throw new AssertionError((Object)("Unsupported failure " + failure));
        }
        finally {
            ReplicationBackupActivation.silentExecution("Error on cluster topology listener for replication cleanup", () -> clusterController.removeClusterTopologyListenerForReplication(nodeLocator));
        }
    }

    private ReplicationObserver replicationObserver() {
        if (this.policy.isTryFailback()) {
            return ReplicationObserver.failbackObserver(this.activeMQServer.getNodeManager(), this.activeMQServer.getBackupManager(), this.activeMQServer.getScheduledPool(), this.expectedNodeID);
        }
        return ReplicationObserver.failoverObserver(this.activeMQServer.getNodeManager(), this.activeMQServer.getBackupManager(), this.activeMQServer.getScheduledPool());
    }

    /*
     * Exception decompiling
     */
    private ReplicationObserver.ReplicationFailure replicatePrimary(ClusterController clusterController, NodeLocator nodeLocator, RegistrationFailureForwarder registrationFailureForwarder) throws ActiveMQException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 3[TRYBLOCK], 2[TRYBLOCK]], but top level block is 37[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void silentExecution(String debugErrorMessage, Runnable task) {
        try {
            task.run();
        }
        catch (Throwable ignore) {
            logger.debug(debugErrorMessage, ignore);
        }
    }

    private static void closeChannelOf(ReplicationEndpoint replicationEndpoint) {
        if (replicationEndpoint == null) {
            return;
        }
        if (replicationEndpoint.getChannel() != null) {
            ReplicationBackupActivation.silentExecution("Error while closing replication endpoint channel", () -> replicationEndpoint.getChannel().close());
            replicationEndpoint.setChannel(null);
        }
    }

    private boolean asyncRestartServer(ActiveMQServer server, boolean restart) {
        return this.asyncRestartServer(server, restart, true);
    }

    private boolean asyncRestartServer(ActiveMQServer server, boolean restart, boolean checkStopping) {
        if (checkStopping && !this.stopping.compareAndSet(false, true)) {
            return false;
        }
        new Thread(() -> {
            if (server.getState() != ActiveMQServer.SERVER_STATE.STOPPED && server.getState() != ActiveMQServer.SERVER_STATE.STOPPING) {
                ActiveMQServer activeMQServer = server;
                synchronized (activeMQServer) {
                    if (server.getState() == ActiveMQServer.SERVER_STATE.STOPPED) {
                        return;
                    }
                    try {
                        server.stop(!restart);
                        if (restart) {
                            server.start();
                        }
                    }
                    catch (Exception e) {
                        if (restart) {
                            ActiveMQServerLogger.LOGGER.errorRestartingBackupServer(server, e);
                        }
                        ActiveMQServerLogger.LOGGER.errorStoppingServer(e);
                    }
                }
            }
        }).start();
        return true;
    }

    private ClusterControl tryLocateAndConnectToPrimary(NodeLocator nodeLocator, ClusterController clusterController) throws ActiveMQException {
        nodeLocator.locateNode();
        Pair<TransportConfiguration, TransportConfiguration> possiblePrimary = nodeLocator.getPrimaryConfiguration();
        String nodeID = nodeLocator.getNodeID();
        if (nodeID == null) {
            throw new RuntimeException("Could not establish the connection with any primary");
        }
        if (!this.policy.isTryFailback()) {
            assert (this.expectedNodeID == null);
            this.activeMQServer.getNodeManager().setNodeID(nodeID);
        } else assert (this.expectedNodeID.equals(nodeID));
        if (possiblePrimary == null) {
            return null;
        }
        ClusterControl primaryControl = ReplicationBackupActivation.tryConnectToNodeInReplicatedCluster(clusterController, (TransportConfiguration)possiblePrimary.getA());
        if (primaryControl != null) {
            return primaryControl;
        }
        return ReplicationBackupActivation.tryConnectToNodeInReplicatedCluster(clusterController, (TransportConfiguration)possiblePrimary.getB());
    }

    private static ClusterControl tryConnectToNodeInReplicatedCluster(ClusterController clusterController, TransportConfiguration tc) {
        try {
            if (tc != null) {
                return clusterController.connectToNodeInReplicatedCluster(tc);
            }
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean permanently, boolean restarting) throws Exception {
        ReplicationBackupActivation replicationBackupActivation = this;
        synchronized (replicationBackupActivation) {
            this.closed = true;
            ReplicationObserver replicationObserver = this.replicationObserver;
            if (replicationObserver != null) {
                replicationObserver.close();
            }
        }
        try {
            if (this.activeMQServer.getHAPolicy().isBackup()) {
                NodeManager nodeManager = this.activeMQServer.getNodeManager();
                this.activeMQServer.interruptActivationThread(nodeManager);
                if (nodeManager != null) {
                    nodeManager.stopBackup();
                }
            }
        }
        finally {
            this.distributedManager.stop();
        }
    }

    @Override
    public void preStorageClose() throws Exception {
    }

    private ReplicationEndpoint tryAuthorizeAndAsyncRegisterAsBackupToPrimary(ClusterControl primaryControl, ReplicationObserver primaryObserver) {
        ReplicationEndpoint replicationEndpoint = null;
        try {
            primaryControl.getSessionFactory().setReconnectAttempts(0);
            primaryObserver.listenConnectionFailuresOf(primaryControl.getSessionFactory());
            primaryControl.authorize();
            replicationEndpoint = new ReplicationEndpoint(this.activeMQServer, this.policy.isTryFailback(), primaryObserver);
            Consumer<ReplicationEndpoint> onReplicationEndpointCreation = this.onReplicationEndpointCreation;
            if (onReplicationEndpointCreation != null) {
                onReplicationEndpointCreation.accept(replicationEndpoint);
            }
            replicationEndpoint.setExecutor((Executor)this.activeMQServer.getExecutorFactory().getExecutor());
            ReplicationBackupActivation.connectToReplicationEndpoint(primaryControl, replicationEndpoint);
            replicationEndpoint.start();
            primaryControl.announceReplicatingBackupToPrimary(this.policy.isTryFailback(), this.policy.getClusterName());
            return replicationEndpoint;
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.replicationStartProblem(e);
            ActiveMQServerImpl.stopComponent(replicationEndpoint);
            ReplicationBackupActivation.closeChannelOf(replicationEndpoint);
            return null;
        }
    }

    private static boolean connectToReplicationEndpoint(ClusterControl primaryControl, ReplicationEndpoint replicationEndpoint) {
        Channel replicationChannel = primaryControl.createReplicationChannel();
        replicationChannel.setHandler((ChannelHandler)replicationEndpoint);
        replicationEndpoint.setChannel(replicationChannel);
        return true;
    }

    @Override
    public boolean isReplicaSync() {
        ReplicationObserver primaryObserver = this.replicationObserver;
        if (primaryObserver == null) {
            return false;
        }
        return primaryObserver.isBackupUpToDate();
    }

    public ReplicationEndpoint getReplicationEndpoint() {
        return this.replicationEndpoint;
    }

    public void spyReplicationEndpointCreation(Consumer<ReplicationEndpoint> onReplicationEndpointCreation) {
        Objects.requireNonNull(onReplicationEndpointCreation);
        this.onReplicationEndpointCreation = onReplicationEndpointCreation;
    }

    private static /* synthetic */ void lambda$replicatePrimary$2(ClusterController clusterController, ReplicationError replicationError) {
        clusterController.removeIncomingInterceptorForReplication(replicationError);
    }

    private static /* synthetic */ void lambda$replicatePrimary$1(ClusterController clusterController, ReplicationObserver replicationObserver) {
        clusterController.removeClusterTopologyListener(replicationObserver);
    }

    private static final class RegistrationFailureForwarder
    implements NodeLocator.BackupRegistrationListener,
    AutoCloseable {
        private static final NodeLocator.BackupRegistrationListener NOOP_LISTENER = ignore -> {};
        private volatile NodeLocator.BackupRegistrationListener listener = NOOP_LISTENER;

        private RegistrationFailureForwarder() {
        }

        public RegistrationFailureForwarder to(NodeLocator.BackupRegistrationListener listener) {
            this.listener = listener;
            return this;
        }

        @Override
        public void onBackupRegistrationFailed(boolean alreadyReplicating) {
            this.listener.onBackupRegistrationFailed(alreadyReplicating);
        }

        @Override
        public void close() {
            this.listener = NOOP_LISTENER;
        }
    }
}

