/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.operations.common.AbstractXmlMarshallingHandler;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.dmr.ModelType;

public class XmlMarshallingHandler
extends AbstractXmlMarshallingHandler {
    private static final String OPERATION_NAME = "read-config-as-xml";

    public static SimpleOperationDefinitionBuilder createOperationDefinitionBuilder() {
        return new SimpleOperationDefinitionBuilder(OPERATION_NAME, ControllerResolver.getResolver(new String[0])).addAccessConstraint(SensitiveTargetAccessConstraintDefinition.READ_WHOLE_CONFIG).setReplyType(ModelType.STRING).setReadOnly().setRuntimeOnly();
    }

    public XmlMarshallingHandler(ConfigurationPersister configPersister) {
        super(configPersister);
    }

    @Override
    protected void attachResult(OperationContext context, ByteArrayOutputStream baos) {
        String xml = new String(baos.toByteArray(), StandardCharsets.UTF_8);
        context.getResult().set(xml.replace('\"', '\''));
    }
}

