/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.federation.internal;

import java.util.Objects;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.protocol.amqp.federation.Federation;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationConsumerInfo;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationReceiveFromAddressPolicy;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationReceiveFromQueuePolicy;
import org.apache.activemq.artemis.utils.CompositeAddress;

public class FederationGenericConsumerInfo
implements FederationConsumerInfo {
    public static final String FEDERATED_QUEUE_PREFIX = "federated";
    public static final String QUEUE_NAME_FORMAT_STRING = "${address}::${routeType}";
    private final FederationConsumerInfo.Role role;
    private final String address;
    private final String queueName;
    private final RoutingType routingType;
    private final String filterString;
    private final String fqqn;
    private final int priority;

    protected FederationGenericConsumerInfo(FederationConsumerInfo.Role role, String address, String queueName, RoutingType routingType, String filterString, String fqqn, int priority) {
        this.role = role;
        this.address = address;
        this.queueName = queueName;
        this.routingType = routingType;
        this.filterString = filterString;
        this.fqqn = fqqn;
        this.priority = priority;
    }

    public static FederationGenericConsumerInfo build(ServerConsumer consumer, Federation federation, FederationReceiveFromQueuePolicy policy) {
        Queue queue = consumer.getQueue();
        String queueName = queue.getName().toString();
        String address = queue.getAddress().toString();
        int priority = consumer.getPriority() + policy.getPriorityAjustment();
        SimpleString filterString = Filter.toFilterString((Filter)queue.getFilter());
        return new FederationGenericConsumerInfo(FederationConsumerInfo.Role.QUEUE_CONSUMER, address, queueName, queue.getRoutingType(), filterString != null ? filterString.toString() : null, CompositeAddress.toFullyQualified((String)address, (String)queueName), priority);
    }

    public static FederationGenericConsumerInfo build(String address, String queueName, RoutingType routingType, String filterString, Federation federation, FederationReceiveFromAddressPolicy policy) {
        return new FederationGenericConsumerInfo(FederationConsumerInfo.Role.ADDRESS_CONSUMER, address, queueName, routingType, filterString, CompositeAddress.toFullyQualified((String)address, (String)queueName), ActiveMQDefaultConfiguration.getDefaultConsumerPriority());
    }

    @Override
    public FederationConsumerInfo.Role getRole() {
        return this.role;
    }

    @Override
    public String getQueueName() {
        return this.queueName;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public String getFqqn() {
        return this.fqqn;
    }

    @Override
    public RoutingType getRoutingType() {
        return this.routingType;
    }

    @Override
    public String getFilterString() {
        return this.filterString;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FederationGenericConsumerInfo)) {
            return false;
        }
        FederationGenericConsumerInfo that = (FederationGenericConsumerInfo)o;
        return this.role == that.role && this.priority == that.priority && Objects.equals(this.address, that.address) && Objects.equals(this.queueName, that.queueName) && this.routingType == that.routingType && Objects.equals(this.filterString, that.filterString) && Objects.equals(this.fqqn, that.fqqn);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.role, this.address, this.queueName, this.routingType, this.filterString, this.fqqn, this.priority});
    }

    public String toString() {
        return "FederationConsumerInfo: { " + this.getRole() + ", " + this.getFqqn() + "}";
    }
}

