/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.boot.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmHibernateMapping;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmJoinedSubclassEntityType;
import org.hibernate.envers.boot.model.Attribute;
import org.hibernate.envers.boot.model.Key;
import org.hibernate.envers.boot.model.SubclassPersistentEntity;
import org.hibernate.envers.configuration.internal.metadata.AuditTableData;
import org.hibernate.envers.internal.tools.StringTools;
import org.hibernate.mapping.PersistentClass;

public class JoinedSubclassPersistentEntity
extends SubclassPersistentEntity {
    private final List<Attribute> attributes = new ArrayList<Attribute>();
    private String discriminatorValue;
    private Key key;

    public JoinedSubclassPersistentEntity(AuditTableData auditTableData, PersistentClass persistentClass) {
        super(auditTableData, persistentClass);
    }

    @Override
    public void addAttribute(Attribute attribute) {
        this.attributes.add(attribute);
    }

    public void setKey(Key key) {
        this.key = key;
    }

    public String getDiscriminatorValue() {
        return this.discriminatorValue;
    }

    public void setDiscriminatorValue(String discriminatorValue) {
        this.discriminatorValue = discriminatorValue;
    }

    @Override
    public void build(JaxbHbmHibernateMapping mapping) {
        mapping.getJoinedSubclass().add(this.buildJaxbMapping());
    }

    public JaxbHbmJoinedSubclassEntityType buildJaxbMapping() {
        JaxbHbmJoinedSubclassEntityType entity = new JaxbHbmJoinedSubclassEntityType();
        entity.setExtends(this.getExtends());
        if (this.getPersistentClass() != null) {
            entity.setAbstract(this.getPersistentClass().isAbstract());
        }
        if (!StringTools.isEmpty(this.getAuditTableData().getAuditEntityName())) {
            entity.setEntityName(this.getAuditTableData().getAuditEntityName());
        }
        if (!StringTools.isEmpty(this.getAuditTableData().getAuditTableName())) {
            entity.setTable(this.getAuditTableData().getAuditTableName());
        }
        if (!StringTools.isEmpty(this.getAuditTableData().getSchema())) {
            entity.setSchema(this.getAuditTableData().getSchema());
        }
        if (!StringTools.isEmpty(this.getAuditTableData().getCatalog())) {
            entity.setCatalog(this.getAuditTableData().getCatalog());
        }
        for (Attribute attribute : this.attributes) {
            entity.getAttributes().add((Serializable)attribute.build());
        }
        entity.setKey(this.key.build());
        if (!StringTools.isEmpty(this.discriminatorValue)) {
            entity.setDiscriminatorValue(this.discriminatorValue);
        }
        return entity;
    }
}

