/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.handlers.PathHandler;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ServiceRemoveStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.DynamicNameMappers;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.HttpInvokerHostService;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.extension.undertow.UndertowRootDefinition;
import org.wildfly.extension.undertow.UndertowSubsystemModel;
import org.wildfly.extension.undertow.logging.UndertowLogger;
import org.wildfly.security.auth.server.HttpAuthenticationFactory;

public class HttpInvokerDefinition
extends PersistentResourceDefinition {
    static final PathElement PATH_ELEMENT = PathElement.pathElement((String)"setting", (String)"http-invoker");
    static final RuntimeCapability<Void> HTTP_INVOKER_HOST_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.undertow.http-invoker.host", (boolean)true, Void.class).setDynamicNameMapper(DynamicNameMappers.PARENT).addRequirements(new String[]{"org.wildfly.undertow.http-invoker"}).build();
    static final SimpleAttributeDefinition HTTP_AUTHENTICATION_FACTORY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("http-authentication-factory", ModelType.STRING, true).setValidator((ParameterValidator)new StringLengthValidator(1, true))).setRestartAllServices()).setCapabilityReference("org.wildfly.security.http-authentication-factory")).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.AUTHENTICATION_FACTORY_REF)).setAlternatives(new String[]{"security-realm"})).build();
    protected static final SimpleAttributeDefinition SECURITY_REALM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("security-realm", ModelType.STRING, true).setRestartAllServices()).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, false))).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SECURITY_REALM_REF)).setAlternatives(new String[]{"http-authentication-factory"})).setDeprecated(UndertowSubsystemModel.VERSION_12_0_0.getVersion())).build();
    protected static final SimpleAttributeDefinition PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("path", ModelType.STRING, true).setValidator((ParameterValidator)new StringLengthValidator(1))).setDefaultValue(new ModelNode("wildfly-services"))).setRestartAllServices()).build();
    static final Collection<AttributeDefinition> ATTRIBUTES = Arrays.asList(PATH, HTTP_AUTHENTICATION_FACTORY, SECURITY_REALM);

    HttpInvokerDefinition() {
        super(new SimpleResourceDefinition.Parameters(PATH_ELEMENT, (ResourceDescriptionResolver)UndertowExtension.getResolver(PATH_ELEMENT.getValue())).setAddHandler((OperationStepHandler)new HttpInvokerAdd()).setRemoveHandler((OperationStepHandler)new HttpInvokerRemove()).setCapabilities(new RuntimeCapability[]{HTTP_INVOKER_HOST_CAPABILITY}));
    }

    public Collection<AttributeDefinition> getAttributes() {
        return ATTRIBUTES;
    }

    private static final class HttpInvokerAdd
    extends AbstractAddStepHandler {
        HttpInvokerAdd() {
            super(ATTRIBUTES);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            PathAddress address = context.getCurrentAddress();
            PathAddress hostAddress = address.getParent();
            PathAddress serverAddress = hostAddress.getParent();
            String path = PATH.resolveModelAttribute(context, model).asString();
            String httpAuthenticationFactory = null;
            ModelNode authFactory = HTTP_AUTHENTICATION_FACTORY.resolveModelAttribute(context, model);
            ModelNode securityRealm = SECURITY_REALM.resolveModelAttribute(context, model);
            if (authFactory.isDefined()) {
                httpAuthenticationFactory = authFactory.asString();
            } else if (securityRealm.isDefined()) {
                throw UndertowLogger.ROOT_LOGGER.runtimeSecurityRealmUnsupported();
            }
            String serverName = serverAddress.getLastElement().getValue();
            String hostName = hostAddress.getLastElement().getValue();
            CapabilityServiceBuilder sb = context.getCapabilityServiceTarget().addCapability(HTTP_INVOKER_HOST_CAPABILITY);
            Supplier hSupplier = sb.requiresCapability("org.wildfly.undertow.host", Host.class, new String[]{serverName, hostName});
            Supplier hafSupplier = null;
            Supplier phSupplier = sb.requiresCapability(UndertowRootDefinition.HTTP_INVOKER_RUNTIME_CAPABILITY.getName(), PathHandler.class, new String[0]);
            if (httpAuthenticationFactory != null) {
                hafSupplier = sb.requiresCapability("org.wildfly.security.http-authentication-factory", HttpAuthenticationFactory.class, new String[]{httpAuthenticationFactory});
            }
            sb.setInstance((Service)new HttpInvokerHostService(hSupplier, hafSupplier, phSupplier, path));
            sb.install();
        }
    }

    private static final class HttpInvokerRemove
    extends ServiceRemoveStepHandler {
        HttpInvokerRemove() {
            super((AbstractAddStepHandler)new HttpInvokerAdd());
        }

        protected ServiceName serviceName(String name, PathAddress address) {
            return HTTP_INVOKER_HOST_CAPABILITY.getCapabilityServiceName(address);
        }
    }
}

