/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.subsystem.resource;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.DelegatingResource;
import org.jboss.as.controller.registry.Resource;
import org.wildfly.subsystem.resource.ChildResourceProvider;

public class DynamicResource
extends DelegatingResource
implements Function<String, ChildResourceProvider> {
    private final Map<String, ChildResourceProvider> providers;
    private final BiFunction<Resource, Map<String, ChildResourceProvider>, Resource> factory;

    public DynamicResource(Resource resource, Map<String, ChildResourceProvider> providers) {
        this(resource, providers, DynamicResource::new);
    }

    protected DynamicResource(Resource resource, Map<String, ChildResourceProvider> providers, BiFunction<Resource, Map<String, ChildResourceProvider>, Resource> factory) {
        super(resource);
        this.providers = providers;
        this.factory = factory;
    }

    @Override
    public ChildResourceProvider apply(String childType) {
        return this.providers.get(childType);
    }

    public Resource clone() {
        return this.factory.apply(super.clone(), this.providers);
    }

    public Resource getChild(PathElement path) {
        ChildResourceProvider provider = this.apply(path.getKey());
        return provider != null ? provider.getChild(path.getValue()) : super.getChild(path);
    }

    public Set<Resource.ResourceEntry> getChildren(String childType) {
        ChildResourceProvider provider = this.apply(childType);
        if (provider != null) {
            Set<String> names = provider.getChildren();
            HashSet<Resource.ResourceEntry> entries = !names.isEmpty() ? new HashSet<Resource.ResourceEntry>() : Collections.emptySet();
            for (String name : names) {
                Resource resource = provider.getChild(name);
                entries.add(new SimpleResourceEntry(PathElement.pathElement((String)childType, (String)name), resource));
            }
            return entries;
        }
        return super.getChildren(childType);
    }

    public Set<String> getChildrenNames(String childType) {
        ChildResourceProvider provider = this.apply(childType);
        return provider != null ? provider.getChildren() : super.getChildrenNames(childType);
    }

    public Set<String> getChildTypes() {
        HashSet<String> childTypes = new HashSet<String>(super.getChildTypes());
        childTypes.addAll(this.providers.keySet());
        return childTypes;
    }

    public boolean hasChild(PathElement path) {
        ChildResourceProvider provider = this.apply(path.getKey());
        return provider != null ? provider.getChild(path.getValue()) != null : super.hasChild(path);
    }

    public boolean hasChildren(String childType) {
        ChildResourceProvider provider = this.apply(childType);
        return provider != null ? !provider.getChildren().isEmpty() : super.hasChildren(childType);
    }

    public Resource navigate(PathAddress address) {
        return address.size() == 1 ? this.requireChild(address.getLastElement()) : super.navigate(address);
    }

    public Resource requireChild(PathElement path) {
        Resource resource = this.getChild(path);
        if (resource == null) {
            throw new Resource.NoSuchResourceException(path);
        }
        return resource;
    }

    private static class SimpleResourceEntry
    extends DelegatingResource
    implements Resource.ResourceEntry {
        private final PathElement path;

        SimpleResourceEntry(PathElement path, Resource resource) {
            super(resource);
            this.path = path;
        }

        public String getName() {
            return this.path.getValue();
        }

        public PathElement getPathElement() {
            return this.path;
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof Resource.ResourceEntry)) {
                return false;
            }
            return this.path.equals(((Resource.ResourceEntry)object).getPathElement());
        }

        public String toString() {
            return this.path.toString();
        }
    }
}

