/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms.bridge;

import java.util.Hashtable;
import java.util.Properties;
import org.apache.activemq.artemis.jms.bridge.ConnectionFactoryFactory;
import org.apache.activemq.artemis.jms.bridge.DestinationFactory;
import org.apache.activemq.artemis.jms.bridge.JMSBridge;
import org.apache.activemq.artemis.jms.bridge.QualityOfServiceMode;
import org.apache.activemq.artemis.jms.bridge.impl.JMSBridgeImpl;
import org.apache.activemq.artemis.jms.bridge.impl.JNDIConnectionFactoryFactory;
import org.apache.activemq.artemis.jms.bridge.impl.JNDIDestinationFactory;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleNotFoundException;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq._private.MessagingLogger;
import org.wildfly.extension.messaging.activemq.jms.bridge.JMSBridgeDefinition;
import org.wildfly.security.manager.WildFlySecurityManager;

public class JMSBridgeFactory {
    public static JMSBridge createJMSBridge(OperationContext context, ModelNode model) throws OperationFailedException {
        Properties sourceContextProperties = JMSBridgeFactory.resolveContextProperties((AttributeDefinition)JMSBridgeDefinition.SOURCE_CONTEXT, context, model);
        String sourceConnectionFactoryName = JMSBridgeDefinition.SOURCE_CONNECTION_FACTORY.resolveModelAttribute(context, model).asString();
        JNDIConnectionFactoryFactory sourceCff = new JNDIConnectionFactoryFactory((Hashtable)sourceContextProperties, sourceConnectionFactoryName);
        String sourceDestinationName = JMSBridgeDefinition.SOURCE_DESTINATION.resolveModelAttribute(context, model).asString();
        JNDIDestinationFactory sourceDestinationFactory = new JNDIDestinationFactory((Hashtable)sourceContextProperties, sourceDestinationName);
        Properties targetContextProperties = JMSBridgeFactory.resolveContextProperties((AttributeDefinition)JMSBridgeDefinition.TARGET_CONTEXT, context, model);
        String targetConnectionFactoryName = JMSBridgeDefinition.TARGET_CONNECTION_FACTORY.resolveModelAttribute(context, model).asString();
        JNDIConnectionFactoryFactory targetCff = new JNDIConnectionFactoryFactory((Hashtable)targetContextProperties, targetConnectionFactoryName);
        String targetDestinationName = JMSBridgeDefinition.TARGET_DESTINATION.resolveModelAttribute(context, model).asString();
        JNDIDestinationFactory targetDestinationFactory = new JNDIDestinationFactory((Hashtable)targetContextProperties, targetDestinationName);
        String sourceUsername = JMSBridgeDefinition.SOURCE_USER.resolveModelAttribute(context, model).asStringOrNull();
        String sourcePassword = JMSBridgeDefinition.SOURCE_PASSWORD.resolveModelAttribute(context, model).asStringOrNull();
        String targetUsername = JMSBridgeDefinition.TARGET_USER.resolveModelAttribute(context, model).asStringOrNull();
        String targetPassword = JMSBridgeDefinition.TARGET_PASSWORD.resolveModelAttribute(context, model).asStringOrNull();
        String selector = CommonAttributes.SELECTOR.resolveModelAttribute(context, model).asStringOrNull();
        long failureRetryInterval = JMSBridgeDefinition.FAILURE_RETRY_INTERVAL.resolveModelAttribute(context, model).asLong();
        int maxRetries = JMSBridgeDefinition.MAX_RETRIES.resolveModelAttribute(context, model).asInt();
        QualityOfServiceMode qosMode = QualityOfServiceMode.valueOf((String)JMSBridgeDefinition.QUALITY_OF_SERVICE.resolveModelAttribute(context, model).asString());
        int maxBatchSize = JMSBridgeDefinition.MAX_BATCH_SIZE.resolveModelAttribute(context, model).asInt();
        long maxBatchTime = JMSBridgeDefinition.MAX_BATCH_TIME.resolveModelAttribute(context, model).asLong();
        String subName = JMSBridgeDefinition.SUBSCRIPTION_NAME.resolveModelAttribute(context, model).asStringOrNull();
        String clientID = JMSBridgeDefinition.CLIENT_ID.resolveModelAttribute(context, model).asStringOrNull();
        boolean addMessageIDInHeader = JMSBridgeDefinition.ADD_MESSAGE_ID_IN_HEADER.resolveModelAttribute(context, model).asBoolean();
        String moduleName = JMSBridgeDefinition.MODULE.resolveModelAttribute(context, model).asStringOrNull();
        ClassLoader oldTccl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            Module module;
            if (moduleName != null) {
                module = Module.getCallerModuleLoader().loadModule(ModuleIdentifier.fromString((String)moduleName));
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)module.getClassLoader());
            }
            module = new JMSBridgeImpl((ConnectionFactoryFactory)sourceCff, (ConnectionFactoryFactory)targetCff, (DestinationFactory)sourceDestinationFactory, (DestinationFactory)targetDestinationFactory, sourceUsername, sourcePassword, targetUsername, targetPassword, selector, failureRetryInterval, maxRetries, qosMode, maxBatchSize, maxBatchTime, subName, clientID, addMessageIDInHeader).setBridgeName(context.getCurrentAddressValue());
            return module;
        }
        catch (ModuleNotFoundException e) {
            throw MessagingLogger.ROOT_LOGGER.moduleNotFound(moduleName, e.getMessage(), e);
        }
        catch (ModuleLoadException e) {
            throw MessagingLogger.ROOT_LOGGER.unableToLoadModule(moduleName, e);
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTccl);
        }
    }

    public static Properties resolveContextProperties(AttributeDefinition attribute, OperationContext context, ModelNode model) throws OperationFailedException {
        ModelNode contextModel = attribute.resolveModelAttribute(context, model);
        Properties contextProperties = new Properties();
        if (contextModel.isDefined()) {
            for (Property property : contextModel.asPropertyList()) {
                contextProperties.put(property.getName(), property.getValue().asString());
            }
        }
        return contextProperties;
    }
}

