/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.io.File;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.function.Supplier;
import javax.crypto.SecretKey;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.IntAllowedValuesValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.StartException;
import org.wildfly.common.function.ExceptionRunnable;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.extension.elytron.AbstractCredentialStoreResourceDefinition;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.DoohickeyAddHandler;
import org.wildfly.extension.elytron.ElytronDoohickey;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.FileAttributeDefinitions;
import org.wildfly.extension.elytron.ServiceUtil;
import org.wildfly.extension.elytron.TrivialCapabilityServiceRemoveHandler;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.SecretKeyCredential;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.encryption.SecretKeyUtil;

class SecretKeyCredentialStoreDefinition
extends AbstractCredentialStoreResourceDefinition {
    private static final String CREDENTIAL_STORE_TYPE = "PropertiesCredentialStore";
    private static final ServiceUtil<CredentialStore> SECRET_KEY_CREDENTIAL_STORE_UTIL = ServiceUtil.newInstance(Capabilities.CREDENTIAL_STORE_RUNTIME_CAPABILITY, "secret-key-credential-store", CredentialStore.class);
    static final SimpleAttributeDefinition PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("path", FileAttributeDefinitions.PATH).setAttributeGroup("file")).setRequired(true)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition CREATE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("create", ModelType.BOOLEAN, true).setAttributeGroup("implementation")).setAllowExpression(true)).setDefaultValue(ModelNode.TRUE)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition POPULATE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("populate", ModelType.BOOLEAN, true).setAttributeGroup("implementation")).setAllowExpression(true)).setDefaultValue(ModelNode.TRUE)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition KEY_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("key-size", ModelType.INT, true).setAttributeGroup("implementation")).setAllowExpression(true)).setDefaultValue(new ModelNode(256))).setValidator((ParameterValidator)new IntAllowedValuesValidator(new int[]{128, 192, 256}))).setRestartAllServices()).build();
    static final SimpleAttributeDefinition DEFAULT_ALIAS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("default-alias", ModelType.STRING, true).setAttributeGroup("implementation")).setAllowExpression(true)).setDefaultValue(new ModelNode("key"))).setRestartAllServices()).build();
    private static final StandardResourceDescriptionResolver RESOURCE_RESOLVER = ElytronExtension.getResourceDescriptionResolver("secret-key-credential-store");
    static final AttributeDefinition[] CONFIG_ATTRIBUTES = new AttributeDefinition[]{FileAttributeDefinitions.RELATIVE_TO, PATH, CREATE, POPULATE, KEY_SIZE, DEFAULT_ALIAS};
    private static final AbstractAddStepHandler ADD = new SecretKeyCredentialStoreAddHandler();
    private static final OperationStepHandler REMOVE = new TrivialCapabilityServiceRemoveHandler(ADD, Capabilities.CREDENTIAL_STORE_RUNTIME_CAPABILITY);
    private static final SimpleOperationDefinition REMOVE_ALIAS = new SimpleOperationDefinitionBuilder("remove-alias", (ResourceDescriptionResolver)OPERATION_RESOLVER).setParameters(new AttributeDefinition[]{ALIAS}).setRuntimeOnly().build();
    private static final SimpleAttributeDefinition KEY_SIZE_PARAMETER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("key-size", ModelType.INT, true).setAllowExpression(true)).setAllowedValues(new int[]{128, 192, 256})).setRestartAllServices()).build();
    private static final SimpleOperationDefinition GENERATE_SECRET_KEY = new SimpleOperationDefinitionBuilder("generate-secret-key", (ResourceDescriptionResolver)OPERATION_RESOLVER).setParameters(new AttributeDefinition[]{ALIAS, KEY_SIZE_PARAMETER}).setRuntimeOnly().build();

    @Override
    protected ServiceUtil<CredentialStore> getCredentialStoreUtil() {
        return SECRET_KEY_CREDENTIAL_STORE_UTIL;
    }

    SecretKeyCredentialStoreDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"secret-key-credential-store"), (ResourceDescriptionResolver)RESOURCE_RESOLVER).setAddHandler((OperationStepHandler)ADD).setRemoveHandler(REMOVE).setAddRestartLevel(OperationEntry.Flag.RESTART_NONE).setRemoveRestartLevel(OperationEntry.Flag.RESTART_NONE).setCapabilities(new RuntimeCapability[]{Capabilities.CREDENTIAL_STORE_RUNTIME_CAPABILITY}));
    }

    @Override
    protected AttributeDefinition[] getAttributeDefinitions() {
        return CONFIG_ATTRIBUTES;
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        boolean isServerOrHostController = ElytronExtension.isServerOrHostController((ImmutableManagementResourceRegistration)resourceRegistration);
        HashMap<String, AbstractCredentialStoreResourceDefinition.CredentialStoreRuntimeOperation> operationMethods = new HashMap<String, AbstractCredentialStoreResourceDefinition.CredentialStoreRuntimeOperation>();
        operationMethods.put("read-aliases", this::readAliasesOperation);
        if (isServerOrHostController) {
            operationMethods.put("remove-alias", this::removeAliasOperation);
            operationMethods.put("export-secret-key", this::exportSecretKeyOperation);
            operationMethods.put("generate-secret-key", this::generateSecretKeyOperation);
            operationMethods.put("import-secret-key", this::importSecretKeyOperation);
        }
        AbstractCredentialStoreResourceDefinition.CredentialStoreRuntimeHandler operationHandler = new AbstractCredentialStoreResourceDefinition.CredentialStoreRuntimeHandler(operationMethods);
        resourceRegistration.registerOperationHandler((OperationDefinition)READ_ALIASES, (OperationStepHandler)operationHandler);
        if (isServerOrHostController) {
            resourceRegistration.registerOperationHandler((OperationDefinition)REMOVE_ALIAS, (OperationStepHandler)operationHandler);
            resourceRegistration.registerOperationHandler((OperationDefinition)EXPORT_SECRET_KEY, (OperationStepHandler)operationHandler);
            resourceRegistration.registerOperationHandler((OperationDefinition)GENERATE_SECRET_KEY, (OperationStepHandler)operationHandler);
            resourceRegistration.registerOperationHandler((OperationDefinition)IMPORT_SECRET_KEY, (OperationStepHandler)operationHandler);
            resourceRegistration.registerOperationHandler((OperationDefinition)RELOAD, RELOAD_HANDLER);
        }
    }

    void removeAliasOperation(OperationContext context, ModelNode operation, CredentialStore credentialStore) throws OperationFailedException {
        super.removeAliasOperation(context, operation, credentialStore, SecretKeyCredential.class);
    }

    protected void generateSecretKeyOperation(OperationContext context, ModelNode operation, CredentialStore credentialStore) throws OperationFailedException {
        int keySize;
        ModelNode keySizeModel = KEY_SIZE_PARAMETER.resolveModelAttribute(context, operation);
        if (keySizeModel.isDefined()) {
            keySize = keySizeModel.asInt();
        } else {
            ModelNode resourceModel = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
            keySize = KEY_SIZE.resolveModelAttribute(context, resourceModel).asInt();
        }
        this.generateSecretKeyOperation(context, operation, credentialStore, keySize);
    }

    static class SecretKeyDoohickey
    extends AbstractCredentialStoreResourceDefinition.AbstractCredentialStoreDoohickey {
        private volatile String relativeTo;
        private volatile String path;
        private volatile boolean create;
        private volatile boolean populate;
        private volatile int keySize;
        private volatile String defaultAlias;
        private volatile ExceptionRunnable<GeneralSecurityException> reloader;

        protected SecretKeyDoohickey(PathAddress resourceAddress) {
            super(resourceAddress);
        }

        @Override
        protected void resolveRuntime(ModelNode model, OperationContext context) throws OperationFailedException {
            this.relativeTo = FileAttributeDefinitions.RELATIVE_TO.resolveModelAttribute(context, model).asStringOrNull();
            this.path = PATH.resolveModelAttribute(context, model).asString();
            this.create = CREATE.resolveModelAttribute(context, model).asBoolean();
            this.populate = POPULATE.resolveModelAttribute(context, model).asBoolean();
            this.keySize = KEY_SIZE.resolveModelAttribute(context, model).asInt();
            this.defaultAlias = DEFAULT_ALIAS.resolveModelAttribute(context, model).asString();
        }

        @Override
        protected ExceptionSupplier<CredentialStore, StartException> prepareServiceSupplier(OperationContext context, CapabilityServiceBuilder<?> serviceBuilder) {
            Supplier pathManager;
            if (this.relativeTo != null) {
                pathManager = serviceBuilder.requires(PathManagerService.SERVICE_NAME);
                serviceBuilder.requires(FileAttributeDefinitions.pathName(this.relativeTo));
            } else {
                pathManager = null;
            }
            return new ExceptionSupplier<CredentialStore, StartException>(){

                public CredentialStore get() throws StartException {
                    try {
                        FileAttributeDefinitions.PathResolver pathResolver = FileAttributeDefinitions.pathResolver();
                        pathResolver.path(path);
                        if (relativeTo != null) {
                            pathResolver.relativeTo(relativeTo, (PathManager)pathManager.get());
                        }
                        File resolved = pathResolver.resolve();
                        pathResolver.clear();
                        return this.createCredentialStore(resolved);
                    }
                    catch (GeneralSecurityException e) {
                        throw ElytronSubsystemMessages.ROOT_LOGGER.unableToStartService(e);
                    }
                }
            };
        }

        @Override
        protected CredentialStore createImmediately(OperationContext foreignContext) throws OperationFailedException {
            try {
                return this.createCredentialStore(this.resolveRelativeToImmediately(this.path, this.relativeTo, foreignContext));
            }
            catch (GeneralSecurityException e) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.unableToCreateCredentialStoreImmediately(e);
            }
        }

        private CredentialStore createCredentialStore(File resolved) throws GeneralSecurityException {
            final CredentialStore credentialStore = CredentialStore.getInstance((String)SecretKeyCredentialStoreDefinition.CREDENTIAL_STORE_TYPE);
            final HashMap<String, String> configuration = new HashMap<String, String>();
            configuration.put("location", resolved.getAbsolutePath());
            if (this.create) {
                configuration.put("create", Boolean.TRUE.toString());
            }
            this.reloader = new ExceptionRunnable<GeneralSecurityException>(){

                public void run() throws GeneralSecurityException {
                    credentialStore.initialize(configuration);
                }
            };
            this.reloader.run();
            if (this.populate && !credentialStore.getAliases().contains(this.defaultAlias)) {
                SecretKey secretKey = SecretKeyUtil.generateSecretKey((int)this.keySize);
                SecretKeyCredential credential = new SecretKeyCredential(secretKey);
                credentialStore.store(this.defaultAlias, (Credential)credential);
                credentialStore.flush();
            }
            return credentialStore;
        }

        @Override
        protected void reload(OperationContext context) throws GeneralSecurityException, OperationFailedException {
            if (this.reloader != null) {
                this.reloader.run();
            } else {
                super.apply(context);
            }
        }
    }

    static class SecretKeyCredentialStoreAddHandler
    extends DoohickeyAddHandler<CredentialStore> {
        private SecretKeyCredentialStoreAddHandler() {
            super(Capabilities.CREDENTIAL_STORE_RUNTIME_CAPABILITY, CONFIG_ATTRIBUTES, "org.wildfly.security.credential-store-api");
        }

        @Override
        protected ElytronDoohickey<CredentialStore> createDoohickey(PathAddress resourceAddress) {
            return new SecretKeyDoohickey(resourceAddress);
        }
    }
}

