/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.job.model;

import jakarta.batch.operations.JobStartException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import org.jberet.creation.ArchiveXmlLoader;
import org.jberet.job.model.AbstractMerger;
import org.jberet.job.model.Flow;
import org.jberet.job.model.Job;
import org.jberet.job.model.JobElement;
import org.jberet.job.model.JobFactory;
import org.jberet.spi.JobXmlResolver;
import org.wildfly.security.manager.WildFlySecurityManager;

public final class FlowMerger
extends AbstractMerger<Flow> {
    FlowMerger(Job job, Flow child, ClassLoader classLoader, List<Job> loadedJobs, JobXmlResolver jobXmlResolver) throws JobStartException {
        super(job, classLoader, loadedJobs, jobXmlResolver);
        this.child = child;
        String parentName = child.getParent();
        String jslName = child.getJslName();
        if (jslName == null || jslName.equals("*") || jslName.equals(job.id)) {
            for (JobElement e : job.getJobElements()) {
                if (!parentName.equals(e.getId())) continue;
                this.parent = (Flow)e;
                break;
            }
        } else {
            Job jobOfParentFlow = ArchiveXmlLoader.loadJobXml(jslName, classLoader, loadedJobs, jobXmlResolver);
            for (JobElement e : jobOfParentFlow.getJobElements()) {
                if (!parentName.equals(e.getId())) continue;
                this.parent = (Flow)e;
            }
        }
    }

    public void merge() throws JobStartException {
        this.checkInheritingElements((Flow)this.parent, ((Flow)this.parent).getId());
        if (((Flow)this.parent).getParent() != null) {
            FlowMerger merger2 = new FlowMerger(this.currentJob, (Flow)this.parent, this.classLoader, this.loadedJobs, this.jobXmlResolver);
            this.recordInheritingElements(merger2);
            merger2.merge();
        }
        if (((Flow)this.child).getAttributeNext() == null) {
            ((Flow)this.child).next = ((Flow)this.parent).next;
        }
        ((Flow)this.child).jobElements.clear();
        ((Flow)this.child).jobElements = WildFlySecurityManager.isChecking() ? AccessController.doPrivileged(new PrivilegedAction<List<JobElement>>(){

            @Override
            public List<JobElement> run() {
                return JobFactory.cloneJobElements(((Flow)FlowMerger.this.parent).jobElements);
            }
        }) : JobFactory.cloneJobElements(((Flow)this.parent).jobElements);
        ((Flow)this.child).setParentAndJslName(null, null);
    }
}

