/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java.spi;

import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractClassJavaType;
import org.hibernate.type.descriptor.java.spi.JdbcTypeRecommendationException;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;

public class EmbeddableAggregateJavaType<T>
extends AbstractClassJavaType<T> {
    private final String structName;

    public EmbeddableAggregateJavaType(Class<T> type, String structName) {
        super(type);
        this.structName = structName;
    }

    @Override
    public JdbcType getRecommendedJdbcType(JdbcTypeIndicators context) {
        BasicType basicType = context.getTypeConfiguration().getBasicTypeForJavaType(this.getJavaType());
        if (basicType != null) {
            return basicType.getJdbcType();
        }
        if (this.structName != null) {
            return context.getJdbcType(2002);
        }
        JdbcType descriptor = context.getJdbcType(3001);
        if (descriptor != null) {
            return descriptor;
        }
        throw new JdbcTypeRecommendationException("Could not determine recommended JdbcType for `" + ((Class)this.getJavaType()).getTypeName() + "`");
    }

    @Override
    public String toString(T value) {
        return value.toString();
    }

    @Override
    public T fromString(CharSequence string) {
        throw new UnsupportedOperationException("Conversion from String strategy not known for this Java type : " + ((Class)this.getJavaType()).getTypeName());
    }

    @Override
    public <X> X unwrap(T value, Class<X> type, WrapperOptions options) {
        if (type.isAssignableFrom(this.getJavaTypeClass())) {
            return (X)value;
        }
        throw new UnsupportedOperationException("Unwrap strategy not known for this Java type : " + ((Class)this.getJavaType()).getTypeName());
    }

    @Override
    public <X> T wrap(X value, WrapperOptions options) {
        if (this.getJavaTypeClass().isInstance(value)) {
            return (T)value;
        }
        throw new UnsupportedOperationException("Wrap strategy not known for this Java type : " + ((Class)this.getJavaType()).getTypeName());
    }

    public String toString() {
        return "BasicJavaType(" + ((Class)this.getJavaType()).getTypeName() + ")";
    }
}

