/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.immutable;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.wildfly.clustering.ee.Immutability;

public class CollectionImmutability
implements Immutability {
    private final List<Class<?>> unmodifiableCollectionClasses = Arrays.asList(Collections.singleton(null).getClass(), Collections.singletonList(null).getClass(), Collections.unmodifiableCollection(Collections.emptyList()).getClass(), Collections.unmodifiableList(Collections.emptyList()).getClass(), Collections.unmodifiableNavigableSet(Collections.emptyNavigableSet()).getClass(), Collections.unmodifiableSet(Collections.emptySet()).getClass(), Collections.unmodifiableSortedSet(Collections.emptySortedSet()).getClass(), List.of().getClass(), List.of(Boolean.TRUE).getClass(), Set.of().getClass(), Set.of(Boolean.TRUE).getClass());
    private final List<Class<?>> unmodifiableMapClasses = Arrays.asList(Collections.singletonMap(null, null).getClass(), Collections.unmodifiableMap(Collections.emptyMap()).getClass(), Collections.unmodifiableNavigableMap(Collections.emptyNavigableMap()).getClass(), Collections.unmodifiableSortedMap(Collections.emptySortedMap()).getClass(), Map.ofEntries(new Map.Entry[0]).getClass(), Map.ofEntries(Map.entry(Boolean.TRUE, Boolean.TRUE)).getClass());
    private final Immutability elementImmutability;

    public CollectionImmutability(Immutability elementImmutability) {
        this.elementImmutability = elementImmutability;
    }

    @Override
    public boolean test(Object object) {
        for (Class<?> unmodifiableCollectionClass : this.unmodifiableCollectionClasses) {
            if (!unmodifiableCollectionClass.isInstance(object)) continue;
            for (Object element : (Collection)object) {
                if (this.elementImmutability.test(element)) continue;
                return false;
            }
            return true;
        }
        for (Class<?> unmodifiableMapClass : this.unmodifiableMapClasses) {
            if (!unmodifiableMapClass.isInstance(object)) continue;
            for (Map.Entry entry : ((Map)object).entrySet()) {
                if (this.test(entry)) continue;
                return false;
            }
            return true;
        }
        if (object instanceof AbstractMap.SimpleImmutableEntry) {
            return this.test((Map.Entry)object);
        }
        return false;
    }

    @Override
    private boolean test(Map.Entry<?, ?> entry) {
        return this.elementImmutability.test(entry.getKey()) && this.elementImmutability.test(entry.getValue());
    }
}

