/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.service.descriptor;

import java.util.Map;
import org.wildfly.common.Assert;
import org.wildfly.service.descriptor.ServiceDescriptor;
import org.wildfly.service.descriptor.TernaryServiceDescriptor;

public interface QuaternaryServiceDescriptor<T>
extends ServiceDescriptor<T> {
    default public Map.Entry<String, String[]> resolve(String greatGrandparent, String grandparent, String parent, String child) {
        return Map.entry(this.getName(), new String[]{(String)Assert.checkNotNullParamWithNullPointerException((String)"greatGrandparent", (Object)greatGrandparent), (String)Assert.checkNotNullParamWithNullPointerException((String)"grandparent", (Object)grandparent), (String)Assert.checkNotNullParamWithNullPointerException((String)"parent", (Object)parent), (String)Assert.checkNotNullParamWithNullPointerException((String)"child", (Object)child)});
    }

    @Override
    default public <U extends T> QuaternaryServiceDescriptor<U> asType(final Class<U> type) {
        return new QuaternaryServiceDescriptor<U>(){

            @Override
            public String getName() {
                return QuaternaryServiceDescriptor.this.getName();
            }

            @Override
            public Class<U> getType() {
                return type;
            }

            @Override
            public Map.Entry<String, String[]> resolve(String greatGrandparent, String grandparent, String parent, String child) {
                return QuaternaryServiceDescriptor.this.resolve(greatGrandparent, grandparent, parent, child);
            }
        };
    }

    public static <T> QuaternaryServiceDescriptor<T> of(final String name, final Class<T> type) {
        return new QuaternaryServiceDescriptor<T>(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public Class<T> getType() {
                return type;
            }
        };
    }

    public static <T> QuaternaryServiceDescriptor<T> of(final String name, final TernaryServiceDescriptor<T> defaultDescriptor) {
        return new QuaternaryServiceDescriptor<T>(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public Class<T> getType() {
                return defaultDescriptor.getType();
            }

            @Override
            public Map.Entry<String, String[]> resolve(String greatGrandparent, String grandparent, String parent, String child) {
                return child != null ? QuaternaryServiceDescriptor.super.resolve(greatGrandparent, grandparent, parent, child) : defaultDescriptor.resolve(greatGrandparent, grandparent, parent);
            }
        };
    }

    public static interface Provider<T>
    extends ServiceDescriptor.Provider<T, QuaternaryServiceDescriptor<T>>,
    QuaternaryServiceDescriptor<T> {
        @Override
        default public Map.Entry<String, String[]> resolve(String greatGrandparent, String grandparent, String parent, String child) {
            return ((QuaternaryServiceDescriptor)this.get()).resolve(greatGrandparent, grandparent, parent, child);
        }
    }
}

