/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.callback;

import java.security.Principal;
import java.util.function.Function;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.callback.ExtendedCallback;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.cache.CachedIdentity;
import org.wildfly.security.cache.IdentityCache;

public class CachedIdentityAuthorizeCallback
implements ExtendedCallback {
    private final Function<SecurityDomain, IdentityCache> identityCache;
    private final boolean localCache;
    private Principal principal;
    private boolean authorized;
    private SecurityDomain securityDomain;

    public CachedIdentityAuthorizeCallback(IdentityCache identityCache) {
        this(identityCache, false);
    }

    public CachedIdentityAuthorizeCallback(IdentityCache identityCache, boolean localCache) {
        this((SecurityDomain securityDomain1) -> identityCache, localCache);
    }

    public CachedIdentityAuthorizeCallback(Function<SecurityDomain, IdentityCache> identityCache, boolean localCache) {
        Assert.checkNotNullParam("identityCache", identityCache);
        this.identityCache = identityCache;
        this.localCache = localCache;
    }

    public CachedIdentityAuthorizeCallback(String name, IdentityCache identityCache) {
        this(new NamePrincipal(name), identityCache);
    }

    public CachedIdentityAuthorizeCallback(Principal principal, IdentityCache identityCache, boolean localCache) {
        this(principal, (SecurityDomain securityDomain) -> identityCache, localCache);
    }

    public CachedIdentityAuthorizeCallback(Principal principal, IdentityCache identityCache) {
        this(principal, (SecurityDomain securityDomain) -> identityCache, false);
    }

    public CachedIdentityAuthorizeCallback(Principal principal, Function<SecurityDomain, IdentityCache> identityCache, boolean localCache) {
        Assert.checkNotNullParam("principal", principal);
        Assert.checkNotNullParam("identityCache", identityCache);
        this.principal = principal;
        this.identityCache = identityCache;
        this.localCache = localCache;
    }

    public boolean isAuthorized() {
        return this.authorized;
    }

    public void setAuthorized(SecurityIdentity securityIdentity) {
        boolean bl = this.authorized = securityIdentity != null;
        if (this.authorized) {
            this.createDomainCache().put(securityIdentity);
        } else {
            this.createDomainCache().remove();
        }
    }

    public Principal getPrincipal() {
        CachedIdentity cachedIdentity = this.createDomainCache().get();
        if (cachedIdentity != null) {
            return new NamePrincipal(cachedIdentity.getName());
        }
        return null;
    }

    public Principal getAuthorizationPrincipal() {
        return this.principal;
    }

    public SecurityIdentity getIdentity() {
        CachedIdentity cachedIdentity = this.createDomainCache().get();
        if (cachedIdentity != null) {
            return cachedIdentity.getSecurityIdentity();
        }
        return null;
    }

    public boolean isLocalCache() {
        return this.localCache;
    }

    public void setSecurityDomain(SecurityDomain securityDomain) {
        Assert.checkNotNullParam("securityDomain", securityDomain);
        this.securityDomain = securityDomain;
    }

    @Override
    public boolean isOptional() {
        return false;
    }

    @Override
    public boolean needsInformation() {
        return false;
    }

    private IdentityCache createDomainCache() {
        return this.identityCache.apply(this.securityDomain);
    }
}

