/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.interceptors;

import jakarta.enterprise.inject.spi.InterceptionType;
import jakarta.interceptor.InvocationContext;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.weld.spi.ComponentInterceptorSupport;
import org.jboss.as.weld.spi.InterceptorInstances;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.weld.ejb.spi.InterceptorBindings;
import org.jboss.weld.serialization.spi.helpers.SerializableContextualInstance;

public class Jsr299BindingsInterceptor
implements Interceptor {
    private final InterceptionType interceptionType;
    private final ComponentInterceptorSupport interceptorSupport;
    private final Supplier<InterceptorBindings> interceptorBindingsSupplier;

    private Jsr299BindingsInterceptor(InterceptionType interceptionType, ComponentInterceptorSupport interceptorSupport, Supplier<InterceptorBindings> interceptorBindingsSupplier) {
        this.interceptionType = interceptionType;
        this.interceptorSupport = interceptorSupport;
        this.interceptorBindingsSupplier = interceptorBindingsSupplier;
    }

    public static InterceptorFactory factory(InterceptionType interceptionType, ServiceBuilder<?> builder, ServiceName interceptorBindingServiceName, ComponentInterceptorSupport interceptorSupport) {
        Supplier interceptorBindingsSupplier = builder.requires(interceptorBindingServiceName);
        return new ImmediateInterceptorFactory((Interceptor)new Jsr299BindingsInterceptor(interceptionType, interceptorSupport, interceptorBindingsSupplier));
    }

    protected Object delegateInterception(InvocationContext invocationContext, InterceptionType interceptionType, List<jakarta.enterprise.inject.spi.Interceptor<?>> currentInterceptors, InterceptorInstances interceptorInstances) throws Exception {
        ArrayList<Object> currentInterceptorInstances = new ArrayList<Object>();
        for (jakarta.enterprise.inject.spi.Interceptor<?> interceptor : currentInterceptors) {
            currentInterceptorInstances.add(((SerializableContextualInstance)interceptorInstances.getInstances().get(interceptor.getBeanClass().getName())).getInstance());
        }
        if (currentInterceptorInstances.size() > 0) {
            return this.interceptorSupport.delegateInterception(invocationContext, interceptionType, currentInterceptors, currentInterceptorInstances);
        }
        return invocationContext.proceed();
    }

    private Object doMethodInterception(InvocationContext invocationContext, InterceptionType interceptionType, InterceptorInstances interceptorInstances, InterceptorBindings interceptorBindings) throws Exception {
        if (interceptorBindings != null) {
            List currentInterceptors = interceptorBindings.getMethodInterceptors(interceptionType, invocationContext.getMethod());
            return this.delegateInterception(invocationContext, interceptionType, currentInterceptors, interceptorInstances);
        }
        return invocationContext.proceed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object processInvocation(InterceptorContext context) throws Exception {
        ComponentInstance componentInstance = (ComponentInstance)context.getPrivateData(ComponentInstance.class);
        InterceptorInstances interceptorInstances = this.interceptorSupport.getInterceptorInstances(componentInstance);
        InterceptorBindings interceptorBindings = this.interceptorBindingsSupplier.get();
        switch (this.interceptionType) {
            case AROUND_INVOKE: {
                return this.doMethodInterception(context.getInvocationContext(), InterceptionType.AROUND_INVOKE, interceptorInstances, interceptorBindings);
            }
            case AROUND_TIMEOUT: {
                return this.doMethodInterception(context.getInvocationContext(), InterceptionType.AROUND_TIMEOUT, interceptorInstances, interceptorBindings);
            }
            case PRE_DESTROY: {
                try {
                    Object object = this.doLifecycleInterception(context, interceptorInstances, interceptorBindings);
                    return object;
                }
                finally {
                    interceptorInstances.getCreationalContext().release();
                }
            }
            case POST_CONSTRUCT: {
                return this.doLifecycleInterception(context, interceptorInstances, interceptorBindings);
            }
            case AROUND_CONSTRUCT: {
                return this.doLifecycleInterception(context, interceptorInstances, interceptorBindings);
            }
        }
        return context.proceed();
    }

    private Object doLifecycleInterception(InterceptorContext context, InterceptorInstances interceptorInstances, InterceptorBindings interceptorBindings) throws Exception {
        if (interceptorBindings == null) {
            return context.proceed();
        }
        List currentInterceptors = interceptorBindings.getLifecycleInterceptors(this.interceptionType);
        return this.delegateInterception(context.getInvocationContext(), this.interceptionType, currentInterceptors, interceptorInstances);
    }
}

