/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.capability;

import java.util.Map;
import java.util.Optional;
import org.jboss.as.controller.capability.CapabilityServiceDescriptorResolver;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.msc.service.ServiceName;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.service.descriptor.NullaryServiceDescriptor;
import org.wildfly.service.descriptor.QuaternaryServiceDescriptor;
import org.wildfly.service.descriptor.TernaryServiceDescriptor;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;

public interface CapabilityServiceSupport
extends CapabilityServiceDescriptorResolver {
    public boolean hasCapability(String var1);

    default public boolean hasCapability(String capabilityName, String ... segments) {
        return this.hasCapability(RuntimeCapability.buildDynamicCapabilityName(capabilityName, segments));
    }

    default public boolean hasCapability(NullaryServiceDescriptor<?> descriptor) {
        return this.hasCapability(descriptor.getName());
    }

    default public boolean hasCapability(UnaryServiceDescriptor<?> descriptor, String name) {
        Map.Entry segments = descriptor.resolve(name);
        return this.hasCapability((String)segments.getKey(), (String[])segments.getValue());
    }

    default public boolean hasCapability(BinaryServiceDescriptor<?> descriptor, String parent, String child) {
        Map.Entry segments = descriptor.resolve(parent, child);
        return this.hasCapability((String)segments.getKey(), (String[])segments.getValue());
    }

    default public boolean hasCapability(TernaryServiceDescriptor<?> descriptor, String grandparent, String parent, String child) {
        Map.Entry segments = descriptor.resolve(grandparent, parent, child);
        return this.hasCapability((String)segments.getKey(), (String[])segments.getValue());
    }

    default public boolean hasCapability(QuaternaryServiceDescriptor<?> descriptor, String greatGrandparent, String grandparent, String parent, String child) {
        Map.Entry segments = descriptor.resolve(greatGrandparent, grandparent, parent, child);
        return this.hasCapability((String)segments.getKey(), (String[])segments.getValue());
    }

    public <T> T getCapabilityRuntimeAPI(String var1, Class<T> var2) throws NoSuchCapabilityException;

    public <T> T getCapabilityRuntimeAPI(String var1, String var2, Class<T> var3) throws NoSuchCapabilityException;

    public <T> Optional<T> getOptionalCapabilityRuntimeAPI(String var1, Class<T> var2);

    public <T> Optional<T> getOptionalCapabilityRuntimeAPI(String var1, String var2, Class<T> var3);

    public ServiceName getCapabilityServiceName(String var1);

    public ServiceName getCapabilityServiceName(String var1, String ... var2);

    @Override
    default public <T> ServiceName getCapabilityServiceName(NullaryServiceDescriptor<T> descriptor) {
        return this.getCapabilityServiceName(descriptor.getName());
    }

    @Override
    default public <T> ServiceName getCapabilityServiceName(UnaryServiceDescriptor<T> descriptor, String name) {
        Map.Entry resolved = descriptor.resolve(name);
        return this.getCapabilityServiceName((String)resolved.getKey(), (String[])resolved.getValue());
    }

    @Override
    default public <T> ServiceName getCapabilityServiceName(BinaryServiceDescriptor<T> descriptor, String parent, String child) {
        Map.Entry resolved = descriptor.resolve(parent, child);
        return this.getCapabilityServiceName((String)resolved.getKey(), (String[])resolved.getValue());
    }

    @Override
    default public <T> ServiceName getCapabilityServiceName(TernaryServiceDescriptor<T> descriptor, String grandparent, String parent, String child) {
        Map.Entry resolved = descriptor.resolve(grandparent, parent, child);
        return this.getCapabilityServiceName((String)resolved.getKey(), (String[])resolved.getValue());
    }

    @Override
    default public <T> ServiceName getCapabilityServiceName(QuaternaryServiceDescriptor<T> descriptor, String greatGrandparent, String grandparent, String parent, String child) {
        Map.Entry resolved = descriptor.resolve(greatGrandparent, grandparent, parent, child);
        return this.getCapabilityServiceName((String)resolved.getKey(), (String[])resolved.getValue());
    }

    public static class NoSuchCapabilityException
    extends Exception {
        static final long serialVersionUID = 1L;

        public NoSuchCapabilityException(String message) {
            super(message);
        }
    }
}

