/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.weld.injection;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.Bean;
import java.io.IOException;
import org.infinispan.protostream.descriptors.WireType;
import org.jboss.weld.Container;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedField;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.enhanced.jlr.EnhancedAnnotatedFieldImpl;
import org.jboss.weld.annotated.slim.AnnotatedTypeIdentifier;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedField;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedType;
import org.jboss.weld.injection.FieldInjectionPoint;
import org.jboss.weld.injection.InjectionPointFactory;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.serialization.spi.BeanIdentifier;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public class FieldInjectionPointMarshaller<T, X>
implements ProtoStreamMarshaller<FieldInjectionPoint<T, X>> {
    private static final int FIELD_INDEX = 1;
    private static final int BEAN_INDEX = 2;

    public Class<? extends FieldInjectionPoint<T, X>> getJavaClass() {
        return FieldInjectionPoint.class;
    }

    public FieldInjectionPoint<T, X> readFrom(ProtoStreamReader reader) throws IOException {
        BackedAnnotatedField field = null;
        BeanIdentifier beanId = null;
        block4: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    field = (BackedAnnotatedField)reader.readObject(BackedAnnotatedField.class);
                    continue block4;
                }
                case 2: {
                    beanId = (BeanIdentifier)reader.readAny(BeanIdentifier.class);
                    continue block4;
                }
            }
            reader.skipField(tag);
        }
        BackedAnnotatedType type = field.getDeclaringType();
        AnnotatedTypeIdentifier identifier = (AnnotatedTypeIdentifier)type.getIdentifier();
        BeanManagerImpl manager = Container.instance((AnnotatedTypeIdentifier)identifier).getBeanManager(identifier.getBdaId());
        ClassTransformer transformer = ClassTransformer.instance((BeanManagerImpl)manager);
        Bean bean = beanId != null ? (Bean)((ContextualStore)Container.instance((BeanManagerImpl)manager).services().get(ContextualStore.class)).getContextual(beanId) : null;
        EnhancedAnnotatedFieldImpl enhancedField = EnhancedAnnotatedFieldImpl.of((AnnotatedField)field, (EnhancedAnnotatedType)transformer.getEnhancedAnnotatedType((SlimAnnotatedType)type), (ClassTransformer)transformer);
        return InjectionPointFactory.silentInstance().createFieldInjectionPoint((EnhancedAnnotatedField)enhancedField, bean, type.getJavaClass(), manager);
    }

    public void writeTo(ProtoStreamWriter writer, FieldInjectionPoint<T, X> injectionPoint) throws IOException {
        Bean bean;
        BackedAnnotatedField field = (BackedAnnotatedField)injectionPoint.getAnnotated();
        if (field != null) {
            writer.writeObject(1, (Object)field);
        }
        if ((bean = injectionPoint.getBean()) != null) {
            BeanIdentifier beanId = ((ContextualStore)Container.instance((AnnotatedTypeIdentifier)field.getDeclaringType().getIdentifier()).services().get(ContextualStore.class)).putIfAbsent((Contextual)bean);
            writer.writeAny(2, (Object)beanId);
        }
    }
}

