/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.naming.Context;
import org.jgroups.JChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ActiveMQRaUtils {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    private ActiveMQRaUtils() {
    }

    public static boolean compare(String me, String you) {
        return Objects.equals(me, you);
    }

    public static boolean compare(Integer me, Integer you) {
        return Objects.equals(me, you);
    }

    public static boolean compare(Long me, Long you) {
        return Objects.equals(me, you);
    }

    public static boolean compare(Double me, Double you) {
        return Objects.equals(me, you);
    }

    public static boolean compare(Boolean me, Boolean you) {
        return Objects.equals(me, you);
    }

    public static Object lookup(Context context, String name, Class<?> clazz) throws Exception {
        return context.lookup(name);
    }

    public static Hashtable<String, String> parseHashtableConfig(String config) {
        String[] topElements;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (String element : topElements = config.split(";")) {
            String[] expression = element.split("=");
            if (expression.length != 2) {
                throw new IllegalArgumentException("Invalid expression " + element + " at " + config);
            }
            hashtable.put(expression[0].trim(), expression[1].trim());
        }
        return hashtable;
    }

    public static List<Map<String, Object>> parseConfig(String config) {
        String[] topElements;
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        String commaPlaceHolder = UUID.randomUUID().toString();
        String replaced = config.replace("\\,", commaPlaceHolder);
        for (String topElement : topElements = replaced.split(",")) {
            String[] elements;
            HashMap<String, String> map = new HashMap<String, String>();
            result.add(map);
            for (String element : elements = topElement.split(";")) {
                String[] expression = element.split("=");
                if (expression.length != 2) {
                    throw new IllegalArgumentException("Invalid expression " + element + " at " + config);
                }
                map.put(expression[0].trim(), expression[1].trim().replace(commaPlaceHolder, ","));
            }
        }
        return result;
    }

    public static List<String> parseConnectorConnectorConfig(String config) {
        String[] elements;
        ArrayList<String> res = new ArrayList<String>();
        for (String element : elements = config.split(",")) {
            res.add(element.trim());
        }
        return res;
    }

    public static JChannel locateJGroupsChannel(final String locatorClass, final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<JChannel>(){

            @Override
            public JChannel run() {
                try {
                    ClassLoader loader = Thread.currentThread().getContextClassLoader();
                    Class<?> aClass = loader.loadClass(locatorClass);
                    Object o = aClass.newInstance();
                    Method m = aClass.getMethod("locateChannel", String.class);
                    return (JChannel)m.invoke(o, name);
                }
                catch (Throwable e) {
                    logger.debug(e.getMessage(), e);
                    return null;
                }
            }
        });
    }

    private static Object safeInitNewInstance(final String className) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                ClassLoader loader = this.getClass().getClassLoader();
                try {
                    Class<?> clazz = loader.loadClass(className);
                    return clazz.newInstance();
                }
                catch (Throwable t) {
                    try {
                        loader = Thread.currentThread().getContextClassLoader();
                        if (loader != null) {
                            return loader.loadClass(className).newInstance();
                        }
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw new IllegalArgumentException("Could not find class " + className);
                }
            }
        });
    }
}

