/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.discovery;

import java.io.Serializable;
import org.wildfly.common.Assert;
import org.wildfly.discovery.FilterSpec;
import org.wildfly.discovery.ServiceType;

public final class ServiceDescription
implements Serializable {
    private static final long serialVersionUID = -3131354380283645867L;
    private final ServiceType serviceType;
    private final FilterSpec filterSpec;
    private transient int hashCode;

    public ServiceDescription(ServiceType serviceType, FilterSpec filterSpec) {
        Assert.checkNotNullParam((String)"serviceType", (Object)serviceType);
        Assert.checkNotNullParam((String)"filterSpec", (Object)filterSpec);
        this.serviceType = serviceType;
        this.filterSpec = filterSpec;
    }

    public ServiceType getServiceType() {
        return this.serviceType;
    }

    public FilterSpec getFilterSpec() {
        return this.filterSpec;
    }

    public boolean equals(Object obj) {
        return obj instanceof ServiceDescription && this.equals((ServiceDescription)obj);
    }

    public boolean equals(ServiceDescription other) {
        return other == this || other != null && this.serviceType.equals(other.serviceType) && this.filterSpec.equals(other.filterSpec);
    }

    public int hashCode() {
        int hashCode = this.hashCode;
        if (hashCode == 0) {
            hashCode = this.serviceType.hashCode() * 19 + this.filterSpec.hashCode();
            if (hashCode == 0) {
                hashCode = 1;
            }
            this.hashCode = hashCode;
            return this.hashCode;
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder b = new StringBuilder(48);
        this.serviceType.toString(b);
        b.append('(');
        this.filterSpec.toString(b);
        b.append(')');
        return b.toString();
    }
}

