/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.relay;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jgroups.Address;
import org.jgroups.EmptyMessage;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.View;
import org.jgroups.logging.Log;
import org.jgroups.protocols.relay.RELAY2;
import org.jgroups.protocols.relay.RelayHeader;
import org.jgroups.protocols.relay.Relayer;
import org.jgroups.protocols.relay.Route;
import org.jgroups.protocols.relay.SiteAddress;
import org.jgroups.protocols.relay.SiteUUID;
import org.jgroups.protocols.relay.config.RelayConfig;
import org.jgroups.stack.AddressGenerator;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;

public class Relayer2
extends Relayer {
    protected final Collection<Bridge> bridges = new ConcurrentLinkedQueue<Bridge>();

    public Relayer2(RELAY2 relay, Log log) {
        super(relay, log);
    }

    public void start(List<RelayConfig.BridgeConfig> bridge_configs, final String bridge_name, final String my_site_id) throws Throwable {
        if (this.done) {
            this.log.trace(String.valueOf(this.relay.getAddress()) + ": will not start the Relayer as stop() has been called");
            return;
        }
        try {
            for (RelayConfig.BridgeConfig bridge_config : bridge_configs) {
                Bridge bridge = new Bridge(bridge_config.createChannel(), bridge_config.getClusterName(), bridge_name, new AddressGenerator(){

                    @Override
                    public Address generateAddress() {
                        return new SiteUUID(UUID.randomUUID(), bridge_name, my_site_id);
                    }

                    @Override
                    public Address generateAddress(String name) {
                        return new SiteUUID(UUID.randomUUID(), name, my_site_id);
                    }
                });
                this.bridges.add(bridge);
            }
            for (Bridge bridge : this.bridges) {
                bridge.start();
            }
        }
        catch (Throwable t) {
            this.stop();
            throw t;
        }
        finally {
            if (this.done) {
                this.log.trace(String.valueOf(this.relay.getAddress()) + ": stop() was called while starting the relayer; stopping the relayer now");
                this.stop();
            }
        }
    }

    @Override
    public void stop() {
        this.done = true;
        this.bridges.forEach(Bridge::stop);
        this.bridges.clear();
    }

    @Override
    protected View getBridgeView(String cluster_name) {
        if (cluster_name == null || this.bridges == null) {
            return null;
        }
        for (Bridge bridge : this.bridges) {
            if (!Objects.equals(bridge.cluster_name, cluster_name)) continue;
            return bridge.view;
        }
        return null;
    }

    protected class Bridge
    implements Receiver {
        protected JChannel channel;
        protected final String cluster_name;
        protected View view;

        protected Bridge(JChannel ch, String cluster, String name, AddressGenerator gen) throws Exception {
            this.channel = ch;
            this.channel.setName(name);
            this.channel.setReceiver(this);
            this.channel.addAddressGenerator(gen);
            this.cluster_name = cluster;
        }

        protected void start() throws Exception {
            this.channel.connect(this.cluster_name);
            Relayer2.this.log.info("%s: joined bridge cluster '%s'", this.channel.getAddress(), this.cluster_name);
        }

        protected void stop() {
            Relayer2.this.log.info("%s: leaving bridge cluster '%s'", this.channel.getAddress(), this.channel.getClusterName());
            Util.close((Closeable)this.channel);
        }

        @Override
        public void receive(Message msg) {
            RelayHeader hdr = (RelayHeader)msg.getHeader(Relayer2.this.relay.getId());
            if (hdr == null) {
                Relayer2.this.log.warn("received a message without a relay header; discarding it");
                return;
            }
            switch (hdr.type) {
                case 6: {
                    RelayHeader rsp_hdr = new RelayHeader(7).addToSites(((RELAY2)Relayer2.this.relay).printLocalTopology());
                    Message topo_rsp = new EmptyMessage(msg.src()).putHeader(Relayer2.this.relay.getId(), rsp_hdr);
                    try {
                        this.channel.send(topo_rsp);
                    }
                    catch (Exception e) {
                        Relayer2.this.log.warn("%s: failed sending TOPO-RSP message to %s: %s", this.channel.getAddress(), msg.src(), e);
                    }
                    return;
                }
                case 7: {
                    Set<String> sites = hdr.getSites();
                    if (sites != null && !sites.isEmpty()) {
                        ((RELAY2)Relayer2.this.relay).topo_collector.add(msg.src(), sites.iterator().next());
                    }
                    return;
                }
            }
            Relayer2.this.relay.handleRelayMessage(msg);
        }

        @Override
        public void viewAccepted(View new_view) {
            this.view = new_view;
            Relayer2.this.log.trace("[Relayer " + String.valueOf(this.channel.getAddress()) + "] view: " + String.valueOf(new_view));
            Map<String, List<Address>> tmp = this.extract(new_view);
            HashSet<String> down2 = new HashSet<String>(Relayer2.this.routes.keySet());
            HashSet<String> up2 = new HashSet<String>();
            down2.removeAll(tmp.keySet());
            Relayer2.this.routes.keySet().retainAll(tmp.keySet());
            for (Map.Entry<String, List<Address>> entry : tmp.entrySet()) {
                ArrayList<Route> newRoutes;
                String key = entry.getKey();
                List<Address> val = entry.getValue();
                if (Relayer2.this.routes.containsKey(key)) {
                    newRoutes = new ArrayList((Collection)Relayer2.this.routes.get(key));
                } else {
                    newRoutes = new ArrayList<Route>();
                    if (up2 != null) {
                        up2.add(key);
                    }
                }
                newRoutes.removeIf(route -> !val.contains(route.siteMaster()));
                val.stream().filter(addr -> !this.contains((List<Route>)newRoutes, (Address)addr)).forEach(addr -> newRoutes.add(new Route((Address)addr, this.channel, Relayer2.this.relay, Relayer2.this.log).stats(Relayer2.this.stats)));
                if (newRoutes.isEmpty()) {
                    Relayer2.this.routes.remove(key);
                    down2.add(key);
                    up2.remove(key);
                    continue;
                }
                Relayer2.this.routes.put(key, Collections.unmodifiableList(newRoutes));
            }
            if (!down2.isEmpty()) {
                Relayer2.this.relay.sitesChange(true, down2);
            }
            if (!up2.isEmpty()) {
                Relayer2.this.relay.sitesChange(false, up2);
            }
        }

        protected boolean contains(List<Route> routes, Address addr) {
            return routes.stream().anyMatch(route -> route.siteMaster().equals(addr));
        }

        protected Map<String, List<Address>> extract(View view) {
            HashMap<String, List<Address>> map = new HashMap<String, List<Address>>(view.size());
            for (Address mbr : view) {
                SiteAddress member = (SiteAddress)mbr;
                String key = member.getSite();
                List list = map.computeIfAbsent(key, k -> new ArrayList());
                if (list.contains(member)) continue;
                list.add(member);
            }
            return map;
        }
    }
}

