/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.subsystem;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jboss.as.controller.Feature;
import org.jboss.as.controller.PersistentResourceXMLDescription;
import org.jboss.as.controller.PersistentResourceXMLDescriptionReader;
import org.jboss.as.controller.PersistentResourceXMLDescriptionWriter;
import org.jboss.as.controller.PersistentSubsystemSchema;
import org.jboss.as.controller.SubsystemSchema;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.version.Stability;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.wildfly.common.Assert;

public interface SubsystemPersistence<S extends SubsystemSchema<S>> {
    public Set<S> getSchemas();

    default public XMLElementReader<List<ModelNode>> getReader(S schema) {
        return schema;
    }

    public XMLElementWriter<SubsystemMarshallingContext> getWriter(Stability var1);

    public static <S extends Enum<S>> SubsystemPersistence<S> of(S currentSchema) {
        return SubsystemPersistence.of(EnumSet.of(currentSchema));
    }

    public static <S extends Enum<S>> SubsystemPersistence<S> of(Set<S> currentSchemas) {
        Assert.assertFalse((boolean)currentSchemas.isEmpty());
        final Class schemaClass = ((Enum)currentSchemas.iterator().next()).getDeclaringClass();
        final EnumMap currentXMLDescriptions = new EnumMap(schemaClass);
        for (Enum currentSchema : currentSchemas) {
            currentXMLDescriptions.put(currentSchema, ((PersistentSubsystemSchema)currentSchema).getXMLDescription());
        }
        final Map currentSchemaPerStability = Feature.map(currentSchemas);
        return new SubsystemPersistence<S>(){

            @Override
            public Set<S> getSchemas() {
                return EnumSet.allOf(schemaClass);
            }

            @Override
            public XMLElementReader<List<ModelNode>> getReader(S schema) {
                return Optional.ofNullable((PersistentResourceXMLDescription)currentXMLDescriptions.get(schema)).map(PersistentResourceXMLDescriptionReader::new).orElse((XMLElementReader)schema);
            }

            @Override
            public XMLElementWriter<SubsystemMarshallingContext> getWriter(Stability stability) {
                Enum currentSchema = (Enum)currentSchemaPerStability.get(stability);
                return new PersistentResourceXMLDescriptionWriter((PersistentResourceXMLDescription)currentXMLDescriptions.get(currentSchema));
            }
        };
    }

    public static <S extends Enum<S>> SubsystemPersistence<S> of(S currentSchema, XMLElementWriter<SubsystemMarshallingContext> writer) {
        return SubsystemPersistence.of(Map.of(currentSchema, writer));
    }

    public static <S extends Enum<S>> SubsystemPersistence<S> of(final Map<S, XMLElementWriter<SubsystemMarshallingContext>> currentWriters) {
        Assert.assertFalse((boolean)currentWriters.isEmpty());
        final Class schemaClass = ((Enum)currentWriters.keySet().iterator().next()).getDeclaringClass();
        return new SubsystemPersistence<S>(){

            @Override
            public Set<S> getSchemas() {
                return EnumSet.allOf(schemaClass);
            }

            @Override
            public XMLElementWriter<SubsystemMarshallingContext> getWriter(Stability stability) {
                return (XMLElementWriter)currentWriters.get(stability);
            }
        };
    }
}

