/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jsf.deployment;

import com.sun.faces.config.WebConfiguration;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.jsf.deployment.JSFModuleIdFactory;
import org.jboss.as.jsf.deployment.JsfVersionMarker;
import org.jboss.as.jsf.logging.JSFLogger;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.MultipartConfigMetaData;

public class JSFMetadataProcessor
implements DeploymentUnitProcessor {
    public static final String JAVAX_FACES_WEBAPP_FACES_SERVLET = "jakarta.faces.webapp.FacesServlet";
    private static final int DEFAULT_BUFFERS_IZE = -1;
    private final Boolean disallowDoctypeDecl;

    public JSFMetadataProcessor(Boolean disallowDoctypeDecl) {
        this.disallowDoctypeDecl = disallowDoctypeDecl;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        JBossWebMetaData webMetaData;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        WarMetaData metaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (JsfVersionMarker.isJsfDisabled(deploymentUnit)) {
            return;
        }
        JBossWebMetaData jBossWebMetaData = webMetaData = metaData != null ? metaData.getMergedJBossWebMetaData() : null;
        if (webMetaData == null || webMetaData.getServlets() == null) {
            return;
        }
        JBossServletMetaData jsf = null;
        for (JBossServletMetaData servlet : webMetaData.getServlets()) {
            if (!JAVAX_FACES_WEBAPP_FACES_SERVLET.equals(servlet.getServletClass())) continue;
            jsf = servlet;
        }
        if (jsf != null && jsf.getMultipartConfig() == null) {
            jsf.setMultipartConfig(new MultipartConfigMetaData());
        }
        if (this.disallowDoctypeDecl != null) {
            JSFMetadataProcessor.setContextParameterIfAbsent(webMetaData, WebConfiguration.BooleanWebContextInitParameter.DisallowDoctypeDecl.getQualifiedName(), this.disallowDoctypeDecl.toString());
        }
        if (webMetaData.getDistributable() != null) {
            String version;
            String disabled = Boolean.toString(false);
            if (!JSFMetadataProcessor.setContextParameterIfAbsent(webMetaData, WebConfiguration.BooleanWebContextInitParameter.EnableLazyBeanValidation.getQualifiedName(), disabled).equals(disabled)) {
                JSFLogger.ROOT_LOGGER.lazyBeanValidationEnabled();
            }
            if ((version = JsfVersionMarker.getVersion(deploymentUnit)).equals("Mojarra-4.0") && JSFModuleIdFactory.getInstance().getImplModId(version).getSlot().equals("main")) {
                JSFMetadataProcessor.setContextParameterIfAbsent(webMetaData, WebConfiguration.BooleanWebContextInitParameter.EnableDistributable.getQualifiedName(), Boolean.FALSE.toString());
            }
        }
        if (!JSFMetadataProcessor.hasContextParam(webMetaData, "facelets.BUFFER_SIZE")) {
            JSFMetadataProcessor.setContextParameterIfAbsent(webMetaData, "jakarta.faces.FACELETS_BUFFER_SIZE", Integer.toString(-1));
        }
    }

    private static String setContextParameterIfAbsent(JBossWebMetaData webMetaData, String name, String value) {
        ArrayList<ParamValueMetaData> contextParams = webMetaData.getContextParams();
        if (contextParams == null) {
            contextParams = new ArrayList<ParamValueMetaData>();
            webMetaData.setContextParams(contextParams);
        }
        for (ParamValueMetaData param : contextParams) {
            if (!name.equals(param.getParamName()) || param.getParamValue() == null) continue;
            return param.getParamValue();
        }
        ParamValueMetaData param = new ParamValueMetaData();
        param.setParamName(name);
        param.setParamValue(value);
        contextParams.add(param);
        return value;
    }

    private static boolean hasContextParam(JBossWebMetaData webMetaData, String name) {
        List contextParams = webMetaData.getContextParams();
        if (contextParams == null) {
            return false;
        }
        return contextParams.stream().anyMatch(value -> name.equals(value.getParamName()));
    }
}

